<?php 
	$base = base_url();
	$site = site_url();
?>

<div class="page katalog" style="padding-bottom: 100px">
    <section class="title">
        <h2>Produk</h2>
    </section>            
    <section class="content-wrap section">
        <div class="container d-flex justify-content-between align-items-start flex-wrap">
            <aside class="sidebar">
                <button class="fa fa-times _close d-none"></button>
                <div class="widget">
                    <h2>Kategori</h2>
                    <ul class="content">
                        <?php 
                            $idkat    = isset($_GET['kategori']) ? $_GET['kategori'] : null;
                            $idkat    = $idkat ? explode('-', $idkat) : [];
                            $idkat    = end($idkat);
                            $kategori = $this -> app -> get_kategori() 
                        ?>
                        <?php foreach($kategori as $kat) : ?>
                            <?php $active = $kat -> id == $idkat ? 'active' : null ?>
                            <li class="<?= $active ?>">
                                <a href="<?= slug($kat -> id, 'kategori') ?>" >
                                    <i class="fa fa-chevron-right me-2" style="font-size: 10px;position:relative;top:-2px"></i>
                                    <?= $kat -> nama ?>
                                </a>
                            </li>
                        <?php endforeach ?>
                       
                    </ul>
                </div>
                
            </aside>
            
            <div class="sec-produk prd-wrap">
                <div class="container">
                    <?php if($idkat) : ?>
                        <?php 
                            $namakat = $this -> app -> get_kategori($idkat, 'nama');
                            $namakat = $namakat ? $namakat : '-';     
                        ?>
                        <div class="alert alert-light border mb-4">
                            Menampilkan produk berdasarkan kategori <em><?= $namakat ?></em> 
                            <div class="mt-2">
                                <a href="<?= site_url('produk') ?>" class="badge badge-light border text-dark">
                                    Tampilkan semua
                                </a>
                            </div>
                        </div>
                    <?php endif ?>

                    <div class="sec-body d-flex flex-wrap"> 
                       
                    </div>

                    <div class="pagination mt-5">
                        <button class="btn btn-light border btn-lg px-5 w-100">
                            Lainnya
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
    $(function() {
        load(0);
    })

    function load(index) {
        $.post({
            url: base_url + 'proses/get_produk',
            data: {
                index: index,
                kategori: '<?= $idkat ?>'
            },
            dataType: 'html',
            success: function(data) {
                $('.sec-produk .sec-body').append(data);
            }
        })
    }

    $(document).on('click', '.pagination button', function() {
        let elm = $('article:last-child').data('index');
        let id  = $('article:last-child').data('index');
        let index = Number(elm) + 1;

        if(id != 0) {
            load(index);
        }
    });
</script>