<?php foreach($data as $title => $rows) : ?>
    <?php 
        $title = ucwords(str_replace('_', ' ', $title));
        $title = $title == 'Transfer Bank' ? $title . ' (Verifikasi manual)' : ($title == 'Saldo' ? 'Saldo' : $title . ' (Verifikasi otomatis)');   
    ?>
    <h6 class="px-3 py-2 border-bottom border-top">
        <strong>
            <?= $title ?>
        </strong>
    </h6>
    <?php foreach($rows as $item) : ?>
        <ul class="list-group list-group-flush">
            <?php 
                $total    = $this -> app -> total_keranjang();
                $fee      = $item -> fee_type == 'percent' ? $total * $item -> fee : $item -> fee;  
                $disabled = $item -> group == 'Saldo' && $total > $item -> saldo ? 'disable' : null;                
            ?>
            
            <li class="list-group-item pb-3 d-flex justify-content-between cursor-pointer btn_pilih_payment <?= $disabled ?>" 
                data-id="<?= $item -> code ?>"
                data-biaya="<?= $fee ?>"
                data-nama="<?= $item -> name ?>"
                data-gateway="<?= $item -> gateway ?>"
                data-icon="<?= $item -> icon ?>"
            >
                <div class="pe-3">
                    <img src="<?= $item -> icon ?>" class="w-px-30">
                </div>
                <div class="flex-grow-1" style="width: calc(100% - 30px)">
                    <div class="d-flex justify-content-between">
                        <span class="flex-grow-1">
                            <?= $item -> name ?>
                        </span>
                        <?php
                            if($item -> group == 'Saldo' && $total > $item -> saldo) {
                                echo '
                                    <button class="btn btn-danger ms-2 btn_topup">
                                        Top up
                                    </button>
                                ';
                            }
                        ?>
                    </div>
                    <div>
                        <small class="text-muted">
                            <?php
                                if($item -> group == 'Saldo') {
                                    echo format_uang($item -> saldo);

                                    if($total > $item -> saldo) {
                                        echo '
                                            <div class="mt-1 text-danger">
                                                Saldo anda tidak mencukupi!
                                            </div>
                                        ';
                                    }
                                } else {
                                    echo 'Biaya penanganan: ' . format_uang($fee); 
                                }
                            ?>
                        </small>
                    </div>
                </div>
            </li>
        </ul>
    <?php endforeach ?>
<?php endforeach ?>
