<div class="page keranjang">
    <section class="title">
        <h2>Keranjang</h2>
    </section> 

    <section class="content pb-4">
        
    </section>

    <section class="total-cart d-none">
        <div class="container">
            <div class="card">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <small class="mb-1 d-block">Total Keranjang</small>
                        <h6 class="text-danger mb-0">
                            <strong>
                                Rp0
                            </strong>
                        </h6>
                    </div>
                    <button class="btn btn-lg btn-primary px-3" onclick="window.location.href='<?= site_url('pembayaran') ?>'">
                        Pembayaran
                    </button>
                </div>
            </div>
        </div>
    </section>
</div>

<div class="modal fade" id="modal_ket">
    <div class="modal-dialog modal-sm modal-fullscreen-sm-down modal-dialog-scrollable">
        <div class="modal-content">
            
        </div>
    </div>
</div>

<div class="modal fade" id="modal_varian">
    <div class="modal-dialog modal-fullscreen-sm-down modal-dialog-scrollable modal-sm">
        <div class="modal-content">
            
        </div>
    </div>
</div>

<script>
    $(function() {
        load();
    });

    function load() {
        $.post({
            url: 'proses/get_keranjang',
            dataType: 'html',
            success: function(data) {
                $('.keranjang .content').html(data);

                let total_cart = Number($('.total_cart').val());
                let total_inp  = Number($('.total_inp').val());

                if(total_cart == 1) {
                    $('.total-cart').removeClass('d-none')
                } else {
                    $('.total-cart').addClass('d-none')
                }

                $('.total-cart strong').text('Rp' + nf(String(total_inp)));
            }
        })
    } 

    $(document).on('click', '.btn_change_varian', function() {
        let trx     = $(this).data('trx');
        let id      = $(this).data('id');
        let sub     = $(this).data('sub');
        let varian  = $(this).data('varian');
        let stok    = $(this).data('stok');

        $('#modal_varian').modal('show');
        $.post({
            url: base_url + 'proses/change_varian',
            data: {
                trx: trx,
                id: id,
                varian: varian,
                sub: sub
            },
            dataType: 'html',
            success: function(data) {
                $('#modal_varian .modal-content').html(data);
            }
        })
    })

    $(document).on('click', '.simpan-varian button', function() {
        let trx    = $('.varian_prd:checked').data('trx');
        let varian = $('.varian_prd:checked').data('id');
        let subvar = $('.varian_prd:checked').data('sub');

        $.post({
            url: base_url + 'proses/simpan_varian',
            data: {
                trx:trx,
                varian:varian,
                subvar:subvar,
            },
            dataType: 'json',
            success: function(json) {
                if(json.status == 1) {
                    $('.modal').modal('hide');
                    load();
                }
            }
        })
    })

    $(document).on('click', '.hps-cart', function() {
        let id = $(this).data('id');
        Swal.fire({
            icon: 'question',
            title: 'Apakah anda yakin',
            html: 'Item ini akan dihapus dari keranjang',
            showCancelButton: true,
            confirmButtonText:'Hapus',
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger me-3',
                cancelButton: 'btn btn-light',
            }
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/hps_cart',
                    data: {id:id},
                    dataType: 'json',
                    success: function(json) {
                        if(json.status == 1) {
                            load();
                        }
                    }
                })
            }
        })
    })

    $(document).on('click', '.add-note', function() {
        let trx     = $(this).data('trx');
        let id      = $(this).data('id');
        let varian  = $(this).data('varian');
        let sub     = $(this).data('sub');
       
        $('#modal_ket').modal('show');
        $.post({
            url: base_url + 'proses/addket',
            data: {
                trx: trx,
                id: id,
                varian: varian,
                sub: sub,
            },
            dataType: 'html',
            success: function(data) {
                $('#modal_ket .modal-content').html(data);
            }
        })
    })

    $(document).on('click', '.simpan_note', function() {
        let trx     = $('.note-inp').data('trx');
        let value   = $('.note-inp').val();
       
        $.post({
            url: base_url + 'proses/simpanket',
            data: {
                trx: trx,
                value: value,
            },
            dataType: 'json',
            success: function(json) {
                if(json.status == 1) {
                    $('.modal').modal('hide');
                    load();
                }
            }
        })
    })
</script>