<?php 
	$base = base_url();
	$site = site_url();
	$get_kurir = $this -> app -> kurir();
?>
<section class="sec-promo section">
	<div class="container">
		<div class="sec-body owl-carousel owl-theme promosi-slide">
			<a href="" class="_item">
				<img src="./upload/promo/b1.jpg" alt="slider">
			</a>
			
			<a href="" class="_item">
				<img src="./upload/promo/b2.jpg" alt="slider">
			</a>
			
			<a href="" class="_item">
				<img src="./upload/promo/b3.jpg" alt="slider">
			</a>
			
			<a href="" class="_item">
				<img src="./upload/promo/b4.jpg" alt="slider">
			</a>
			
		</div>
	</div>
</section>

<section class="sec-kategori section">
	<div class="container">
		<div class="sec-title">
			<h2>Kategori</h2>
		</div>
		<div class="sec-body d-flex flex-wrap">
			<a href="" class="_item d-flex align-items-center flex-wrap flex-column">
				<div class="_img">
					<img class="lazy" data-src="./upload/kategori/komputer.png" alt="Kategori">
				</div>
				<div class="_text">Komputer</div>
			</a>
			
			<a href="" class="_item d-flex align-items-center flex-wrap flex-column">
				<div class="_img">
					<img class="lazy" data-src="./upload/kategori/laptop.png" alt="Kategori">
				</div>
				<div class="_text">Laptop</div>
			</a>
			
			<a href="" class="_item d-flex align-items-center flex-wrap flex-column">
				<div class="_img">
					<img class="lazy" data-src="./upload/kategori/smartphone.png" alt="Kategori">
				</div>
				<div class="_text">Smartphone</div>
			</a>
			
			<a href="" class="_item d-flex align-items-center flex-wrap flex-column">
				<div class="_img">
					<img class="lazy" data-src="./upload/kategori/elektronik.png" alt="Kategori">
				</div>
				<div class="_text">Elektronik</div>
			</a>
			
			<a href="" class="_item d-flex align-items-center flex-wrap flex-column">
				<div class="_img">
					<img class="lazy" data-src="./upload/kategori/pakaian.png" alt="Kategori">
				</div>
				<div class="_text">Pakaian Pria & Wanita</div>
			</a>
			
			<a href="" class="_item d-flex align-items-center flex-wrap flex-column">
				<div class="_img">
					<img class="lazy" data-src="./upload/kategori/pakaian-bayi.png" alt="Kategori">
				</div>
				<div class="_text">Pakaian Bayi</div>
			</a>
			
		</div>
	</div>
</section>

<section class="sec-produk prd-wrap section">
	<div class="container">
		<div class="sec-title d-flex justify-content-between align-items-start">
			<div>
				<h2 class="mb-1"> 
					Produk
				</h2>
				<p class="mb-0">
					<span class="me-1">
						Produk Pilihan
					</span> 
				</p>
			</div>

			<?php if(count($this -> app -> get_produk()) > 0) : ?>
				<button class="btn btn-light bg-white bordor-0 text-right" onclick="window.location.href='<?= $site . 'produk' ?>'">
					Lihat Semua
				</button>
			<?php endif ?>
		</div>
		<div class="sec-body d-flex flex-wrap"> 
			<?php 
				$get = $this -> app -> get_produk(
					[
						'id' 		=> 'semua',
						'index' 	=> 0,
						'limit' 	=> 10,
						'random' 	=> true
					]
				);
				if($get) : foreach($get as $produk) :
			?>

					<article class="card" >
						<div class="card-header" onclick="window.location.href='<?= slug($produk -> id, 'produk') ?>'">
							<img class="lazy" 
								 alt="produk"
								 data-src="<?= $this -> app -> get_img_produk($produk -> id)  ?>"
							>
							<ul class="prd-label">
								<?php if($produk -> diskon_label && count($produk -> varian) == 0) : ?>
									<li>
										<a href="" class="_disc">
											Hemat 
											<?= $produk -> diskon_label ?>
										</a>
									</li>
								<?php endif ?>
								<?php if($produk -> cod == 1) : ?>
								<li>
									<a href="">
										COD
									</a>
								</li>
								<?php endif ?>
								<?php if($produk -> jenis == 'Digital') : ?>
									<li>
										<a href="" class="bg-warning">
											<?= $produk -> jenis ?>
										</a>
									</li>
								<?php endif ?>
							</ul>
						</div>
						<div class="card-body">
							<div class="mb-4">
								<p class="truncate-2 nama-prd mb-1">
									<?= $produk -> nama ?> 
								</p>
								<?php if($produk -> diskon > 0 && count($produk -> varian) == 0) : ?>
									<div class="harga-prd d-flex align-items-center">
										<p class="_normal">
											<?= short_uang($produk -> harga - $produk -> diskon) ?>
										</p>
										<p class="_coret">
											<?= short_uang($produk -> harga) ?>
										</p>
									</div>
								<?php else: ?>
									<div class="harga-prd d-flex align-items-center">
										<p class="_normal">
											<?= short_uang($produk -> range_min) ?>
										</p>
									</div>
								<?php endif ?>
								<?php if($produk -> preorder == 1) : ?>
									<div class="mt-2">
										<span class="badge badge-primary px-2">
											Pre order
										</span>
									</div>
								<?php endif ?>
							</div>
							<div class="prd-info d-flex justify-content-between align-items-start">
								<span>1.5Rb Terjual</span>
								<span>5.0 <i class="fa fa-star text-rate"></i></span>
							</div>
							<div class="prd-aksi">
								<button class="addCart" data-id="<?= $produk -> id ?>">
									<i class="fa fa-plus"></i>
									Keranjang
								</button>
							</div>
						</div>
					</article>  

				<?php endforeach ?>
			<?php else: ?>

				<article class="alert alert-light text-center w-100 py-4">
					<a href="" class="text-dark d-block">
						<img src="<?= $base . 'assets/img/empty-produk.png' ?>" alt="Belum ada produk" class="w-px-120">
					</a>
					<p class="mt-4 mb-0">
						Belum ada produk
					</p>
				</article>

			<?php endif ?>

		</div>
	</div>
</section>

<section class="section testimoni pb-5 ">
	<div class="container">
		<div class="sec-title">
			<div>
				<h2 class="mb-1"> 
					Ulasan
				</h2>
				<p class="mb-0">
					<span class="me-1">
						Apa kata mererka?
					</span> 
				</p>
			</div>
		</div>
		<div class="sec-body  owl-carousel owl-theme testi-slide">
			<div class="card">
				<div class="card-header d-flex flex-wrap align-items-center py-3">
					<div class="testi-img">
						<div class="text-img text-primary d-flex justify-content-center align-items-center bg-white">
							<strong>S</strong>
						</div>
					</div>
					<div class="testi-name ps-3 flex-grow-1">
						<strong class="d-block">
							Septian Wahyudi Rahman
						</strong>
						<small class="text-white-50">Admin</small>
					</div>
				</div>
				<div class="card-body py-4">
					Lorem ipsum dolor sit, amet consectetur adipisicing elit. Ipsam ad cum temporibus nam quidem velit at vitae commodi error recusandae, necessitatibus facilis cumque ab atque voluptate maxime assumenda culpa tempore ratione voluptatibus corporis odio reiciendis. A id, itaque consectetur facilis dolores quam repellendus quisquam ad! Numquam in distinctio corporis illo.
				</div>
				<div class="testi-ico">
					<i class="fa fa-comments"></i>
				</div>
			</div>                    
			<div class="card">
				<div class="card-header d-flex flex-wrap align-items-center py-3">
					<div class="testi-img">
						<img src="./upload/logo.png" >
					</div>
					<div class="testi-name ps-3 flex-grow-1">
						<strong class="d-block">
							Septian Wahyudi Rahman
						</strong>
						<small class="text-white-50">Admin</small>
					</div>
				</div>
				<div class="card-body py-4">
					Lorem ipsum dolor sit, amet consectetur adipisicing elit. Ipsam ad cum temporibus nam quidem velit at vitae commodi error recusandae
				</div>
				<div class="testi-ico">
					<i class="fa fa-comments"></i>
				</div>
			</div>                    
		</div>
	</div>
</section>

<section class="sec-metode section pb-3">
	<div class="container">
		<div class="sec-title">
			<h2>Channel Pembayaran</h2>
		</div>
		<div class="sec-body owl-carousel owl-theme bayar-list"> 
			<?php foreach($data_payment as $payment) :  ?>
				<?php if($payment -> code != 'CISA') :  ?>
					<div class="_items">
						<img src="<?= $payment -> icon ?>" alt="Bank Logo">
					</div>
				<?php endif ?>
			<?php endforeach ?>
		</div>
	</div>
</section>
<?php if($get_kurir) : ?>
	<section class="sec-metode section">
		<div class="container">
			<div class="sec-title">
				<h2>
					Jasa Pengiriman
				</h2>
			</div>
			<div class="kurir-list owl-carousel owl-theme">

				<?php foreach($get_kurir as $kurir) : ?>

					<div class="_items">
						<img src="<?= $kurir -> logo ?>" alt="Bank Logo">
					</div>

				<?php endforeach ?>	
				
			</div>
		</div>
	</section>
<?php endif ?>

<script>
	$('.promosi-slide').owlCarousel({
		loop: true,
		margin: 30, 
		autoplay: true,
		autoplayTimeout: 8000,
		autoplayHoverPause: true,
		smartSpeed: 700,
		nav: true,
		navText: [
			'<span class="fa fa-chevron-left"></span>',
			'<span class="fa fa-chevron-right"></span>'
		],
		responsive: {
			0: {
				items: 1
			},
			768: {
				items: 3,
				autoWidth: true,
				autoHeight: true,
			}
		}
	});

	$('.testi-slide').owlCarousel({
		loop: false,
		margin: 100, 
		smartSpeed: 700,
		nav: true,
		dots: false,
		navText: [
			'<span class="fa fa-chevron-left"></span>',
			'<span class="fa fa-chevron-right"></span>'
		],
		responsive: {
			0: {
				items: 1,
			},
			768: {
				items: 4,
			},
		}
	});

	$('.bayar-list, .kurir-list').owlCarousel({
		loop: true,
		margin: 20, 
		autoplay: true,
		autoplayTimeout: 6000,
		dots: false,
		nav: true,
		navText: [
			'<span class="fa fa-chevron-left"></span>',
			'<span class="fa fa-chevron-right"></span>'
		],
		responsive: {
			0: {
				items: 3,
				margin: 120, 
			},
			768: {
				autoWidth: true,
				autoHeight: true,
				items: 6,
			}
		}
	});
</script>