<?php  
    $_GET['tab']    = isset($_GET['tab']) ? $_GET['tab'] : 0;
    $_GET['produk'] = isset($_GET['produk']) ? $_GET['produk'] : 'digital';
    $tabs_status_1  = ['Belum Bayar', 'Diproses', 'Dikirim', 'Selesai', 'Dibatalkan'];
    $tabs_status_2  = ['Belum Bayar', 'Selesai', 'Dibatalkan'];
    $tabs_status    = $_GET['produk'] == 'fisik' ? $tabs_status_1 : $tabs_status_2; 
?>

<div class="page pesanan">
    <div class="title">
        <h2><?= $form_title ?></h2>
        <input type="hidden" id="jenis_produk" value="<?= $_GET['produk'] ?>">
        <input type="hidden" id="tab_active" value="<?= $_GET['tab'] ?>">
    </div>
    <div class="content">
        <article class="card">
            <div class="container text-center pt-3">
                <?php 
                    foreach($tabs_status as $code => $tab) {
                        $active = $code == $_GET['tab']  ? 'btn-primary' : 'bg-white';
                        echo '
                            <button class="btn '.$active.' px-4 mb-3 btn-sm btn_status" data-status="'.$code.'">
                                '.$tab.'
                            </button>
                        ';
                    }
                ?>
               
            </div>
        </div>

        <div class="order_list">
            <article class="card mt-2">
                <div class="container py-5">
                    <div class="d-flex justify-content-center flex-wrap">
                        <div class="mb-3">
                            <!-- <img src="<?= base_url('assets/img/empty-produk.png') ?>" class="w-px-120"> -->
                            <div class="d-flex spin_loader mt-3">
                                <div class="spinner-border spinner-border-sm text-primary me-2" role="status" style="position: relative; top: 3px"> 
                                    <span class="sr-only">Loading...</span> 
                                </div>
                                <span>Memuat data...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </article>
        </div>
    </div>
</div>

<script>
    $(function() {
        let status = $('#tab_active').val();
        load(status);
    })

    function load(status) {
        let produk = $('#jenis_produk').val();
        $.post({
            url: base_url + 'proses/pesanan',
            data: {
                status: status,
                jenis: produk
            },
            dataType: 'html',
            success: data => {
                $('.order_list').html(data);
            }
        })
    }

    $('.btn_status').on('click', function() {
        let status = $(this).data('status');
        $('#tab_active').val(status);
        $('.btn_status').removeClass('btn-primary');

        if($(this).hasClass('btn-primary')) {
            $(this).removeClass('btn-primary').addClass('bg-white');
        } else {
            $(this).addClass('btn-primary').removeClass('bg-white');
        }

        load(status);
    });
</script>