<div class="page favorit">
    <div class="title">
        <h2>Favorit</h2>
    </div>
    <div class="fav-list">
        <?php if($data) : ?>
            <?php foreach($data as $item) : ?>
                <article class="card mb-2">
                    <div class="container d-flex justify-content-between align-items-start py-4">
                        <div class="img" onclick="redirect('<?= slug($item -> id_produk, 'produk') ?>', 0)">
                            <img src="<?= $this -> app -> get_img_produk($item -> id_produk) ?>" >
                        </div>
                        <div class="text">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1 pe-3">
                                    <p class="truncate-2 mb-1">
                                        <?= $item -> nama_produk ?>
                                    </p>
                                </div>

                                <div class="">
                                    <small>
                                        <a href="javascript:void(0)" class="btn btn-sm btn-danger hps_fav w-px-100" data-id="<?= $item -> id ?>">
                                            <i class="fa fa-trash me-1"></i> 
                                            Hapus
                                        </a>
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </article> 
            <?php endforeach ?>
        <?php else: ?>
            <article class="card">
                <div class="container py-5 text-center">
                    <a href="" class="d-block">
                        <img src="<?= base_url('assets/img/wishlist.png') ?>" class="w-px-120">
                    </a>
                    <p class="mb-0 mt-4">
                        Belum ada favorit
                    </p>
                </div>
            </article>
        <?php endif ?>
    </div>
</div>

<script>
    $('.hps_fav').on('click', function() {
        let elm = $(this);
        let id  = elm.data('id');

        hps_alert.fire({
            html: 'Produk dihapus dari favorit',
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/favorit',
                    data: {
                        id_fav: id,
                        status: 0
                    },
                    dataType: 'json',
                    success: json => {
                        if(json.status == 1) {
                            toast({
                                title: 'Produk sudah dihapus dari favorit',
                                icon: 'info',
                            });
                            elm.closest('article').remove();
                            if($('article').length == 0) {
                                $('.fav-list').html(empty_fav)
                            }
                        }
                    }
                })
            }
        })        
    });

    function empty_fav() {
        return `
             <article class="card">
                <div class="container py-5 text-center">
                    <a href="" class="d-block">
                        <img src="<?= base_url('assets/img/wishlist.png') ?>" class="w-px-120">
                    </a>
                    <p class="mb-0 mt-4">
                        Belum ada favorit
                    </p>
                </div>
            </article>
        `;
    }
</script>