<div class="page alamat">
    <div class="title">
        <h2>Alamat Saya</h2>
    </div>
    <div>
        <?php if(!isset($aksi)) : ?>
            <div class="card">
                <div class="container pt-4">
                    <button class="btn btn-primary px-4 btn-full-mob" onclick="redirect('akun/alamat/form?aksi=tambah')">
                        <i class="fa fa-plus me-1"></i>
                        Tambah Alamat
                    </button>
                </div>
            </div>
            
            <?php if($data) : ?>
                <?php foreach($data as $item) : ?>
                    <article class="card mb-2 cursor-pointer">
                        <div class="container py-4 d-flex justify-content-between align-items-start">
                            <div class="flex-grow-1 pe-3"  onclick="redirect('akun/alamat/form?aksi=edit&id=' + <?= $item -> id ?>)">
                                <small class="text-muted">
                                    <i class="fa fa-map-marker-alt me-1"></i> 
                                    <?= $item -> judul ?> 
                                    <?= $item -> utama == 1 ? ' (Utama)' : '' ?>
                                </small>
                                <p class="mb-1">
                                    <?= $item -> penerima ?>
                                </p>
                                <p class="mb-1">
                                    <?= $item -> alamat ?>
                                </p>
                                <p class="mb-1">
                                    <?= $item -> kel ?>, 
                                    Kec. <?= $this -> app -> get_kec('semua', $item -> kec, 'nama') ?>
                                </p>
                                <p class="mb-1">
                                    <?= $this -> app -> get_kab('semua', $item -> kab, 'nama') ?>, 
                                    <?= $this -> app -> get_prov($item -> prov, 'nama') ?>
                                </p>
                                <p class="mb-0">
                                    <?= $item -> nohp ?>
                                </p>
                            </div>
                            <div class="ps-2">
                                <button class="btn btn-danger btn-sm" onclick="hps_addr(<?= $item -> id ?>)">
                                    <i class="fa fa-trash me-1"></i>
                                    Hapus
                                </button>
                            </div>
                        </div>
                    </article>
                <?php endforeach ?>
            <?php else: ?>
                 <div class="card">
                    <div class="container py-5 text-center">
                        <a href="" class="d-block">
                            <img src="<?= base_url('assets/img/location.png') ?>" class="w-px-120">
                        </a>
                        <p class="mb-0 mt-4">
                            Belum ada alamat
                        </p>
                    </div>
                </div>
            <?php endif ?>

        <?php else: ?>
            <div class="container pt-4">
                <button class="btn btn-primary px-4 btn-full-mob" onclick="redirect('akun/alamat/form?aksi=tambah&redirect=pembayaran')">
                    <i class="fa fa-plus me-1"></i>
                    Tambah Alamat
                </button>
            </div>

            <?php if($data) : ?>
                <?php foreach($data as $item) : ?>
                    <article class="card mb-2 cursor-pointer">
                        <div class="container py-4 d-flex justify-content-between align-items-start">
                            <div class="flex-grow-1 pe-3"  onclick="redirect('akun/alamat/form?aksi=edit&id=' + <?= $item -> id ?>)">
                                <small class="text-muted">
                                    <i class="fa fa-map-marker-alt me-1"></i> 
                                    <?= $item -> judul ?> 
                                    <?= $item -> utama == 1 ? ' (Utama)' : '' ?>
                                </small>
                                <p class="mb-1">
                                    <?= $item -> penerima ?>
                                </p>
                                <p class="mb-1">
                                    <?= $item -> alamat ?>
                                </p>
                                <p class="mb-1">
                                    <?= $item -> kel ?>, 
                                    Kec. <?= $this -> app -> get_kec('semua', $item -> kec, 'nama') ?>
                                </p>
                                <p class="mb-1">
                                    <?= $this -> app -> get_kab('semua', $item -> kab, 'nama') ?>, 
                                    <?= $this -> app -> get_prov($item -> prov, 'nama') ?>
                                </p>
                                <p class="mb-0">
                                    <?= $item -> nohp ?>
                                </p>
                            </div>
                            <div class="ps-2">
                                <button class="btn btn-primary btn-sm" onclick="pilih_addr(<?= $item -> id ?>)">
                                    <i class="fa fa-check-circle me-1"></i>
                                    Pilih
                                </button>
                            </div>
                        </div>
                    </article>
                <?php endforeach ?>
            <?php else: ?>
                 <div class="card">
                    <div class="container py-5 text-center">
                        <a href="" class="d-block">
                            <img src="<?= base_url('assets/img/location.png') ?>" class="w-px-120">
                        </a>
                        <p class="mb-0 mt-4">
                            Belum ada alamat
                        </p>
                    </div>
                </div>
            <?php endif ?>

        <?php endif ?>
    </div>
</div>

<script>
    function hps_addr(id) {
        hps_alert.fire({
            html: 'Alamat yang dihapus akan dihapus permanen',
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/hps_addr',
                    data: {id:id},
                    dataType: 'json',
                    success: json => {
                        if(json.status == 1) {                            
                            confirm_success.fire({
                                html: 'Alamat yang dipilih sudah dihapus',
                            }).then(res => {
                                location.reload();
                            })
                        }
                    }
                })
            }
        })
    }
    function pilih_addr(id) {
        $.post({
            url: base_url + 'proses/pilih_addr',
            data: {id:id},
            dataType: 'json',
            success: json => {
                if(json.status == 1) {
                    redirect('pembayaran');
                }
            }
        })
    }
</script>