<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Tripay extends CI_Controller {
    function index() {
        $this -> load -> model('Payment_model', 'tripay');
        $data = $this -> tripay -> detail_transaction();
        
        $conf = [
			'title'      => 'Invoice | ' . app('app_name'),
			'page_title' => 'Invoice',
			'backto'     => site_url(),   
            'data'       => $data
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('invoice');
		$this -> load -> view('layout/footer');
    }

    public function callback() {
        // $get          = file_get_contents('php://input');
        $get          = file_get_contents('./data.json');
        $privateKey   = app('tripay_privatekey'); 
        $signature    = hash_hmac('sha256', $get, $privateKey);
        $callback_sign = $this -> input -> get_request_header("X-Callback-Signature");
        $data         = json_decode($get);
        $today        = date('Y-m-d H:i:s');

        echo '<pre>';
        if($data) {
            if($data -> status == 'PAID') {
                $cekdata = $this -> db -> get_where('transaksi_tripay', ['reference' => $data -> reference]) -> row();
                $this -> db -> update('transaksi_tripay', ['status' => 'PAID'], ['reference' => $data -> reference]);
                
                if($cekdata -> jenis == 'topup') {
                    $getdata  = $this -> db -> get_where('saldo_topup', ['kode_ref' => $data -> merchant_ref, 'status' => 0]) -> row();
                    
                    if($getdata) {
                        $getsaldo    = $this -> db -> get_where('saldo', ['usrid' => $getdata -> usrid]) -> row();
                        $saldo_awal  =  $getsaldo ? $getsaldo -> saldo : 0;
                        $saldo_akhir =  $getsaldo -> saldo + $getdata -> nominal;

                        $this -> db -> update('saldo_topup', ['status' => 1, 'tgl_proses' => $today], ['kode_ref' => $data -> merchant_ref, 'status' => 0]);

                        if($getsaldo) {
                            $this -> db -> update('saldo', ['saldo' => $saldo_akhir], ['usrid' => $getdata -> usrid]);
                        } else {
                            $this -> db -> insert('saldo', ['saldo' => $saldo_akhir, 'usrid' => $getdata -> usrid]);
                        }

                        $riwayat = [
                            'kode_ref'      => $getdata -> kode_ref,
                            'usrid'         => $getdata -> usrid,
                            'nominal'       => $getdata -> nominal,
                            'saldo_awal'    => $saldo_awal,
                            'saldo_akhir'   => $saldo_akhir,
                            'tipe'          => 1,
                            'tgl'           => date('Y-m-d H:i:s'),
                            'keterangan'    => 'Top up Saldo'
                        ];
                        $this -> db -> insert('saldo_riwayat', $riwayat);

                        $url_notif  = site_url('saldo?detail=' . $getdata -> token);
                        $notif      = [
                            'jenis'     => 'topup_sukses',
                            'judul'     => 'Topup berhasil',
                            'usrid'     => $getdata -> usrid,
                            'url'       => $url_notif,
                            'deskripsi' => 'Topup saldo ' . $getdata -> kode_ref . ' berhasil. Saldo anda bertambah ' . format_uang($getdata -> nominal) 
                        ];
                        $this -> app -> push_notif($notif);
                    }
                    
                } else {
                    $getdata = $this -> db -> get_where('transaksi', ['invoice' => $data -> merchant_ref, 'status' => 0]) -> row();

                    if($getdata) { 
                        $detail = $this -> db -> get_where('transaksi_detail', ['id_transaksi' => $getdata -> id]) -> row();
                        $this -> db -> update('transaksi', ['status' => 1, 'tgl_proses' => $today], ['invoice' => $data -> merchant_ref, 'status' => 0]);
    
                        if($detail -> jenis == 'Fisik') {
                            $url_notif  = site_url('pesanan?produk=fisik&detail=' . $getdata -> token);
                            $notif      = [
                                'jenis'     => 'diproses',
                                'judul'     => 'Pesanan Sedang dikemas',
                                'usrid'     => $getdata -> usrid,
                                'url'       => $url_notif,
                                'deskripsi' => 'Pesanan ' . $getdata -> invoice . ' sedang diproses penjual.' 
                            ];
                        }
                
                        if($detail -> jenis == 'Digital') {
                            $url_notif = site_url('pesanan?produk=digital&detail=' . $getdata -> token);
                            $notif     = [
                                'jenis'     => 'Pesanan Selesai',
                                'judul'     => 'Pesanan Selesai',
                                'usrid'     => $getdata -> usrid,
                                'url'       => $url_notif,
                                'deskripsi' => 'Pesanan ' . $getdata -> invoice . ' sudah selesai.'
                            ];
                        }
                        
                        $this -> app -> push_notif($notif);
                    } 
                }
            } 
        }
        
        die;
        
        if($callback_sign == $signature) {
            

        } else {
            print_r(
                [
                    'success' => 0,
                    'msg' => 'Signature tidak sesuai' 
                ]
            );
        }
    }
}

// Controller Tripay
// Kode ini dibuat oleh codelingker