<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends CI_Controller {
	public function masuk() {
		$conf = [
			'title'        =>  'Masuk | ' . app('app_name'),
			'loading' 	   => true,
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('auth/login');
		$this -> load -> view('layout/footer');
	}

	public function daftar() {
		$conf = [
			'title'        =>  'Buat Akun | ' . app('app_name'),
			'loading' 	   => true,
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('auth/daftar');
		$this -> load -> view('layout/footer');
	}

	public function resetpass() {
		$conf = [
			'title'        => 'Reset kata sandi | ' . app('app_name'),
			'page_title'   => 'Reset kata sandi',
			'backto' 	   => site_url('auth/masuk')
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('auth/resetpass');
		$this -> load -> view('layout/footer');
	}

	public function proses_login() {
		$email 		= $this -> input -> post('email', TRUE);
		$password 	= $this -> input -> post('password', TRUE);
		$cek 	    = $this -> app -> get_user($email);

		if(empty($email)) {
			echo json_encode(['status' => 0, 'type' => 'email', 'msg' => 'Email belum diisi']);
			
		} else if(empty($password)) {
			echo json_encode(['status' => 0, 'type' => 'pass', 'msg' => 'Password belum diisi']);
			
		} else {
			if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
				echo json_encode(['status' => 0, 'type' => 'email', 'msg' => 'Email tidak valid']);

			} else {
				if($cek) {
					if($cek -> email <> $email) {
						echo json_encode(['status' => 0, 'type' => 'email', 'msg' => 'Email & password salah']);
		
					} else if(password_verify($password, $cek -> password)) {
						$this -> session -> set_userdata('ci_usrid', $cek -> id);
						echo json_encode(['status' => 1, 'msg' => 'Login berhasil']);
		
					} else {
						echo json_encode(['status' => 0, 'type' => 'pass', 'msg' => 'Email & password salah']);
					}
		
				} else {
					echo json_encode(['status' => 0, 'type' => 'email', 'msg' => 'Akun tidak terdaftar']);
				}
			}
		}

	}

	public function proses_daftar() {
		if(empty($_POST['nama'])) {
			echo json_encode(['status' => 0, 'type' => 'nama', 'msg' => 'Nama lengkap belum disi']);

		} else if(empty($_POST['email'])) {
			echo json_encode(['status' => 0, 'type' => 'email', 'msg' => 'Email belum isi']);

		} else if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
			echo json_encode(['status' => 0, 'type' => 'email', 'msg' => 'Email tidak valid']);

		} else if(empty($_POST['nohp'])) {
			echo json_encode(['status' => 0, 'type' => 'nohp', 'msg' => 'No handphone belum isi']);

		} else if(empty($_POST['password'])) {
			echo json_encode(['status' => 0, 'type' => 'pass', 'msg' => 'Kata sandi belum isi']);

		} else if($_POST['password'] <> $_POST['conf_pass']) {
			echo json_encode(['status' => 0, 'type' => 'conf', 'msg' => 'Konfirmasi kata sandi tidak sesuai']);
			
		} else {
			$cek_email  = $this -> db -> get_where('user', ['email' => $_POST['email']]) -> num_rows();
			
			if($cek_email > 0) {
				echo json_encode(['status' => 0, 'type' => 'email', 'msg' => 'Email sudah tersedia']);
				
			} else {
				$add = [
					'nama' 		=> $_POST['nama'],
					'email'		=> $_POST['email'],
					'nohp' 		=> $_POST['nohp'],
					'password' 	=> password_hash($_POST['password'], PASSWORD_DEFAULT),
					'status' 	=> 1,
					'level' 	=> 1,
				];
				
				$this -> db -> insert('user', $add);
				$this -> session -> unset_userdata(['ci_usrid']);
				echo json_encode(['status' => 1, 'url' => site_url('auth/masuk?daftar=berhasil'),  'msg' => 'Daftar akun berhasil']);
			}

		}
	}

	public function pendding() {
		$conf = [
			'title'        => 'Pendding | ' . app('app_name'),
			'page_title'   => 'Pendding',
			'backto' 	   => site_url('auth/masuk')
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('auth/pendding');
		$this -> load -> view('layout/footer');
	}

	public function logout() {
		$this -> session -> unset_userdata('ci_usrid');
		redirect();
	}
}

// Controller Auth
// Kode ini dibuat oleh codelingker
