<style>
    .img {
        width: 55px;
        height: 55px;
        background-color: var(--bs-light);
        border-radius: 100%;
        margin: -20px auto 10px;
        border: 4px solid #fff;
        padding: 5px;
    }
    .img img {
        width: 100%;
        height: 100%;
        object-fit: scale-down;
    }
    .kode_bayar {
        background-color: var(--bs-light);
        color: var(--primary);
        padding: 15px;
        border-radius: 7px;
        margin-top: 15px;
    }
    .kode_bayar h2 {
        font-size: 1.2rem;
        margin-bottom: 0;
        letter-spacing: 2px;
        text-align: center;
    }
    .border-transparent {
        border-color: white !important;
    }

    @media screen and (max-width: 600px) {
        .visible-sm {
            visibility: hidden;
        }
    }
</style>

<?php 
    switch($data -> gateway) {
        case 'Tripay' :
            $payment = $this -> db -> get_where('transaksi_tripay', ['merchant_ref' => $data -> invoice]) -> row(); 
        break;

        case 'Transfer Manual' :
            $payment = $this -> db -> get_where('bank', ['kode' => $data -> metode_bayar]) -> row(); 
            $payment -> payment_name = 'Transfer ' . $payment -> nama;
            $payment -> pay_code     = $payment -> norek;
            $payment -> icon         = base_url('upload/bank/') . $payment -> icon;
        break;
    }

    $today = strtotime(date('Y-m-d H:i'));
    $exp   = strtotime($data -> kadaluarsa);
    $today > $exp && $data -> status > 0 ? redirect('error4x') : null;

?>

<div class="page">
    <?php ?>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-sm-5">
                <div class="card">
                    <div class="card-header d-flex justify-content-center align-item-start">
                        <div class="pt-2 visible-sm">
                            <a href="<?= $backto ?>" class="text-dark">
                                <i class="fa fa-arrow-left"></i>
                            </a>
                        </div>
                        <div class="flex-grow-1 text-center">
                            <div class="img">
                                <img src="<?= $payment -> icon ?>" >
                            </div>
                            <strong><?= $payment -> payment_name ?></strong>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item  border-0">
                                <span class="float-start">
                                    Order ID
                                </span>
                                <div class="float-end">
                                    <strong>
                                        <?= $data -> invoice ?>
                                    </strong>
                                    <button class="badge border bg-white text-primary ms-1" onclick="salin('<?= $data -> invoice ?>')" >
                                        <i class="far fa-copy"></i>
                                    </button>
                                </div>
                            </li>
                            
                            <li class="list-group-item  border-0">
                                <span class="float-start">
                                    Total Tagihan
                                </span>
                                <div class="float-end">
                                    <strong>
                                        <?= format_uang($data -> total + $data -> biaya_admin) ?>
                                    </strong>
                                    <button class="badge border bg-white text-primary ms-1" onclick="salin('<?=$data -> total + $data -> biaya_admin ?>')">
                                        <i class="far fa-copy"></i>
                                    </button>
                                </div>
                            </li>
                            <li class="list-group-item  border-0">
                                <div class="d-flex justify-content-between align-items-start">
                                    <span>Kode Bayar</span>
                                    <button class="badge border bg-white text-primary" onclick="salin('<?= $payment -> pay_code ?>')">
                                        <i class="far fa-copy"></i>
                                    </button>
                                </div>
                                <div class="kode_bayar border border-primary">
                                    <h2>
                                        <strong><?= $payment -> pay_code ?></strong>
                                    </h2>
                                </div>
                            </li>
                            <li class="list-group-item  border-0 pt-3 text-center">
                                <span>Batas Pembayaran</span>
                                <p class="mb-0 mt-1">
                                    <strong class="text-warning">
                                       <?= tgl(date('d F Y H:i', strtotime($data -> kadaluarsa))) ?> WIB
                                    </strong>
                                </p>
                            </li>
                            <li class="list-group-item">
                                <a href="javascript:batalpesanan('<?= $data -> token ?>', '<?= site_url('proses/batalkan_topup') ?>')" class="btn btn-light bg-white border-0 text-danger p-2 w-100">
                                    Batalkan Transaksi
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="card-footer pb-4">
                        <?php if($data -> gateway == 'Tripay') : ?>
                            <a href="javascript:void(0)" 
                                data-id="<?= $payment -> payment_method ?>" 
                                data-pay-code="<?= $payment -> pay_code ?>" 
                                data-amount="<?= $data -> total + $data -> biaya_admin ?>" 
                                class="btn_panduan btn btn-primary p-3 d-block"
                                style="border-radius: 10px"
                            >
                                <strong>
                                    Panduan Pembayaran
                                </strong>
                            </a>
                        <?php else: ?>
                            <a href="javascript:void(0)" 
                                data-id="<?= $data -> id ?>"  
                                class="btn_konfirmasi btn btn-primary p-3 d-block"
                                style="border-radius: 10px"
                            >
                                <strong>
                                    Konfirmasi Pembayaran
                                </strong>
                            </a>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_panduan">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header">
                <div class="_title d-flex align-items-center">
                    <a href="" data-bs-dismiss="modal" class="close">
                        <i class="fa fa-times"></i>
                    </a>
                    <h2>Panduan Pembayaran</h2>
                </div>
            </div>
            <div class="modal-body p-0">

            </div>
        </div>
    </div>
</div>

<script>
    $('.btn_panduan').on('click', function() {
        $('#modal_panduan').modal('show').find('.modal-body').html(loader);

        let id = $(this).data('id');
        let amount = $(this).data('amount');
        let pay_code = $(this).data('pay-code');

        $.post({
            url: base_url + 'proses/get_intruksi',
            data: {
                code: id,
                amount: amount,
                pay_code: pay_code
            },
            dataType: 'html',
            success: data => {
                $('#modal_panduan .modal-body').html(data);
            }
        })
    });
</script>