<?php 
	$base = base_url();
	$site = site_url();
?>


<?php if($get) : ?>
    <?php foreach($get as $produk) : ?>
        <article class="card" data-id="<?= $produk -> id ?>" data-index="<?= $index++ ?>">
            <div class="card-header" onclick="window.location.href='<?= slug($produk -> id, 'produk') ?>'">
                <img src="<?= $this -> app -> get_img_produk($produk -> id)  ?>" alt="produk">
                <ul class="prd-label">
                    <?php if($produk -> diskon_label && count($produk -> varian) == 0) : ?>
                        <li>
                            <a href="" class="_disc">
                                Hemat 
                                <?= $produk -> diskon_label ?>
                            </a>
                        </li>
                    <?php endif ?>
                    <?php if($produk -> cod == 1) : ?>
                    <li>
                        <a href="">
                            COD
                        </a>
                    </li>
                    <?php endif ?>
                    <?php if($produk -> jenis == 'Digital') : ?>
                        <li>
                            <a href="" class="bg-warning">
                                <?= $produk -> jenis ?>
                            </a>
                        </li>
                    <?php endif ?>
                    <?php if($produk -> preorder == 1) : ?>
                        <li>
                            <a href="" class="bg-success">
                                Preorder
                            </a>
                        </li>
                    <?php endif ?>
                </ul>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <p class="truncate-2 nama-prd mb-1">
                        <?= $produk -> nama ?> 
                    </p>
                    <?php if($produk -> diskon > 0 && count($produk -> varian) == 0) : ?>
                        <div class="harga-prd d-flex align-items-center">
                            <p class="_normal">
                                <?= short_uang($produk -> harga - $produk -> diskon) ?>
                            </p>
                            <p class="_coret">
                                <?= short_uang($produk -> harga) ?>
                            </p>
                        </div>
                    <?php else: ?>
                        <div class="harga-prd d-flex align-items-center">
                            <p class="_normal">
                                <?= short_uang($produk -> range_min) ?>
                            </p>
                        </div>
                    <?php endif ?>
                </div>
                <div class="prd-info d-flex justify-content-between align-items-start">
                    <span>1.5Rb Terjual</span>
                    <span>5.0 <i class="fa fa-star text-rate"></i></span>
                </div>
                <div class="prd-aksi">
                    <button class="addCart" data-id="<?= $produk -> id ?>">
                        <i class="fa fa-plus"></i>
                        Keranjang
                    </button>
                </div>
            </div>
        </article>  
    <?php endforeach ?>
<?php else: ?>
    <article class="alert alert-light text-center w-100 py-4" data-id="0" data-index="-">
        <a href="" class="text-dark d-block">
            <img src="<?= $base . 'assets/img/empty-produk.png' ?>" alt="Belum ada produk" class="w-px-120">
        </a>
        <p class="mt-4 mb-0">
            Belum ada produk
        </p>
    </article>
<?php endif ?>