<?php 
    $produk = $this -> app -> get_produk(['id' => $id]);
    $harga  = $produk -> diskon > 0 ? $produk -> harga - $produk -> diskon : $produk -> harga;
    $total  = count($produk -> varian) == 0 ? $harga : 0;

    $disabled   = count($produk -> varian) > 0 ? 'disabled' : null;
    $d_none     = count($produk -> varian) > 0 ? 'd-none' : null;
    $min_order  = count($produk -> varian) == 0 ? $produk -> min_order : null;

    $base = base_url();
?>

<div class="modal-header">
    <div class="_title d-flex align-items-center">
        <a href="" data-bs-dismiss="modal" class="close">
            <i class="fa fa-times"></i>
        </a>
        <h2>Tambah Keranjang</h2>
    </div>
</div>
<div class="modal-body">
    <div class="prd-card-detail d-flex justify-content-between ">
        <div class="_img">
            <img src="<?= $this -> app -> get_img_produk($produk -> id)  ?>" alt="img">
        </div>
        <div class="_text">
            <p class="truncate-2 mb-1">
                <?= $produk -> nama ?>
            </p>
            <div class="harga-prd d-flex align-items-center">
                <?php if(count($produk -> varian) == 0) : ?>
                    <?php if($produk -> diskon > 0) : ?>
                    
                        <p class="_normal">
                            <?= format_uang($produk -> harga - $produk -> diskon) ?>
                        </p>
                        <p class="_coret">
                            <?= format_uang($produk -> harga) ?>
                        </p>

                    <?php else: ?>
                        <p class="_normal">
                            <?= format_uang($produk -> harga) ?>
                        </p>
                    <?php endif ?>

                <?php else: ?>
                    <p class="_normal">
                        <?= $produk -> range_v2 ?>
                    </p>
                    <p class="_coret">
                        
                    </p>
                <?php endif ?>
            </div>                            
        </div>
    </div>

    <?php if(count($produk -> varian) > 0) :  ?>
        <div class="varian-prd mt-3">
            <p class="mb-2">
                 <?= $produk -> jenis == 'Fisik' ? 'Pilih Varian' : 'Pilih Paket' ?>
            </p>
            <div class="d-flex align-items-start flex-wrap">
                <?php foreach($produk -> varian as $var) :  ?>
                    <div class="mb-2">
                        <input type="radio" 
                            name="varian" 
                            id="var_<?= $var -> id_varian . '_' . $var -> is_sub ?>" 
                            class="varian_prd"
                            data-id="<?= $var -> id_varian ?>"
                            data-sub="<?= $var -> is_sub ?>"
                            data-harga="<?= $var -> harga ?>"
                            data-stok="<?= $var -> stok ?>"
                            data-min="<?= $produk -> min_order ?>"
                            data-diskon="<?= $var -> diskon ?>"
                        >
                        <label for="var_<?= $var -> id_varian . '_' . $var -> is_sub ?>">
                            <?= $var -> nama_varian ?>
                        </label>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    <?php endif ?>
    
    <?php if($produk -> jenis == 'Fisik') : ?>
        <div class="qty-prd mt-2">
            <p class="mb-2">Jumlah</p>
            <div class="d-flex">
                <button class="fa fa-minus qty-min disable" <?= $disabled ?> ></button>
                <input type="number" 
                        class="qty-inp nochange text-center disable" 
                        value="<?= $min_order?>" 
                        min="<?= $min_order ?>" 
                        max="<?= $produk -> stok ?>"
                        harga="<?= $harga ?>"
                        data-id="<?= $id ?>"
                        data-jenis="<?= $produk -> jenis ?>"
                        data-id-varian="0"
                        data-id-sub="0"
                        <?= $disabled ?>
                >
                <button class="fa fa-plus qty-plus disable" <?= $disabled ?> ></button>
            </div>
            <div class="mt-2 mb-0 stok-prd <?= $d_none ?>">
                Stok: <strong><?= $produk -> stok ?></strong>
            </div>
        </div>
    <?php else: ?>
        <div class="qty-prd">
            <input type="hidden" 
                    class="qty-inp nochange text-center" 
                    value="<?= $min_order?>" 
                    min="<?= $min_order ?>" 
                    max="<?= $produk -> stok ?>"
                    harga="<?= $harga ?>"
                    data-id="<?= $id ?>"
                    data-jenis="<?= $produk -> jenis ?>"
                    data-id-varian="0"
                    data-id-sub="0"
            >
        </div>
    <?php endif ?>
</div>
<div class="modal-footer justify-content-between">
    <div class="modal-total">
        <p class="mb-0">Total</p>
        <strong class="text-danger"><?= format_uang($total) ?></strong>
    </div>
    <button class="btn btn-primary" <?= $disabled ?> >
        <i class="fa fa-plus me-1"></i>
        Keranjang
    </button>
</div>
