    </main>

    <?php if(isset($footer)) : ?>
        <!-- footer -->
        <footer id="footer">
            <div class="container d-flex justify-content-between flex-wrap">
                <div class="widget toko">
                    <img src="<?= base_url('upload/' . app('app_favico')) ?>" class="_logo_f" alt="Logo">
                    <h2 class="mb-1 text-primary">
                        <?= app('app_name') ?>
                    </h2>
                    <p>
                        <?= app('desc_short') ?>
                    </p>
                    <div>
                        <small>Alamat</small>
                        <p>
                            <?= app('address') ?>
                        </p>
                    </div>
                    <div>
                        <small>Email</small>
                        <p>
                            <?= app('email') ?>
                        </p>
                    </div>
                    <div>
                        <small>WhatsApp</small>
                        <p>
                            <?= app('nohp') ?>
                        </p>
                    </div>
                </div>
                <div class="widget menu">
                    <h2>Main Menu</h2>
                    <ul>
                        <li><a href="">Tentang Kami</a></li>
                        <li><a href="">Kontak Kami</a></li>
                        <li><a href="">Bantuan</a></li>
                        <li><a href="">Katalog Produk</a></li>
                        <li><a href="">Panduan Belanja</a></li>
                    </ul>
                </div>
                <div class="widget sosmed">
                    <h2>Jam Kerja</h2>
                    <table class="table table-sm table-borderless">
                        <?php 
                            $get = $this -> db -> get('jam_kerja') -> result();
                            foreach($get as $item) :
                        ?>
                            <tr>
                                <td style="width: 150px;">
                                    <?= $item -> time ?>
                                </td>
                                <td>:</td>
                                <td>
                                    <?= $item -> description ?>
                                </td>
                            </tr>
                        <?php endforeach ?>
                    </table>
                    
                    <?php  
                        $get = $this -> db -> get_where('sosial_media', ['status' => 1]);
                        if($get -> num_rows() > 0) :
                    ?>
                        <div class="mt-4">
                            <h2>Ikuti Kami</h2>
                            <ul class="d-flex flex-wrap">
                                <?php foreach($get -> result()  as $item) : ?>
                                    <li>
                                        <a href="<?= $item -> url ?>" title="<?= $item -> name ?>">
                                            <i class="<?= $item -> icon ?>"></i>
                                        </a>
                                    </li>
                                <?php endforeach ?>
                            </ul>
                        </div>
                    <?php endif ?>
                </div>
            </div>
            <div class="credit">
                &copy; <?= date('Y') ?> <span class="mx-2"> | </span> <a href="<?= site_url() ?>"> <?= app('app_name') ?> </a>
            </div>
        </footer>
    <?php endif ?>
    
    <?php if(isset($mobmenu)) : ?>
        <!-- mobmenu -->
        <nav id="mobmenu">
            <ul class="d-flex justify-content-center align-items-center flex-wrap">
                <li>
                    <?php if($this -> uri -> segment(1) == 'produk') : ?>
                        <a href="javascript:void(0)" class="btn-sidebar">
                            <span class="_icon">
                                <i class="fa fa-filter"></i>
                            </span>
                            <span class="_text">
                                Filter
                            </span>
                        </a>
                    <?php else: ?>
                        <a href="<?= site_url('produk') ?>">
                            <span class="_icon">
                                <i class="fa fa-boxes"></i>
                            </span>
                            <span class="_text">
                                Produk
                            </span>
                        </a>
                    <?php endif ?>
                </li>
                <li>
                    <a href="<?= site_url('keranjang') ?>">
                        <span class="_icon">
                            <i class="fa fa-shopping-basket"></i>
                            <span class="cart-dot <?= $this -> app -> get_jml_keranjang() == 0 ? 'd-none' : '' ?>"></span>
                        </span>
                        <span class="_text">
                            Keranjang
                        </span>
                    </a>
                </li>
                <li>
                    <a href="<?= site_url('akun') ?>">
                        <span class="_icon">
                            <i class="fa fa-user"></i>
                        </span>
                        <span class="_text">
                            Akun
                        </span>
                    </a>
                </li>
            </ul>
        </nav>
    <?php endif ?>

    <?php if(isset($search_input)) : ?>
        <div class="modal fade" id="modal_src">
            <div class="modal-dialog modal-fullscreen-sm-down modal-dialog-scrollable modal-sm">
                <div class="modal-content">
                <div class="modal-content">
                        <div class="modal-header">
                            <button class="close" data-bs-dismiss="modal">
                                <i class="fa fa-arrow-left"></i>
                            </button>
                            <input type="text" class="src-mod-inp searching" placeholder="Cari Produk...">
                        </div>
                        <div class="modal-body src-result">
                            <ul class="p-0 m-0">
                                <li>
                                    <div class="text-center py-4">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Loading...</span>
                                        </div>
                                        <h6 class="mb-0 mt-2"> 
                                            Memuat Data
                                        </h6>
                                    </div>
                                </li>                                
                            </ul>
                        </div>                
                    </div>
                </div>
            </div>
        </div>
    <?php endif ?>

    <div class="modal fade" id="modal_addcart">
        <div class="modal-dialog modal-fullscreen-sm-down modal-dialog-scrollable modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="_title d-flex align-items-center">
                        <a href="" data-bs-dismiss="modal" class="close">
                            <i class="fa fa-times"></i>
                        </a>
                        <h2>Tambah Keranjang</h2>
                    </div>
                </div>
                <div class="modal-body">
                    
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="modal_notif">
        <div class="modal-dialog modal-fullscreen-sm-down modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="_title d-flex align-items-center">
                        <a href="" data-bs-dismiss="modal" class="close">
                            <i class="fa fa-times"></i>
                        </a>
                        <h2>Notifikasi</h2>
                    </div>
                </div>
                <div class="modal-body p-0 notif_body">
                    
                </div>
            </div>
        </div>
    </div>

    <form method="POST" class="modal fade" id="modal_topup">
        <div class="modal-dialog modal-fullscreen-sm-down modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="_title d-flex align-items-center">
                        <a href="" data-bs-dismiss="modal" class="close">
                            <i class="fa fa-times"></i>
                        </a>
                        <h2>Top up Saldo</h2>
                    </div>
                </div>
                <div class="modal-body">

                </div>
            </div>
        </div>
    </form>
    
    <script>
        function nf(angka){
            var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split   		= number_string.split(','),
            sisa     		= split[0].length % 3,
            rupiah     		= split[0].substr(0, sisa),
            ribuan     		= split[0].substr(sisa).match(/\d{3}/gi);
        
            // tambahkan titik jika yang di input sudah menjadi angka ribuan
            if(ribuan){
                separator = sisa ? '.' : '';
                rupiah += separator + ribuan.join('.');
            }
        
            return split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        }

        function redirect(link, is_base) {
            window.location.href = is_base == 0 ? link : base_url + link;
        }

        function salin(text) {
            navigator.clipboard.writeText(text).then(function() {
                toast({title: 'Disalin ke clipboard', icon: 'info'});
            }, err => {
                console.error('Async: Could not copy text: ', err);
            });
        }

        function batalpesanan(id, url) {
            let tab_active = $('#tab_active').val();
            hps_alert.fire({
                text: 'Transaksi ini akan dibatalkan',
                confirmButtonText: 'Batalkan',
                cancelButtonText: 'Tidak'
            }).then(res => {
                if(res.isConfirmed) {
                    $.post({
                        url: url == undefined ? base_url + 'proses/batalkan_pesanan' : url,
                        data: {id: id},
                        dataType: 'json',
                        success: json => {
                            if(json.status == 1) {
                                <?php if(isset($_GET['produk'])) : ?>
                                    <?php if($_GET['produk'] == 'topup_saldo') : ?>
                                        redirect('akun/saldo?riwayat=topup');
                                    <?php else: ?>
                                        redirect('akun/pesanan?produk=<?= $_GET['produk'] ?>&tab=4');
                                    <?php endif ?>
                                <?php else: ?>
                                    redirect('akun');
                                <?php endif ?>
                            }
                        }
                    })
                }
            })

        }

        function total_modal_cart(aksi) {
            let value;
            let elm   = $('.qty-inp');
            let qty   = elm.val();
            let min   = elm.attr('min');
            let max   = elm.attr('max');
            let harga = elm.attr('harga');

            switch (aksi) {
                case 'add':
                    value = Number(qty) < Number(max) ? Number(qty) + 1 : max;
                break;
            
                case 'min':
                    value = Number(qty) > Number(min) ? Number(qty) - 1 : min;
                break;
            
                case 'change':
                    value = Number(qty) >= Number(min) && Number(qty) <= Number(max) ? Number(qty) : 1;
                break;
            }

            elm.val(value);
            $('.modal-total strong').text('Rp' + nf(String(Number(harga) * Number(value))));
        }

        function loader() {
            return `
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                    <h6 class="mb-0 mt-2"> 
                        Memuat Data
                    </h6>
                </div>
            `;
        }

        function loader_sm(status) {
            if(status == 0) {
                $('.spin_loader').remove();

            } else {
                return `
                <div class="d-flex spin_loader">
                        <div class="spinner-border spinner-border-sm text-primary me-2" role="status" style="position: relative; top: 3px"> 
                            <span class="sr-only">Loading...</span> 
                        </div>
                        <span>Memuat data...</span>
                    </div>
                `;
            }
        }

        function toast(obj) {
            Swal.fire({
                toast: true,
                position: 'top-end',
                timer: 3000,
                confirmButtonText: obj.confirmText == undefined ? false : obj.confirmText,
                cancelButtonText: obj.cancelText == undefined ? false : obj.cancelText,
                showCancelButton: obj.cancelText == undefined ? false : true,
                showCloseButton: obj.closeBtn == undefined ? false : true,
                icon: obj.icon,
                title: obj.title,
                buttonsStyling: false,
                customClass: {
                    confirmButton: 'btn btn-sm btn-light bg-white border-0',
                    cancelButton: 'btn btn-sm btn-light bg-white border-0',
                }
            }).then(function(result) {
                if(result.isConfirmed) {
                    window.location.href = obj.redirect
                }
            });

        }

        function swal(obj) {
            Swal.fire({
                icon: obj.icon,
                title: obj.title,
                html: obj.text,
                showConfirmButton: obj.confirmBtn == undefined ? false : true,
                showCancelButton: obj.cancelBtn == undefined ? false : obj.cancelBtn,
                confirmButtonText: obj.confirmBtn == undefined ? false : obj.confirmBtn,
                cancelButtonText: obj.cancelBtn == undefined ? false : obj.cancelBtn,
                timerProgressBar: obj.progress == undefined ? false : true,
                timer: obj.timer == undefined ? false : obj.timer,
                allowEscapeKey: false,
                allowOutsideClick: false
            }).then(res => {
                if(res.isConfirmed) {
                    window.location.href = obj.redirect
                }
            })
        }

        function add_cart(id) {
            $('#moda_add_cart').modal('show');
        }

        function get_rekom() {
            $.post({
                url: base_url + 'proses/get_rekom',
                dataType: 'html',
                success: data => {
                    $('.src-list, .src-result').html(data);
                }
            })
        }

        setInterval(() => {
            
            $.post({
                url: base_url + 'proses/autoupdate',
            })

        }, 15000);

        const hps_alert = Swal.mixin({
            icon: 'question',
            title: 'Apakah anda yakin?',
            showCancelButton: true,
            confirmButtonText: 'Hapus', 
            cancelButtonText: 'Batal',
            customClass: {
                confirmButton: 'btn btn-danger me-2',
                cancelButton: 'btn btn-secondary'
            },
            buttonsStyling: false 
        });

        const confirm_submit = Swal.mixin({
            icon: 'question',
            title: 'Apakah anda yakin?',
            showCancelButton: true,
            confirmButtonText: 'Simpan', 
            cancelButtonText: 'Batal',
            customClass: {
                confirmButton: 'btn btn-primary me-2',
                cancelButton: 'btn btn-secondary'
            },
            buttonsStyling: false 
        });

        const confirm_success = Swal.mixin({
            icon: 'success',
            title: 'Berhasil',
            showConfirmButton: false,
            timerProgressBar: true,
            timer: 1500,
            allowEscapeKey: false,
            allowOutsideClick: false
        });

        $(document).on('input', '.nf', function() {
            $(this).val(nf(this.value));
        });

        $(function() {
            $('.lazy').lazy();
        });

        w.on('load', function() {
            $('.loading').fadeOut('fast', function() {
                $('body').removeClass('o-hidden');
            });
        });

        w.on('scroll', function() {
            if($(this).width() > 680) {
                if($(this).scrollTop() > 200) {
                    $('.top-menu').slideUp('fast');

                } else {
                    $('.top-menu').slideDown('fast');
                }
            }

            if($(this).scrollTop() > 400) {
                $('#backtop').slideDown();

            } else {
                $('#backtop').slideUp();
            }
        });

        if(w.width() > 680) {
            if(w.scrollTop() > 200) {
                $('.top-menu').hide();

            } else {
                $('.top-menu').show();
            }
        }

        $('.header .__input').on('click', function() {
            $('.src-list').slideDown('fast');
            get_rekom();
        });

        $('.btn_src_mob').on('click', function() {
            $('#modal_src').modal('show');
            
            get_rekom();
        });

        $('#backtop').on('click', function(e) {
            e.preventDefault();
            $('html, body').animate({scrollTop: 0});
        });

        $(document).on('click', function(e) {            
            if($(e.target).closest('._mid').length == 0) {
                $('.src-list ul').html('');
                $('.src-list').slideUp('fast');
            }
        });

        $(document).on('click', '.btn_topup', function() {
            $('#modal_topup').modal('show').find('.modal-body').html(loader);
            $.post(base_url + 'proses/modal_topup', html => {
                $('#modal_topup').find('.modal-content').html(html);
            })
        });

        $(document).on('click', '[name="payment_tf"]', function() {
            let elm     = $(this);
            let fee     = elm.attr('data-fee'); 
            let icon    = elm.attr('data-icon'); 
            let gateway = elm.attr('data-gateway'); 

            $('[name="payment_tf_icon"]').val(icon);
            $('[name="payment_tf_gateway"]').val(gateway);
            $('[name="payment_tf_fee"]').val(fee);
        });

        $('#modal_topup').on('submit', function(e) {
            e.preventDefault();

            let form = $(this);
            let nominal = $('[name="payment_tf_fee"]').val();
            $.post({
                url: base_url + 'proses/cek_form_topup',
                dataType: 'json',
                data: form.serialize(),
                success: json => {
                    if(json.msg != 'next') {
                        toast({
                            icon: 'warning',
                            title: json.msg
                        })

                    } else {
                        confirm_submit.fire({
                            text: 'Permintaan topup dikenakan biaya penanganan Rp' + nf(nominal),
                            confirmButtonText: 'Topup Saldo'
                        }).then(res => {
                            if(res.isConfirmed) {
                                $.post({
                                    url: base_url + 'proses/submit_topup',
                                    dataType: 'json',
                                    data: form.serialize(),
                                    success: data => {
                                        if(data.status == 1) {
                                            redirect(data.url, 0);
                                        }
                                    } 
                                })
                            }
                        })
                    }
                }
            })
            
        });

    </script>

    <script>
        $('.select2').select2({
            theme: 'bootstrap-5',
            // dropdownParent: $('.row ')
        });

        $(document).on('click', '.read_all', function() {
            let jml = $('span', this).text();
            if(Number(jml) > 0) {
                $.post({
                    url: base_url + 'proses/update_notif',
                    success: function(data) {
                        $('.read_all span').text(0);
                        $('#modal_notif .list-group-item').removeClass('bg-light');
                        $('._notif span').addClass('d-none');
                    }
                })
            }
        })

        $(document).on('click', '#modal_notif .list-group-item a:not(.read_all)', function() {
            let id   = $(this).attr('id');
            let elmn = $('.read_all span');
            let jmln = elmn.text();

            $.post({
                url: base_url + 'proses/update_notif',
                dataType: 'json',
                data: {id:id},
                success: function(data) {
                    $('#' + id).removeClass('bg-light');
                    elmn.text(data.row - 1 < 1 ? 0 : jmln - 1);
                    
                    if(data.row - 1 == 0) {
                        elmn.text(0);
                        $('._notif span').addClass('d-none');
                    }
                }
            })
        })

        $(document).on('click', '.addCart', function() {
            let id = $(this).data('id');

            $('#modal_addcart').modal('show');
            $('#modal_addcart .modal-body').html(loader);

            $.post({
                url: base_url + 'proses/addcart',
                data: {id:id},
                dataType: 'html',
                success: function(data) {
                    $('#modal_addcart .modal-content').html(data);
                }
            })
        });

        $('._notif').on('click', function() {
                $('#modal_notif').modal('show');
                $('#modal_notif .modal-body').html(loader);
                $.post({
                    url: base_url + 'proses/get_notif',
                    dataType: 'html',
                    success: function(data) {
                        $('#modal_notif .modal-body').html(data);
                    }
                })
        });

        $(document).on('click', '.qty-plus', function() {
                total_modal_cart('add');
        });

        $(document).on('click', '.qty-min', function() {
            total_modal_cart('min');
        });

        $(document).on('change', '.qty-inp', function() {
            total_modal_cart('change');
        });

        $(document).on('change', '.searching', function() {
            location.reload();
        });

        $(document).on('input', '.searching', function() {
            let value = this.value;

            $.post({
                url: base_url + 'proses/searching',
                data: {value:value},
                dataType: 'html',
                success: function(data) {
                    $('.src-list ul, #modal_src .src-result ul').html(data);
                }
            })

            if(value != '') {
                $('.src-list h6, #modal_src .src-result h6').text('Hasil Pencarian');
            } else {
                $('.src-list h6, #modal_src .src-result h6').text('Rekomendasi');
            }
        });

        $(document).on('click', '.varian_prd', function() {
            let harga     = $(this).attr('data-harga');
            let diskon    = $(this).attr('data-diskon');
            let stok      = $(this).attr('data-stok');
            let min       = $(this).attr('data-min');
            let id_varian = $(this).attr('data-id');
            let sub       = $(this).attr('data-sub');

            let total_harga = Number(harga) - Number(diskon);

            $('#modal_addcart .disabled, #modal_addcart .modal-footer button').attr('disabled', false);
            $('.stok-prd').removeClass('d-none').find('strong').text(stok);
            $('.modal-total strong').text('Rp' + nf(String(total_harga)));
            $('#modal_addcart .qty-inp').val(min).attr({
                min: min,
                harga: total_harga,
                max: stok,
                'data-id-varian': id_varian,
                'data-id-sub': sub
            });

            if(Number(diskon) > 0) {
                $('#modal_addcart ._coret, #modal_varian ._coret').text('Rp' + nf(harga));
                $('#modal_addcart ._normal, #modal_varian ._normal').text('Rp' + nf(String(total_harga)));

            } else {
                $('#modal_addcart ._normal, #modal_varian ._normal').text('Rp' + nf(harga));
                $('#modal_addcart ._coret, #modal_varian ._coret').text('');
            }

        });

        $(document).on('click', '#modal_addcart .modal-footer button', function() {
            let elm     = $('#modal_addcart .qty-inp');
            let varian  = elm.attr('data-id-varian');
            let sub     = elm.attr('data-id-sub');
            let id      = elm.attr('data-id');
            let jenis   = elm.attr('data-jenis');
            let jml     = jenis == 'Fisik' ? elm.val() : 1;

            $.post({
                url: base_url + 'proses/simpan_keranjang',
                data: {
                    id: id,
                    varian: varian,
                    subvar: sub,
                    jml: jml
                },
                dataType: 'json',
                success: function(json) {
                    if(json.status == 1) {
                        toast({
                            confirmText: 'Lihat keranjang',
                            cancelText: 'Lanjut Belanja',
                            redirect: base_url + 'keranjang' ,
                            title: json.msg,
                            icon: 'info'
                        });
                        $('.modal').modal('hide');
                        $('.cart-dot').removeClass('d-none');
                    } else {
                        toast({
                            confirmText: 'Login',
                            cancelText: 'Lanjut Belanja',
                            redirect: base_url + 'auth/masuk' ,
                            title: 'Anda belum login',
                            icon: 'warning'
                        });
                    }
                } 
            })
        })

        $('.btn-sidebar').on('click', function(e) {
            $('.sidebar').css({
                opacity: 1,
                margin: 0
            });
        })

        $('.sidebar ._close').on('click', function(e) {
            $('.sidebar').css({
                opacity: 0,
                marginLeft: '-110%'
            });
        })

    </script>

</body>
</html>