<?php 
    $base = base_url();
    $site = site_url();
    $produk_terkait = $this -> app -> get_produk_terkait($produk -> id, $produk -> kategori);
    $is_favorit     = count((array) $this -> app -> get_favorit($produk -> id)) > 0 ? 'added' : null;
    $favin          = count((array) $this -> app -> get_favorit($produk -> id)) > 0 ? 'fa' : 'far';
?>

<div class="page single-page">            
    <section class="section">
        <div class="container d-flex flex-wrap justify-content-between align-items-start">
            <div class="img-group d-flex flex-wrap">

                <button class="btn-heart <?= $is_favorit ?>" data-id="<?= $produk -> id ?>">
                    <i class="<?= $favin ?> fa-heart text-danger"></i>
                </button>
                <div class="_preview">
                    <img src="<?= $base . 'upload/produk/' .$produk -> img_1  ?>" alt="img">
                </div>
                <div class="_mini">
                    <?php if($produk -> img_1) : ?>
                        <div class="_img active">
                            <img src="<?= $base . 'upload/produk/' .$produk -> img_1  ?>" alt="img">
                        </div>
                    <?php endif ?>
                    <?php if($produk -> img_2) : ?>
                        <div class="_img">
                            <img src="<?= $base . 'upload/produk/' .$produk -> img_2  ?>" alt="img">
                        </div>
                    <?php endif ?>
                    <?php if($produk -> img_3) : ?>
                        <div class="_img">
                            <img src="<?= $base . 'upload/produk/' .$produk -> img_3  ?>" alt="img">
                        </div>
                    <?php endif ?>
                    <?php if($produk -> img_4) : ?>
                        <div class="_img">
                            <img src="<?= $base . 'upload/produk/' .$produk -> img_4  ?>" alt="img">
                        </div>
                    <?php endif ?>
                </div>                             
            </div>  
            
            <div class="detail-produk">
                <?php if($produk -> jenis == 'Digital') : ?>
                    <span class="badge badge-warning mb-1 px-2">
                        Digital
                    </span>
                <?php endif ?>
                <?php if($produk -> diskon_label && count($produk -> varian) == 0) : ?>
                    <span class="badge bg-danger mb-1">
                        Disc <?= $produk -> diskon_label ?>
                    </span>
                <?php endif ?>
                <?php if($produk -> preorder == 1) : ?>
                    <span class="badge badge-success mb-1 px-2">
                        Preorder
                    </span>
                <?php endif ?>
                <h3 class="mb-0">
                    <?= $produk -> nama ?>    
                </h3>
                <div class="mt-2 pb-2 produk-info">
                    
                    <a href="#ulasan" class="link-ulasan">
                        <!-- <span>
                            <i class="fa fa-star text-rate"></i>
                            5.0 
                        </span>
                        <span class="mx-2"> | </span>
                        <span>
                            5 Ulasan
                        </span> -->
                        Belum ada ulasan
                    </a>
                    <span>0 Terjual</span>

                </div>
                <div class="mt-4 harga-produk">
                    <span>
                        <span>Harga</span>
                    </span>
                    <h5 class="mt-1">
                        <?php if($produk -> diskon > 0) : ?>
                            <span>
                                <?= format_uang($produk -> harga - $produk -> diskon)  ?>
                            </span>
                            <small>
                                <?= format_uang($produk -> harga)  ?>
                            </small>
                        <?php else: ?>
                            <span>
                                <?= $produk -> range_v1 ?>
                            </span>
                        <?php endif ?>
                    </h5>
                    <div class="_icon">
                        <!-- <i class="fa fa-bolt"></i> -->
                        <i class="fa fa-tags"></i>
                    </div>
                </div>
                
                <?php $i = 0; if($produk -> varian) : ?>
                    <div class="mt-3">
                        <h6>
                            <strong>
                                <?= $produk -> jenis == 'Fisik' ? 'Varian' : 'Paket' ?>
                            </strong>
                        </h6>
                        <?php foreach($produk -> varian as $var) : ++$i; ?>
                            <?php if($i < 3) : ?>                            

                                <button class="badge badge-light text-dark border addCart"
                                        data-id="<?= $produk -> id ?>"
                                        data-varian="<?= $var -> id_varian ?>"
                                        data-sub="<?= $var -> is_sub ?>"
                                >
                                    <?= $var -> nama_varian  ?>
                                </button>   
                                
                            <?php endif; ?>
                        <?php endforeach ?>
                        
                        <?php if($i > 3) : ?>
                            <button class="badge badge-light text-dark border addCart" data-id="<?= $produk -> id ?>">
                                Lainnya (<?= $i - 2 ?>)
                            </button>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                
                <div class="btn-aksi pt-4 mt-3">
                    <button class="btn btn-primary px-4 me-2 addCart" data-id="<?= $produk -> id ?>">
                        <i class="fa fa-plus"></i>
                        Keranjang
                    </button>
                    
                    <?php if($produk -> jenis == 'Fisik') : ?>
                        <button class="btn btn-light px-4 me-2" data-bs-toggle="collapse" data-bs-target="#bagikan_list">
                            <i class="fa fa-share"></i>
                            Bagikan
                        </button>
                    <?php else: ?>

                        <div class="btn-group" role="group">
                            <button id="btn-lain1" class="btn btn-light border dropdown-toggle px-4" data-bs-toggle="dropdown" aria-expanded="false">
                                Demo
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="btn-lain1">
                                <li>
                                    <a class="dropdown-item text-primary" href="<?= $produk -> link_demo ?>">
                                        <small>
                                            <i class="fa fa-external-link me-1"></i>
                                            Lihat Demo
                                        </small>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item text-success" href="javascript:void(0)"  data-bs-toggle="collapse" data-bs-target="#bagikan_list">
                                        <small>
                                            <i class="fa fa-share me-1"></i>
                                            Bagikan
                                        </small>
                                    </a>
                                </li>
                            </ul>
                        </div>

                    <?php endif ?>

                    <div class="collapse mt-3" id="bagikan_list">
                        <p class="mb-2">Bagikan</p>
                        <a href="" class="btn btn-primary">
                            <i class="fab fa-facebook"></i>
                        </a>
                        <a href="" class="btn btn-success">
                            <i class="fab fa-whatsapp"></i>
                        </a>
                        <a href="" class="btn btn-info text-white">
                            <i class="fab fa-twitter"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="produk-desc section">
        <div class="container">
            <h2>Informasi Produk</h2>
            <div class="table-responsive">
                <table class="table border-top mb-4">
                    <tbody>
                        <?php if($produk -> jenis == 'Fisik') : ?>
                            <tr>
                                <td style="width: 150px">Stok Tersedia</td>
                                <td style="width: 20px;">:</td>
                                <th>20</th>
                            </tr>
                        <?php endif ?>

                        <?php if($produk -> nama_kategori) : ?>
                            <tr>
                                <td style="width: 150px">Kategori</td>
                                <td style="width: 20px">:</td>
                                <th><?= $produk -> nama_kategori ?></th>
                            </tr>
                        <?php endif ?>

                        <?php if($produk -> preorder == 1) : ?>
                            <tr>
                                <td style="width: 150px">Preorder</td>
                                <td style="width: 20px">:</td>
                                <th><?= $produk -> preorder_hari ?> hari</th>
                            </tr>
                        <?php endif ?>
                    </tbody>
                </table>
            </div>

            <h3>Deskripsi</h3>
            <div class="_desc truncate-3">
               <?= $produk -> deskripsi ?>
            </div>
            <div class="text-center mt-5">
                <button class="btn btn-light px-5 btn-readmore w-100 border">
                    Selengkapnya
                </button>
            </div>
        </div>
    </section>

    <section class="produk-ulasan section border-0" id="ulasan">
        <div class="container">
            <h2>
                Ulasan Produk
            </h2>

            <div class="ulasan-wrap">    
                <article class="_item d-flex justify-content-between flex-wrap border">
                    <div class="_ava bg-white text-primary d-flex justify-content-center align-items-center">
                        <strong>S</strong>
                    </div>
                    <div class="_text">
                        <h6 class="mb-0">Septian Wahyudi Rahman</h6>
                        <small>
                            <span class="text-rate">
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                            </span>
                        </small>
                        <p class="mb-1 mt-2">
                            Lorem ipsum dolor sit amet consectetur adipisicing elit. A nesciunt beatae dolor ex enim porro vero dicta. Quo explicabo nemo soluta voluptatem ipsa sequi quia veritatis minus recusandae, necessitatibus aut.
                        </p>
                    </div>

                </article>
            </div>

            <div class="text-center mt-4">
                <button class="btn btn-light px-5 w-100 btn-ulasan border">
                    Lainnya (220)
                </button>
            </div>
        </div>
    </section>
    
    <?php if($produk_terkait) : ?>    
        <section class="produk-terkait section">
            <div class="container">
                <h2>Produk Terkait</h2>
                <div class="produk-terkait-list owl-carousel">
                    <?php foreach($produk_terkait as $terkait) : ?>
                        <a href="javascript:void(0)" class="_items" onclick="window.location.href='<?= slug($terkait -> id, 'produk') ?>'">
                            <img src="<?= $this -> app -> get_img_produk($terkait -> id) ?>" alt="">
                            <div class="_body">
                                <p class="truncate-2 mb-2">
                                    <?= $terkait -> nama ?>
                                </p>
                                <h6>
                                    <div class="harga-prd d-flex align-items-center">
                                        <p class="_normal">
                                            <?= format_uang($terkait -> harga) ?>
                                        </p>
                                    </div>
                                </h6>
                            </div>
                        </a>
                    <?php endforeach ?>
                </div>
            </div>
        </section>
    <?php endif ?>
</div>

<div class="modal fade" id="modal_ulasan">
    <div class="modal-dialog modal-fullscreen-sm-down modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <div class="_title d-flex align-items-center">
                    <a href="" data-bs-dismiss="modal" class="close">
                        <i class="fa fa-times"></i>
                    </a>
                    <h2>Ulasan Produk</h2>
                </div>
            </div>
            <div class="modal-body notif_body p-0">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <button class="badge badge-light text-rate">
                            <i class="fa fa-star"></i> 
                            5 
                            <span class="text-dark ms-1">
                                (10)
                            </span> 
                        </button>
                        <button class="badge badge-light text-rate">
                            <i class="fa fa-star"></i> 
                            4 
                            <span class="text-dark ms-1">
                                (9)
                            </span> 
                        </button>
                        <button class="badge badge-light text-rate">
                            <i class="fa fa-star"></i> 
                            3 
                            <span class="text-dark ms-1">
                                (8)
                            </span> 
                        </button>
                        <button class="badge badge-light text-rate">
                            <i class="fa fa-star"></i> 
                            2 
                            <span class="text-dark ms-1">
                                (7)
                            </span> 
                        </button>
                        <button class="badge badge-light text-rate">
                            <i class="fa fa-star"></i> 
                            1 
                            <span class="text-dark ms-1">
                                (6)
                            </span> 
                        </button>
                    </li>
                    <li class="list-group-item py-3">
                        <a href="javascript:void(0)" class="d-flex align-items-start">
                            <div class="_img d-flex justify-content-center align-items-center bg-light text-primary">
                                <strong>S</strong>
                            </div>
                            <div class="_text">
                                <h6 class="truncate-2 mb-0">
                                    Septian Wahyudi
                                </h6>
                                <div class="text-sm mb-2">
                                    <small>
                                        <span class="text-rate">
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                        </span>
                                    </small>
                                </div>
                                <p class="mb-0">
                                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Eligendi quae, beatae, reprehenderit, minima quaerat numquam quod aliquid totam modi non quo incidunt tenetur dignissimos labore necessitatibus nam! Quos, iure fuga!
                                </p>
                                
                            </div>
                        </a>
                    </li>
                                       
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
    $('.img-group ._mini img').on('mouseover', function() {
        let img = $(this).attr('src');
        $('.img-group ._preview img').attr('src', img);

        $('.img-group ._img').removeClass('active');
        $(this).parent().addClass('active');
    });

    $('.link-ulasan').on('click', function(e) {
        e.preventDefault();
        let href = $(this).attr('href');
        $('html, body').animate({
            scrollTop: $('#ulasan').offset().top - 70
        }, 'slow')
    });

    $('.btn-ulasan').on('click', function(e) {
        $('#modal_ulasan').modal('show');
    })

    $('.btn-readmore').on('click', function(e) {
        e.preventDefault();
        if($('._desc').hasClass('truncate-3')) {
            $('._desc').removeClass('truncate-3');
            $(this).text('Sembunyikan');
            
        } else {
            $('._desc').addClass('truncate-3');
            $(this).text('Selengkapnya');
        }
    });

    $('.qty-order input').on('click', function() {
        $(this).select();
    });

    $('.btn-heart').on('click', function() {
        let is_love;
        let id = $(this).data('id');
        $('.btn-heart').toggleClass('added');
        if($('.btn-heart').hasClass('added')) {
            $('.btn-heart i').removeClass('far');
            $('.btn-heart i').addClass('fa');

            is_love = 1;
            
        } else {
            $('.btn-heart i').removeClass('fa');
            $('.btn-heart i').addClass('far');
            
            is_love = 0;
            
        }
        
        $.post({
            url: base_url + 'proses/favorit',
            data: {
                id:id,
                status: is_love
            },
            dataType: 'json',
            success: function(json) {
                if(json.status == 1) {
                    toast({
                        title: json.msg,
                        icon: 'info'
                    });
                }
            }
        })
    })

    if($(window).width() <= 580) {
        $('.img-group ._mini').addClass('owl-carousel owl-theme');
        $('.img-group ._mini').owlCarousel({
            loop: true,
            smartSpeed: 600,
            margin: 0,
            responsive: {
                0: {
                    items: 1
                }
            }
        })
    }
    
    $('.produk-terkait-list').owlCarousel({
        loop: false,
        margin: 0,
        dots: false,
        nav: true,
        smartSpeed: 600,
        navText: [
            '<span class="fa fa-chevron-left"></span>',
            '<span class="fa fa-chevron-right"></span>'
        ],
        responsive: {
            0: {
                items: 2,
                margin: 60,
            },
            320: {
                items: 2,
                margin: 20,
            },
            768: {
                items: 4,
                margin: 20,
            },
            1020: {
                items: 7, 
                margin: 140,
            },
            1100: {
                items: 7, 
                margin: 0,
            },
        }
    })
</script>