<div class="page" >
    <div class="login-wrap">
        <div class="pageTitle text-center">
            <h2>Masuk</h2>
        </div>
        <form method="POST" id="form_login">
            <?php if(isset($_GET['daftar'])) : ?>
                <div class="alert alert-success" style="margin-top: -10px">
                    <strong>Berhasil</strong>
                    <p class="mb-0">
                        Akun anda sudah terdaftar, silahkan login.
                    </p>
                    <a href="<?= site_url('auth/masuk') ?>" class="close">
                        <i class="fa fa-times"></i>
                    </a>
                </div>
            <?php endif ?>
            <div class="mb-3">
                <label for="" class="form-label">Email</label>
                <input type="text" class="form-control" id="inp-email" name="email" autocomplete="off">
                <div class="feedback-email mt-1 text-danger"></div>
            </div>
            <div class="mb-3">
                <div class="d-flex justify-content-between">
                    <label for="" class="form-label">Kata Sandi</label>
                    <a href="<?= site_url('auth/resetpass') ?>" >
                        Lupa sandi?
                    </a>
                </div>
                <input type="password" class="form-control" id="inp-pass" name="password">
                <div class="feedback-pass mt-1 text-danger"></div>
            </div>
            <div class="mt-3 form-check">
                <label for="acc-term" class="form-check-label">
                    <input type="checkbox" name="acc" id="acc-term" class="form-check-input">
                    <span>
                        Ingatkan saya
                    </span>
                </label>
            </div>
            <div class="mt-5 mb-2">
                <button class="w-100 btn btn-lg btn-primary">
                    <span class="spinner-border spinner-border-sm text-white d-none" role="status"> 
                        <span class="sr-only">Loading...</span> 
                    </span>
                    Masuk
                </button>
            </div>
            <div class="mb-2 mt-4">
                <p class="_atau">Belum punya akun?</p>
                <a href="<?= site_url('auth/daftar') ?>" class="btn btn-light btn-lg d-block">
                    Buat Akun
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    $('form').on('submit', function(e) {
        e.preventDefault();
        let form = $(this);
        $.post({
            url: base_url + 'auth/proses_login',
            data: form.serialize(),
            dataType: 'json',
            success: function(json) {
                if(json.status == 1) {
                    window.location.href = base_url + 'akun'
                    $('.form-control').removeClass('is-invalid');

                } else {
                    if(json.status == 0) {
                        toast({
                            title: json.msg,
                            icon: 'error'
                        });

                        if(json.type == 'email') {
                            $('#inp-email').addClass('is-invalid');
                            $('#inp-pass').removeClass('is-invalid');

                        } else if(json.type == 'pass') {
                            $('.form-control').addClass('is-invalid');

                        } else {
                            $('.form-control').removeClass('is-invalid');
                        }
                    }
                }
            }
        });
    })
</script>