<div class="page" >
    <div class="login-wrap">
        <div class="pageTitle text-center">
            <h2>Buat Akun</h2>
        </div>
        <form method="POST" id="form_login">
            <div class="mb-3">
                <label for="" class="form-label">Nama Lengkap</label>
                <input type="text" class="form-control" name="nama" id="inp_nama">
                <div class="feedback-name"></div>
            </div>
            <div class="mb-3">
                <label for="" class="form-label">Email</label>
                <input type="text" class="form-control" name="email" id="inp_email">
                <div class="feedback-email"></div>
            </div>
            <div class="mb-3">
                <label for="" class="form-label">No Handphone</label>
                <input type="number" class="form-control nochange" name="nohp" id="inp_nohp">
                <div class="feedback-hp"></div>
            </div>
            <div class="mb-3">
                <label for="" class="form-label">Kata Sandi</label>
                <input type="password" class="form-control" name="password" id="inp_pass">
                <div class="feedback-pass"></div>
            </div>
            <div class="mb-3">
                <label for="" class="form-label">Ulangi Kata Sandi</label>
                <input type="password" class="form-control" name="conf_pass" id="inp_conf">
                <div class="feedback-pass"></div>
            </div>
            <div class="mt-4 form-check">
                <label for="acc-term" class="form-check-label">
                    <input type="checkbox" name="acc" id="acc-term" class="form-check-input">
                    <span>
                        Anda telah menyetujui <a href="<?= site_url('page/syarat_ketentuan') ?>">syarat &amp; ketentuan</a> yang berlaku.
                    </span>
                    <div class="feedback-acc"></div>
                </label>
            </div>
            <div class="mt-5 mb-2">
                <button class="w-100 btn btn-lg btn-primary">
                    <span class="spinner-border spinner-border-sm text-white d-none" role="status"> 
                        <span class="sr-only">Loading...</span> 
                    </span>
                    Buat Akun
                </button>
            </div>
            <div class="mb-5 mt-4">
                <p class="_atau">Sudah punya akun?</p>
                <a href="<?= site_url('auth/masuk') ?>" class="btn btn-light btn-lg d-block">
                    Masuk
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    $('form').on('submit', function(e) {
        e.preventDefault();
        let form = $(this);
        $.post({
            url: base_url + 'auth/proses_daftar',
            data: form.serialize(),
            dataType: 'json',
            success: function(json) {
                if(json.status == 1) {
                    window.location.href = json.url;
                    $('.form-control').removeClass('is-invalid');

                } else {
                    if(json.status == 0) {
                        toast({
                            title: json.msg,
                            icon: 'error'
                        });

                        if(json.type == 'nama') {
                            $('#inp_nama').addClass('is-invalid');

                        } else if(json.type == 'email') {
                            $('#inp_email').addClass('is-invalid');

                        } else if(json.type == 'nohp') {
                            $('#inp_nohp').addClass('is-invalid');

                        } else if(json.type == 'pass') {
                            $('#inp_pass').addClass('is-invalid');

                        } else if(json.type == 'conf') {
                            $('#inp_pass, #inp_conf').addClass('is-invalid');

                        } else {
                            $('.form-control').removeClass('is-invalid');
                        }
                    }
                }
            }
        });
    })
</script>