<?php if($data) : ?>
    <?php foreach($data as $item) : ?>
        <article class="card mb-2">
            <div class="container py-4">
                <p class="d-flex justify-content-between mb-0">
                    <strong class="flex-grow-1">
                        <?= $item -> keterangan ?>
                    </strong>
                    <strong class="ps-2">
                        <?php
                            if($item -> status == 1 && $item -> tipe == 1) {
                                echo '+' . format_uang($item -> nominal);
                                
                            } else if($item -> status == 1 && $item -> tipe == 2) {
                                echo '-' . format_uang($item -> nominal);
                            } else {
                                echo format_uang($item -> nominal);
                            }
                        ?>
                    </strong>
                </p>
                <p class="mb-2">
                    <small>
                        <?= tgl(date('d F Y H:i', strtotime($item -> tgl))) ?> WIB
                    </small>
                </p>
                
                <?php if($item -> status > 0) : ?>
                    <p class="d-flex justify-content-between mb-0">
                        <strong>#<?= $item -> kode_ref ?></strong>
                        
                        <?php
                            if($item -> status == 1) {
                                echo '
                                    <strong class="text-success">
                                        Berhasil
                                    </strong>
                                ';
                                
                            } else if($item -> status == 2) {
                                echo '
                                    <strong class="text-danger">
                                        Dibatalkan
                                    </strong>
                                ';
                            }
                        ?>
                    </p>
                <?php endif ?>
                    
                <?php if($item -> status == 0) : ?>
                    <p class="d-flex justify-content-between mb-2">
                        <strong>#<?= $item -> kode_ref ?></strong>
                    </p>
                    
                    <p class="d-flex justify-content-between mb-0 mt-2 align-items-end">
                        <span>
                            <small class="text-muted">
                                Batas Pembayaran: 
                            </small>
                            <br>
                            <strong class="text-warning">
                                <?= tgl(date('d F Y H:i', strtotime($item -> kadaluarsa))) ?> WIB
                            </strong>
                        </span>
                        <button class="btn btn-warning btn-sm w-px-100" onclick="redirect('tagihan?produk=topup_saldo&id=<?= $item -> token ?>')">
                            Bayar
                        </button>
                    </p>
                <?php endif ?>
            </div>
        </article>
    <?php endforeach ?>
<?php else: ?>
    <article class="card">
        <div class="container py-5 text-center">
            <img src="<?= base_url('assets/img/no-money.png') ?>" class="w-px-100">
            <div class="mt-3">
                Belum ada riwayat
            </div>
        </div>
    </article>
<?php endif ?>
