<?php 
    $id = isset($data -> token) ? $data -> token : 0;
    $bank = isset($data -> nama_bank) ? $data -> nama_bank : null;
    $norek = isset($data -> nama_bank) ? $data -> norek : null;
    $atasnama = isset($data -> nama_bank) ? $data -> atasnama : null;
?>

<div class="page alamat">
    <div class="title">
        <h2><?= $form_title ?></h2>
    </div>
    <div>
        <div class="card">
            <div class="container pt-4 pb-5">
                <form method="post">
                    <input type="hidden" name="id" value="<?= $id ?>">
                    <div class="row mb-3">
                        <div class="col-sm-3 mb-2">
                            <strong>Nama Bank</strong>
                            <div class="mt-0">
                                <small>Pilih bank tujuan</small>
                            </div>
                        </div>
                        <div class="col-sm-9">
                            <select name="bank" class="form-select select2">
                                <option value="">Pilih</option>
                                <?php 
                                    $this -> db -> order_by('nama');
                                    $data = $this -> db -> get('bank_list') -> result();
                                    $html = '';
                            
                                    foreach($data as $item) {
                                        $selected = $item -> nama == $bank ? 'selected' : null;
                                        $html .= '
                                            <option '.$selected.'>'.$item -> nama.'</option>
                                        ';
                                    }

                                    echo $html;
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-sm-3 mb-2">
                            <strong>No Rekening</strong>
                            <div class="mt-0">
                                <small>Masukan no rekening tujuan</small>
                            </div>
                        </div>
                        <div class="col-sm-9">
                            <input type="number" name="norek" class="nochange form-control" value="<?= $norek ?>">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-sm-3 mb-2">
                            <strong>Atas Nama</strong>
                            <div class="mt-0">
                                <small>Masukan nama pemilik rekening</small>
                            </div>
                        </div>
                        <div class="col-sm-9">
                            <input name="atasnama" class="form-control" value="<?= $atasnama ?>">
                        </div>
                    </div>
                    <div class="mt-5">
                        <button class="btn btn-primary px-4 btn-full-mob">
                            Simpan
                        </button>
                        <a href="<?= isset($_GET['redirect']) ? site_url($_GET['redirect']) : site_url('akun/rekening') ?>" class="btn btn-light btn-full-mob">
                            Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    $('form').on('submit', function(e) {
        e.preventDefault();
        let form   = $('form').serialize();
        let url    = $('.url').val(); 

        confirm_submit.fire({
            text: 'Rekening baru akan disimpan, pastikan sudah diisi dengan benar'
            
        }).then(rest => {
            if(rest.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_rekening',
                    data: form,
                    dataType: 'json',
                    success: json => {
                        if(json.status == 1) {
                            confirm_success.fire({
                                html: json.msg,
                            }).then(res => {
                                redirect('akun/rekening');
                            })
                        }
                    }
                })
            }
        })
    })
</script>