<div class="page alamat">
    <div class="title">
        <h2>Rekening Saya</h2>
    </div>
    <div>
        <div class="card">
            <div class="container pt-4">
                <button class="btn btn-primary px-4 btn-full-mob" onclick="redirect('akun/rekening/form?aksi=tambah')">
                    <i class="fa fa-plus me-1"></i>
                    Tambah rekening
                </button>
            </div>
        </div>
        
        <?php if($data) : ?>
            <?php foreach($data as $item) : ?>
                <article class="card mb-2 cursor-pointer">
                    <div class="container py-4 d-flex justify-content-between align-items-start">
                        <div class="flex-grow-1 pe-3"  onclick="redirect('akun/rekening/form?aksi=edit&id=<?= $item -> token ?>')">
                            <strong>
                                <?= $item -> norek ?>
                            </strong>
                            <p class="mb-0">
                                <?= $item -> nama_bank ?>
                            </p>
                            <p class="mb-0">
                                <small>an <?= $item -> atasnama ?></small>
                            </p>
                        </div>
                        <div class="ps-2">
                            <button class="btn btn-danger btn-sm" onclick="hps_rekening('<?= $item -> token ?>')">
                                <i class="fa fa-trash me-1"></i>
                                Hapus
                            </button>
                        </div>
                    </div>
                </article>
            <?php endforeach ?>
        <?php else: ?>
                <div class="card">
                <div class="container py-5 text-center">
                    <a href="" class="d-block">
                        <img src="<?= base_url('assets/img/atm-card.png') ?>" class="w-px-120">
                    </a>
                    <p class="mb-0 mt-4">
                        Belum ada rekening
                    </p>
                </div>
            </div>
        <?php endif ?>
    </div>
</div>

<script>
    function hps_rekening(id) {
        hps_alert.fire({
            html: 'Rekening yang dihapus akan dihapus permanen',
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/hps_rekening',
                    data: {id:id},
                    dataType: 'json',
                    success: json => {
                        if(json.status == 1) {                            
                            confirm_success.fire({
                                html: 'Rekening yang dipilih sudah dihapus',
                            }).then(res => {
                                location.reload();
                            })
                        }
                    }
                })
            }
        })
    }
    
</script>