<style>
    .img img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
</style>
<?php if($data) : ?>
    <?php foreach($data as $item) : ?>
        <article class="card">
            <div class="container py-4">
                <div class="d-flex justify-content-between flex-wrap cursor-pointer" onclick="redirect('<?= $item -> view ?>', 0)">
                    <div class="img">
                        <img src="<?= $item -> thumb ?>" >
                    </div>
                    <div class="text">
                        <strong class="mb-1 d-block">
                            #<?= $item -> invoice ?>
                        </strong>
                        <p class="mb-1">
                            <small>
                                <?= $item -> jml_order ?> 
                                <span class="mx-1"> | </span>
                                <?= tgl(date('d F Y H:i', strtotime($item -> tgl_pesanan))) ?> WIB
                            </small>
                        </p>

                        <?php if($item -> kadaluarsa && $item -> status == 0) : ?>
                            <p class="mt-3">
                                <p class="mb-1">Batas Pembayaran: </p>
                                <strong class="text-warning">
                                    <?= tgl(date('d F Y H:i', strtotime($item -> kadaluarsa))) ?> WIB
                                </strong>
                            </p>
                        <?php endif ?>
                    </div>
                </div>
                <div class="footer d-flex justify-content-between align-items-center">
                    <div>
                        Total: <strong class="text-danger ms-2"><?= format_uang($item -> total_tr) ?></strong>
                    </div>
                    <div>
                        <?php if($item -> status < 3) : ?>
                            <button class="btn btn-sm btn-danger px-3" onclick="batalpesanan('<?= $item -> token ?>')">
                                <i class="fa fa-times"></i>
                            </button>
                        <?php endif ?>

                        <?php if($item -> status == 0) : ?>
                            <button class="btn btn-sm btn-warning px-3" onclick="redirect('tagihan?produk=<?= strtolower($item -> detail[0] -> jenis) ?>&id=<?= $item -> token ?>')">
                                Bayar
                            </button>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </article>
    <?php endforeach ?>
<?php else: ?>

    <article class="card mt-2">
            <div class="container py-5">
                <div class="d-flex justify-content-center flex-wrap">
                    <div class="my-3">
                        <img src="<?= base_url('assets/img/empty-produk.png') ?>" class="w-px-120">
                        <p class="mb-0 mt-3">
                            Belum ada pesanan
                        </p>
                    </div>
                </div>
            </div>
        </article>

<?php endif ?>