<div class="page detail">
    <div class="title">
        <h2>Detail Pesanan</h2>
    </div>
    <div class="content">
        <section class="card">
            <div class="container py-4">
                <p class="mb-1">
                    <strong>Status Pesanan</strong>
                </p>
                <h5 class="mb-1">
                    <?php 
                        switch($data -> status) {
                            case 0: 
                                echo '
                                    <strong class="text-warning">
                                        Belum bayar
                                    </strong>
                                ';
                            break;
                            case 1: 
                                echo '
                                    <strong class="text-info">
                                        Diproses
                                    </strong>
                                ';
                            break;
                            case 2: 
                                echo '
                                    <strong class="text-primary">
                                        Dikirm
                                    </strong>
                                ';
                            break;
                            case 3: 
                                echo '
                                    <strong class="text-success">
                                        Selesai
                                    </strong>
                                ';
                            break;
                            case 4: 
                                echo '
                                    <strong class="text-danger">
                                        Dibatalkan
                                    </strong>
                                ';
                            break;
                        }
                    ?>
                </h5>
                
                <?php if($data -> kadaluarsa && $data -> status == 0) : ?>
                    <h6 class="mt-4">
                        <strong>Batas Pembayaran</strong>
                    </h6>
                    <p class="mb-1">
                        <?= tgl(date('d F Y H:i', strtotime($data -> kadaluarsa))) ?> WIB
                    </p>
                <?php endif ?>

                <?php if($data -> status == 4 && $data -> keterangan) : ?>
                    <h6 class="mt-4">
                        <strong>Keterangan</strong>
                    </h6>
                    <p class="mb-1">
                        <?= $data -> keterangan ?> 
                    </p>
                <?php endif ?>
            </div>
        </section>

        <?php if($data -> alamat) : ?>
            <section class="card">
                <div class="container py-4">
                    <h6>
                        <strong>Alamat Pengiriman</strong>
                    </h6>
                    <p class="mb-1">
                        Septian Wahyudi Rahman
                    </p>
                    <p class="mb-1">
                        Jl. Raden Berneng, Dusun Todo Lauk, Desa Bnetek
                    </p>
                    <p class="mb-1">
                        08190199813
                    </p>
                </div>
            </section>
        <?php endif ?>

        <?php if($data -> kurir) : ?>
            <section class="card">
                <div class="container py-4">
                    <h6>
                        <strong>Informasi Pengiriman</strong>
                    </h6>
                    <p class="mb-1">
                        J&T Express (Reguler)
                    </p>
                    <p class="mb-1">
                        JP00917761
                    </p>
                </div>
            </section>
        <?php endif ?>

        <section class="card">
            <div class="container py-4">
                <h6>
                    <strong>Metode Pembayaran</strong>
                </h6>
                <p class="mb-1">
                    <?= $data -> nama_bayar ?>
                </p>
            </div>
        </section>

        <section class="card">
            <div class="container py-4">
                <h6 class="mb-4">
                    <strong>Detail Belanjaan</strong>
                </h6>

                <?php foreach($data -> detail as $detail) : ?>
                    <article class="card mt-3">
                        <div class="d-flex justify-content-between align-items-start pt-0">
                            <div class="img" onclick="redirect('<?= $detail -> slug ?>', 0)">
                                <img src="<?= $detail -> img ?>" >
                            </div>
                            <div class="text">
                                <p class="truncate-2 mb-1">
                                    <?= $detail -> nama_produk ?>
                                </p>
                                <p class="mb-2">
                                    <strong class="text-danger me-1">
                                        <?= format_uang($detail -> harga) ?>    
                                    </strong>
                                    <?php if($detail -> jenis == 'Fisik') : ?>
                                        <span>(<?= $detail -> jml ?> Barang)</span>
                                    <?php endif ?>
                                </p>
                                <?php if($detail -> varian) : ?>
                                    <div class="d-flex align-items-center mt-1">
                                        <span class="badge text-dark border me-1 bg-light">
                                            <?= $detail -> varian ?>
                                        </span>
                                    </div>
                                <?php endif ?>
                                <div class="mt-2 text-truncate">
                                    <?php if($detail -> catatan) : ?>
                                        <small class="text-muted">
                                            Catatan: <?= $detail -> catatan ?>
                                        </small>
                                    <?php endif ?>
                                </div>
                                <?php if($data -> status == 3) : ?>
                                    <div class="mt-2">
                                        <button class="badge badge-primary py-2 px-3"
                                            onclick="redirect('akun/pesanan?produk=<?= $_GET['produk'] ?>&ulasan=<?= $data -> token ?>')"
                                        >
                                            Buat Ulasan
                                        </button>
                                    </div>
                                <?php endif ?>
                            </div>
                        </div>
                    </article> 
                <?php endforeach ?>
            </div>
        </section>
        <section class="card">
            <div class="container py-4">
                <ul class="list-group list-group-flush m-0">
                    <li class="list-group-item">
                        <span class="float-start">Tgl Pesanan</span>
                        <strong class="float-end">
                            <?= date('d-m-Y H:i', strtotime($data -> tgl_pesanan)) ?>
                        </strong>
                    </li>
                    <?php if($data -> tgl_bayar) : ?>
                        <li class="list-group-item">
                            <span class="float-start">Tgl Pembayaran</span>
                            <strong class="float-end">
                                <?= date('d-m-Y H:i', strtotime($data -> tgl_bayar)) ?>
                            </strong>
                        </li>
                    <?php endif ?>

                    <?php if($data -> tgl_kirim) : ?>
                        <li class="list-group-item">
                            <span class="float-start">Tgl Pengiriman</span>
                            <strong class="float-end">
                                <?= date('d-m-Y H:i', strtotime($data -> tgl_kirim)) ?>
                            </strong>
                        </li>
                    <?php endif ?>

                    <?php if($data -> tgl_selesai) : ?>
                        <li class="list-group-item">
                            <span class="float-start">Tgl Selesai</span>
                            <strong class="float-end">
                                <?= date('d-m-Y H:i', strtotime($data -> tgl_selesai)) ?>
                            </strong>
                        </li>
                    <?php endif ?>

                    <?php if($data -> tgl_batal) : ?>
                        <li class="list-group-item">
                            <span class="float-start">Tgl Dibatalkan</span>
                            <strong class="float-end">
                                <?= date('d-m-Y H:i', strtotime($data -> tgl_batal)) ?>
                            </strong>
                        </li>
                    <?php endif ?>
                    
                    <li class="list-group-item">
                        <span class="float-start">Total Belanja</span>
                        <strong class="float-end">
                            <?= format_uang($data -> total) ?>
                        </strong>
                    </li>
                    <?php if($data -> diskon > 0) : ?>
                        <li class="list-group-item">
                            <span class="float-start">Diskon</span>
                            <strong class="float-end biaya_kirim_text">
                                -<?= format_uang($data -> diskon) ?>
                            </strong>
                        </li>
                    <?php endif ?>

                    <?php if($data -> diskon > 0) : ?>
                        <li class="list-group-item">
                            <span class="float-start">Biaya pengiriman</span>
                            <strong class="float-end biaya_kirim_text">
                                <?= format_uang($data -> ongkir) ?>
                            </strong>
                        </li>
                    <?php endif ?>

                    <li class="list-group-item text-danger">
                        <strong class="float-start">Total Pembayaran</strong>
                        <strong class="float-end total_tagihan_text">
                             <?= format_uang($data -> total + $data -> ongkir - $data -> diskon) ?>
                        </strong>
                    </li>
                </ul>
            </div>
        </section>
        <section class="card btn-aksi">
            <div class="container py-4 text-center">
                <?php if($data -> status == 0) : ?>
                    <button class="btn btn-warning px-4" 
                            onclick="redirect('tagihan?produk=<?= $_GET['produk'] ?>&id=<?= $data -> token ?>')"
                    >
                        Bayar Pesanan
                    </button>
                   
                <?php endif ?>

                <?php if($data -> status < 3) : ?>
                    <button class="btn btn-danger px-4" onclick="batalpesanan('<?= $data -> token ?>')">
                        Batalkan Pesanan
                    </button>
                <?php endif?>
            </div>
        </section>
    </div>
</div>