<div class="akun">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-12">
                <div class="card info">
                    <div class="card-header pt-4 pb-5 d-flex justify-content-between align-items-center">
                        <div class="img">
                            <span><?= $this -> app -> get_init(user('nama')) ?></span>
                        </div>
                        <div class="text">
                            <h6 class="mb-1">
                                <strong>
                                    <?= user('nama') ?>
                                </strong>
                            </h6>
                            <small>
                                <?= user('email') ?>
                            </small>
                            <div class="mt-1">
                                <?php if(user('level') == 2) : ?>
                                    <span class="user-level gold">
                                        Premium
                                    </span>
                                <?php else: ?>
                                    <span class="user-level bronze">
                                        Reguler
                                    </span>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="saldo d-flex justify-content-between align-items-center">
                            <div>
                                <p class="mb-1">
                                    Saldo saat ini
                                </p>
                                <h5 class="mb-0">
                                    <strong><?= $this -> app -> get_saldo(true) ?></strong>
                                </h5>
                            </div>
                            <div class="text-center topup d-flex">                                
                                <?php if(empty($this -> app -> cek_topup_status(0))) : ?>
                                    <div>
                                        <button class="fa fa-plus btn_topup"></button>
                                        <small class="d-block">Top Up</small>
                                    </div>
                                <?php else: ?>
                                    <div>
                                        <button class="fa fa-plus" 
                                                onclick="redirect('tagihan?produk=topup_saldo&id=<?= $this -> app -> cek_topup_status(0) -> token ?>')">
                                        </button>
                                        <small class="d-block">Top Up</small>
                                    </div>
                                <?php endif ?>

                                <div class="ms-2">
                                    <button class="fa fa-credit-card btn_wd"></button>
                                    <small class="d-block">Tarik</small>
                                </div>
                            </div>
                        </div>

                        <div class="menu">
                            <h6><strong>Main Menu</strong></h6>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item" onclick="redirect('akun/ubah')">
                                    <span class="float-start">
                                        <i class="fa fa-user me-2"></i>
                                        Akun saya
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/pesanan?produk=fisik')">
                                    <span class="float-start">
                                        <i class="fa fa-shopping-basket me-2"></i>
                                        Pesanan saya
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/pesanan?produk=digital')">
                                    <span class="float-start">
                                        <i class="fa fa-window-maximize me-2"></i>
                                        Produk Digital
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/saldo')">
                                    <span class="float-start">
                                        <i class="fa fa-receipt me-2"></i>
                                        Riwayat Saldo
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/alamat')">
                                    <span class="float-start">
                                        <i class="fa fa-map-marker-alt me-2"></i>
                                        Alamat Saya
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/rekening')">
                                    <span class="float-start">
                                        <i class="fa fa-credit-card me-2"></i>
                                        Rekening Saya
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/favorit')">
                                    <span class="float-start">
                                        <i class="fa fa-heart me-2"></i>
                                        Favorit
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item text-danger border-bottom logout">
                                    <span class="float-start">
                                        <i class="fa fa-sign-out me-2"></i>
                                        Keluar
                                    </span>
                                </li>
                            </ul>
                            <div class="text-center appV">
                                <small>versi 1.0</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<form method="POST" class="modal fade" id="modal_wd">
    <div class="modal-dialog modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header">
                <div class="_title d-flex align-items-center">
                    <a href="" data-bs-dismiss="modal" class="close">
                        <i class="fa fa-times"></i>
                    </a>
                    <h2>Tarik Saldo</h2>
                </div>
            </div>
            <div class="modal-body">
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                    <h6 class="mb-0 mt-2"> 
                        Memuat Data
                    </h6>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
    $('.logout').on('click', function() {
        Swal.fire({
            icon: 'question',
            title: 'Apakah anda yakin',
            html: 'Anda akan keluar dari akun ini',
            showCancelButton: true,
            confirmButtonText:'Keluar',
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger me-3',
                cancelButton: 'btn btn-light',
            }
        }).then(res => {
            if(res.isConfirmed) {
                window.location.href = base_url + 'auth/logout'
            }
        })
    });

    $('.btn_wd').on('click', function() {
        $.post({
            url: base_url + 'proses/modal_tarik',
            dataType: 'html',
            success: data => {
                $('#modal_wd').modal('show').find('.modal-content').html(data);
            }
        })
    });

    $('#modal_wd').on('submit', function(e) {
        e.preventDefault();
        let admin = 1000;
        let form  = $(this);

        $('.btn_submit_wd').attr('disabled', true);

        confirm_submit.fire({
            text: 'Penarikan saldo dikenakan biaya admin Rp' + nf(String(admin)),
            confirmButtonText: 'Tarik Saldo'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_tarik',
                    data: form.serialize(),
                    dataType: 'json',
                    success: json => {
                        if(json.status == 1) {
                            $('.modal').modal('hide');
                        }
                    }
                })
            } else {
                $('.btn_submit_wd').attr('disabled', false);
            }
        })
    })

</script>