<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proses extends CI_Controller {
    public function get_produk() {
        $index    = $_POST['index'];
        $kategori = $_POST['kategori'];
        $limit    = 20;
        $data     = $this -> app -> get_produk([
            'limit'    => $limit, 
            'index'    => $index, 
            'kategori' => $kategori
        ]);

        $this -> load -> view('produk/item', ['get' => $data, 'index' => $index]);
    }

    public function get_keranjang() {
        $data = $this -> app -> get_keranjang();

        $this -> load -> view('keranjang/item', ['data' => $data]);
    }

    public function searching() {
        $value = $_POST['value'];
        $data  = $this -> app -> searching($value);

        echo $data;
    }

    public function get_rekom() {
        $this -> load -> view('rekom_src');
    }

    public function addcart() {
		$id = $_POST['id'];
		$this -> load -> view('modal/addcart', ['id' => $id]);
	}

    public function simpan_keranjang() {
        $sesi = $this -> session -> ci_usrid;
        $input = $this -> input -> post(null, TRUE);

        if($sesi) {
            $id       = $input['id'];
            $idvarian = $input['varian'];
            $idsubvar = $input['subvar'];
            $jml      = $input['jml'];
            $produk   = $this -> app -> get_produk(['id' => $id]);
            
            if($idvarian > 0) {
                $varian = $this -> app -> get_detail_varian($idvarian, $idsubvar);
                $harga  = $varian -> harga - $varian -> diskon;
                
            } else {
                $varian = $this -> app -> get_produk(['id' => $id]);
                $harga  = $varian -> harga - $varian -> diskon;
            }

            $simpan   = [
                'id_transaksi'  => 0,
                'id_produk'     => $id,
                'varian'        => $idvarian,
                'varian_sub'    => $idsubvar,
                'id_user'       => $sesi,
                'jml'           => $jml,
                'jenis'         => $produk -> jenis,
                'harga'         => $harga,
            ];
            $where = $simpan;

            unset($where['jml']);
            unset($where['harga']);
            unset($where['jenis']);
            
            $trx = $this -> app -> get_transaksi_produk($where);

            if($trx) {
                $update['jml'] = $produk -> jenis == 'Fisik' ? $trx -> jml + 1 : 1;
                $this -> db -> update('transaksi_detail', $update, $where);
                echo json_encode(['status' => 1, 'msg' => 'Jml '.$produk -> nama.' diupdate']);
                
            } else {
                $simpan['token'] = md5('CART' . date('dmy') . rand(11111,99999));
                $this -> db -> insert('transaksi_detail', $simpan);
                echo json_encode(
                    ['status' => 1, 'msg' => $produk -> nama. ' ditambahkan ke keranjang']
                );
            }
            

        } else {
            echo json_encode(['status' => 0, 'Silahkan login']);
        }    
	}

    public function hps_cart() {
        $id = $_POST['id'];
        $this -> db -> delete('transaksi_detail', ['id' => $id]);

        echo json_encode(['status' => 1]);
    }

    public function change_varian() {
        $trx    = $_POST['trx'];
        $id     = $_POST['id'];
        $varian = $_POST['varian'];
        $sub    = $_POST['sub'];

        $conf = [
            'id'     => $id,
            'varian' => $varian,
            'sub'    => $sub,
            'trx'    => $trx,
        ];

        $this -> load -> view('modal/changevarian', $conf);
    }

    public function simpan_varian() {
        $trx    = $_POST['trx'];
        $varian = $_POST['varian'];
        $subvar = $_POST['subvar'];
        $getvar = $this -> app -> get_detail_varian($varian, $subvar);
        $harga  = $getvar -> harga - $getvar -> diskon;

        $update = [
            'varian'     => $varian,
            'varian_sub' => $subvar,
            'harga'      => $harga,
        ];
        $where['id'] = $trx;

        $this -> db -> update('transaksi_detail', $update, $where);
        echo json_encode(['status' => 1]);
            
    }

    public function addket() {
        $trx     = $_POST['trx'];
        $id      = $_POST['id'];
        $varian  = $_POST['varian'];
        $sub     = $_POST['sub'];

        $conf = [
            'trx'    => $trx,
            'id'     => $id,
            'varian' => $varian,
            'sub'    => $sub,
        ];

        $this -> load -> view('modal/addket', $conf);
    }

    public function simpanket() {
        $trx['id']          = $_POST['trx'];
        $value['catatan']   = $_POST['value'];
        $this -> db -> update('transaksi_detail', $value, $trx);

        echo json_encode(['status' => 1]);
    }

    public function modal_bayar() {
        $modal = $_POST['modal'];

        if($modal == 'addr') {
            $data = $this -> app -> get_alamat();
            $this -> load -> view('modal/addr', ['data' => $data]); 

        } else if($modal == 'bayar') {
            $this -> load -> model('Payment_model', 'payment');
            $data = $this -> payment -> get_payment(false);
            $this -> load -> view('modal/payment', ['data' => $data]); 

        } else if($modal == 'kurir') {
            $this -> load -> model('Kurir_model', 'kurir');
            $data = $this -> kurir -> cost();
            $this -> load -> view('modal/kurir', ['data' => $data]); 
        }        
    }

    public function get_notif() {
        $data = $this -> app -> get_notif();
        $this -> load -> view('notif', ['data' => $data]);
    }

    public function update_notif() {
        $sesi     = $this -> session -> ci_usrid;
        $id       = isset($_POST['id']) ? $_POST['id'] : 'semua';
        $jmlnotif = $this -> db -> get_where('notif', ['is_read' => 0]) -> num_rows();

        if($jmlnotif > 0) {
            if($id == 'semua') {
                $this -> db -> update('notif', ['is_read' => 1], ['usrid' => $sesi]);
                
            } else {
                $this -> db -> update('notif', ['is_read' => 1], ['usrid' => $sesi, 'token' => $id]);
            }
        }

        echo json_encode(['status' => 1, 'row' => $jmlnotif]);
    }

    public function favorit() {
        $id = $this -> session -> ci_usrid;
        if($_POST['status'] == 1) {
            $this -> db -> insert('favorit', ['usrid' => $id, 'id_produk' => $_POST['id']]);
            echo json_encode(
                [
                    'status' => 1,
                    'msg' => 'Produk ditambahkan ke favorit'
                ]
            );
        } else {
            $where = isset($_POST['id_fav']) ? ['id' => $_POST['id_fav']] 
                        : ['usrid' => $id, 'id_produk' => $_POST['id']];
            $this -> db -> delete('favorit', $where);
            echo json_encode(
                [
                    'status' => 1,
                    'msg'    => 'Produk dihapus dari favorit'
                ]
            );
        }
    }

    public function get_kab() {
        $prov = $_POST['prov'];
        $data = $this -> app -> get_kab($prov);
        $html = '<option value="" disabled selected>Pilih kabupaten / kota</option>';

        foreach($data as $item) {
            $html .= '
                <option value="'.$item -> id.'">
                '.$item -> tipe.' '.$item -> nama.'
                </option>
            ';
        }

        echo $html;
    }

    public function get_kec() {
        $kab = $_POST['kab'];
        $data = $this -> app -> get_kec($kab);
        $html = '<option value="" disabled selected>Pilih kecamatan</option>';

        foreach($data as $item) {
            $html .= '
                <option value="'.$item -> id.'">
                    Kecamatan '.$item -> nama.'
                </option>
            ';
        }

        echo $html;
    }

    public function get_kel() {
        $kec = $_POST['kec'];
        $data = $this -> app -> get_kel($kec);
        $html = '';

        foreach($data as $item) {
            $html .= '
                <option value="'.$item -> id.'">
                    '.$item -> nama.'
                </option>
            ';
        }

        echo $html;
    }

    public function submit_addr() {
        $sesi = $this -> session -> ci_usrid;

        if($sesi) {
            if(empty($_POST['penerima'])) {
                echo json_encode(['status' => 0, 'msg' => 'Nama penerima belum diisi']);
    
            } else if(empty($_POST['nohp'])) {
                echo json_encode(['status' => 0, 'msg' => 'No Handphone belum diisi']);
                
            } else if(empty($_POST['prov'])) {
                echo json_encode(['status' => 0, 'msg' => 'Provisi belum dipilih']);
                
            } else if(empty($_POST['kab'])) {
                echo json_encode(['status' => 0, 'msg' => 'Kabupaten belum dipilih']);
                
            } else if(empty($_POST['kec'])) {
                echo json_encode(['status' => 0, 'msg' => 'Kecamatan belum dipilih']);    
    
            } else {
                $data = [
                    'judul'     => isset($_POST['judul']) ? $_POST['judul'] : '',
                    'penerima'  => $_POST['penerima'],
                    'nohp'      => $_POST['nohp'],
                    'alamat'    => $_POST['alamat'],
                    'prov'      => $_POST['prov'],
                    'kab'       => $_POST['kab'],
                    'kec'       => $_POST['kec'],
                    'kel'       => $_POST['kel'],
                    'usrid'     => $sesi
                ];

                if(isset($_POST['utama'])) {
                    $this -> db -> update('alamat', ['usrid' => $sesi, 'utama' => 0]);
                    $data['utama'] = 1;
                } else {
                    $data['utama'] = 0;
                }

                if($_POST['id'] == 0) {

                    $this -> db -> insert('alamat', $data);
                    echo json_encode(['status' => 1, 'msg' => 'Alamat baru sudah ditambahkan']);
                    
                } else {
                    $this -> db -> update('alamat', $data, ['id' => $_POST['id']]);
                    echo json_encode(['status' => 1, 'msg' => 'Data alamat sudah diupdate']);
                }
            }

        }
    }

    public function submit_rekening() {
        $sesi = $this -> session -> ci_usrid;

        if($sesi) {
            if(empty($_POST['bank'])) {
                echo json_encode(['status' => 0, 'msg' => 'Bank belum dipilih']);
    
            } else if(empty($_POST['norek'])) {
                echo json_encode(['status' => 0, 'msg' => 'No rekening belum diisi']);
                
            } else if(empty($_POST['atasnama'])) {
                echo json_encode(['status' => 0, 'msg' => 'Atas nama belum diisi']);
                
            } else {
                $data = [
                    'nama_bank' => $_POST['bank'],
                    'norek'     => $_POST['norek'],
                    'atasnama'  => $_POST['atasnama'],
                    'usrid'     => $sesi,
                ];

                if($_POST['id'] == 0) {
                    $data['token'] = md5(rand(111111111, 999999999));
                    $this -> db -> insert('user_rekening', $data);
                    echo json_encode(['status' => 1, 'msg' => 'Rekening baru sudah ditambahkan']);
                    
                } else {
                    $this -> db -> update('user_rekening', $data, ['token' => $_POST['id']]);
                    echo json_encode(['status' => 1, 'msg' => 'Data rekening sudah diupdate']);
                }
            }

        }
    }

    public function hps_addr() {
        $id = $_POST['id'];
        $this -> db -> delete('alamat', ['id' => $id]);

        echo json_encode(['status' => 1, 'msg' => 'Data alamat sudah diupdate']);
    }

    public function hps_rekening() {
        $id = $_POST['id'];
        $this -> db -> delete('user_rekening', ['token' => $id]);

        echo json_encode(['status' => 1, 'msg' => 'Data rekening sudah dihapus']);
    }

    public function pilih_addr() {
        $id = $_POST['id'];
        $sesi = $this -> session -> ci_usrid;
        $this -> db -> update('alamat', ['utama' => 0], ['usrid' => $sesi]);
        $this -> db -> update('alamat', ['utama' => 1], ['id' => $id]);

        echo json_encode(['status' => 1, 'msg' => 'Data alamat sudah diupdate']);
    }

    public function get_intruksi() {
        $this -> load -> model('Payment_model', 'payment');

        $html     = '';
        $kode     = $_POST['code'];
        $total    = $_POST['amount'];
        $pay_code = $_POST['pay_code'];
        $get      = $this -> payment -> intruksi($kode, $pay_code, $total);

        $this -> load -> view('modal/instruksi', ['get' => $get]);
    }

    public function buat_pesanan() {
        $this -> load -> model('Payment_model', 'payment');

        $biaya_admin = 0;
        $cart        = [];
        $sesi        = $this -> session -> ci_usrid;
        $keranjang   = $this -> app -> get_keranjang(false);
        $kodetrx     = 'TRX' . date('ymdHis') . rand(111, 999);        
        $total       = $this -> app -> total_keranjang();
        $kadaluarsa  = (time() + (12 * 60 * 60)); 
        $token       = md5($kodetrx . rand(1111, 9999));
        $saldo_awal  = $this -> app -> get_saldo();

        foreach($keranjang as $item) {
            $cart[] = [
                'sku'       => $item -> id_produk,
                'name'      => $item -> nama_produk,
                'quantity'  => $item -> jml,
                'price'     => $item -> harga,
            ];
            $jenis = $item -> jenis == 'Digital' ? 'digital' : 'fisik';
        }

        $jenis_notif    = 'blm_bayar';
        $judul_notif    = 'Belum dibayar';
        $url_notif      = site_url("tagihan?produk=$jenis&id=$token"); 
        $deskripsi      = 'Pesanan dengan kode ' 
                        . $kodetrx 
                        . ' sudah dbuat. Harap melakukan pembayaran sebelum tgl ' 
                        . tgl(date('d F Y H:i') . ' WIB');

        if(empty($_POST['pembayaran'])) {
            echo json_encode(['status' => 0, 'msg' => 'Metode pembayaran belum dipilih']);
            exit;
        }
        
        if($_POST['pembayaran'] == 'CISA') {            
            if($total > $saldo_awal) {
                echo json_encode(['status' => 0, 'msg' => 'Saldo tidak mencukupi']);
                die;
                
            } else {
                $nama_bayar  = 'Saldo ' . app('app_name');
                $saldo_akhir = $saldo_awal - $total;
                $this -> db -> update('saldo', ['saldo' => $saldo_akhir], ['usrid' => $sesi]);

                $riwayat = [
                    'kode_ref'      => date('ymdhi').rand(11111, 99999),
                    'usrid'         => $sesi,
                    'saldo_awal'    => $saldo_awal,
                    'Saldo_akhir'   => $saldo_akhir,
                    'keterangan'    => 'Belanja',
                    'tipe'          => 2,
                    'tgl'           => date('Y-m-d H:i:s')
                ];

                $this -> db -> insert('saldo_riwayat', $riwayat);
            }

            $jenis_notif  = 'diproses';
            $judul_notif  = 'Sedang diproses';
            $deskripsi    = 'Pesanan dengan kode ' . $kodetrx . ' ' . strtolower($judul_notif); 
        } 

        if($_POST['gateway'] == 'Tripay') {
            $payload = [
                'metode'     => $_POST['pembayaran'],
                'total'      => $total,
                'trxcode'    => $kodetrx,
                'nama'       => user('nama'),
                'email'      => user('email'),
                'nohp'       => user('nohp'),
                'cart'       => $cart,
                'kadaluarsa' => $kadaluarsa
            ]; 
            
            $create      = $this -> payment -> create_transaction($payload);
            $biaya_admin = isset($create -> fee_customer) ? $create -> fee_customer : 0;
            $nama_bayar  = isset($create -> payment_name) ? $create -> payment_name : '';

            $tripay      = [
                'reference'      => $create -> reference,
                'merchant_ref'   => $kodetrx,
                'payment_method' => $create -> payment_method,
                'payment_name'   => $create -> payment_name,
                'pay_code'       => isset($create -> pay_code) ? $create -> pay_code : '',
                'checkout_url'   => $create -> checkout_url,
                'icon'           => $_POST['icon']
            ];

            $this -> db -> insert('transaksi_tripay', $tripay);

        } else if($_POST['gateway'] == 'Transfer Manual') {
            $biaya_admin = $this -> app -> get_bank_bayar($_POST['pembayaran'], 'fee');
            $nama_bayar  = $this -> app -> get_bank_bayar($_POST['pembayaran'], 'nama');
            $nama_bayar  = 'Transfer ' . $nama_bayar;
        } 

        $transaksi = [
            'invoice'        => $kodetrx,
            'nama_bayar'     => $nama_bayar,
            'total'          => $total,
            'biaya_admin'    => $biaya_admin,
            'token'          => $token,
            'usrid'          => $sesi,
            'kadaluarsa'     => $_POST['pembayaran'] == 'CISA' ? null : date('Y-m-d H:i:s', $kadaluarsa),
            'tgl_bayar'      => $_POST['pembayaran'] == 'CISA' ? date('Y-m-d H:i:s') : null,
            'tgl_proses'     => $_POST['pembayaran'] == 'CISA' ? date('Y-m-d H:i:s') : null,
            'status'         => $_POST['pembayaran'] == 'CISA' ? 1 : 0,
            'metode_bayar'   => $_POST['pembayaran'],
            'gateway'        => $_POST['gateway'],
            'kurir'          => $_POST['kurir'],
            'paket'          => $_POST['paket'],
            'tgl_pesanan'    => date('Y-m-d H:i:s'),
        ];
        
        $this -> db -> insert('transaksi', $transaksi);
        $idtrx = $this -> db -> insert_id();

        foreach($keranjang as $item) {
            $this -> db -> where('id_transaksi', 0);
            $this -> db -> where('id_user', $sesi);
            $this -> db -> update('transaksi_detail', ['id_transaksi' => $idtrx]);
        }
 
        if($_POST['pembayaran'] == 'CISA') {
            $url_notif = site_url("akun/pesanan?produk=$jenis&detail=$token");
            echo json_encode(['status' => 1, 'url' => site_url('akun/pesanan?tab=1&produk=' . $jenis)]);
            
        } else {
            echo json_encode(['status' => 1, 'url' => site_url("tagihan?produk=$jenis&id=" . $token)]);
        }

        $notif      = [
            'jenis'     => $jenis_notif,
            'judul'     => $judul_notif,
            'usrid'     => $sesi,
            'url'       => $url_notif,
            'deskripsi' => $deskripsi
        ];

        $this -> app -> push_notif($notif);
        
    }

    public function pesanan() {
        $data = $this -> app -> get_semua_transaksi($_POST['status'], $_POST['jenis']);
        $this -> load -> view('akun/pesanan/item', ['data' => $data]);
    }

    public function batalkan_pesanan() {
        $cek          = $this -> app -> get_detail_transaksi($_POST['id']);
        $url_notif    = http_build_query([
            'produk'  => strtolower($cek -> detail[0] -> jenis),
            'detail'  => $cek -> token
        ]);
        $url_notif    = "akun/pesanan?{$url_notif}";
        $sesi         = $this -> session -> ci_usrid;
        $notif_refund = '';

        if($cek -> status == 1) {
            $saldo_awal   = $this -> app -> get_saldo();
            $jml          = $cek -> total + $cek -> ongkir;
            $saldo_akhir  = $saldo_awal +  $jml;
            $notif_refund = ' Dana sudah dikembalikan sebesar ' . format_uang($jml);

            $riwayat = [
                'kode_ref'      => date('ymdhi').rand(11111, 99999),
                'usrid'         => $sesi,
                'nominal'       => $jml,
                'saldo_awal'    => $saldo_awal,
                'Saldo_akhir'   => $saldo_akhir,
                'keterangan'    => 'Refund Dana Belanja',
                'tipe'          => 1,
                'tgl'           => date('Y-m-d H:i:s')
            ];

            $this -> db -> update('saldo', ['saldo' => $saldo_akhir], ['usrid' => $sesi]);
            $this -> db -> insert('saldo_riwayat', $riwayat);
            
        } 

        $notif      = [
            'jenis'     => 'batal',
            'judul'     => 'Pesanan dibatalkan',
            'usrid'     => $sesi,
            'url'       => $url_notif,
            'deskripsi' => 'Pesanan ' . $cek -> invoice . ' dibatalkan pembeli.' . $notif_refund
        ];

        $this -> app -> push_notif($notif);
        $this -> db -> update('transaksi', ['status' => 4, 'tgl_batal' => date('Y-m-d H:i:s'), 'keterangan' => 'Pesanan dibatalkan pembeli'], ['token' => $_POST['id']]);
        echo json_encode(['status' => 1, 'msg' => 'Pesanan sudah dibatalkan']);

    }

    public function autoupdate() {
        $this -> app -> autoupdate();

        echo json_encode(['msg' => 'Sedang mencari data']);
    }

    public function modal_topup() {
        $this -> load -> model('Payment_model', 'payment');
        $data = $this -> payment -> get_payment(false, false);
        $this -> load -> view('modal/topup', ['data' => $data]);
    }
    
    public function modal_tarik() {
        $saldo =  $this -> app -> get_saldo();
        $rek   =  $this -> app -> get_rekening();

        $this -> load -> view('modal/penarikan', ['saldo' => $saldo, 'rek' => $rek]);
    }

    public function cek_form_topup() {
        $min = 50000;
        $max = 2000000;

        $_POST['nominal_tf'] = str_replace('.','',$_POST['nominal_tf']);

        if(empty($_POST['nominal_tf'])) {
            echo json_encode(['msg' => 'Nominal top up belum diisi']);

        } else if($_POST['nominal_tf'] < $min) {
            echo json_encode(['msg' => 'Nominal top up kurang dari ' .  format_uang($min)]);

        } else if($_POST['nominal_tf'] > $max) {
            echo json_encode(['msg' => 'Maksimal top up ' .  format_uang($max)]);

        } else if(empty($_POST['payment_tf'])) {
            echo json_encode(['msg' => 'Metode pembayaran belum dipilih']);

        } else {
            echo json_encode(['msg' => 'next']);
        }
    }

    public function submit_topup() {
        if(!empty($_POST['nominal_tf']) && !empty($_POST['payment_tf'])) {
            $_POST['nominal_tf'] = format_uang($_POST['nominal_tf'], false);

            $sesi       = $this -> session -> ci_usrid;
            $kode       = 'TF' . date('dmyhi') . rand(111, 999);
            $jenis      = 'topup_saldo';
            $kadaluarsa = (time() + 60 * 60 * 12);
            $token      = md5($kode);
            $url_notif  = site_url("tagihan?produk=$jenis&id=$token");              
            $deskripsi  = 'Anda telah membuat permintaan top up saldo sebesar ' .
                        format_uang($_POST['nominal_tf']) .
                        '. Harap melakukan pembayaran sebelum tgl ' . 
                        tgl(date('d F Y G:i', $kadaluarsa)) . ' WIB'
            ;

            if($_POST['payment_tf_gateway'] == 'Tripay') {
                $this -> load -> model('Payment_model', 'payment');

                $payload = [
                    'trxcode'    => $kode,
                    'kadaluarsa' => $kadaluarsa,
                    'metode'     => $_POST['payment_tf'],
                    'total'      => $_POST['nominal_tf'],
                    'nama'       => user('nama'),
                    'email'      => user('email'),
                    'nohp'       => user('nohp'),
                    'cart'       => [
                        [                           
                            'sku'       => 'CISA',
                            'name'      => 'Top up saldo ' . app('app_name'),
                            'quantity'  => 1,
                            'price'     => $_POST['nominal_tf'],
                        ]
                    ]
                ]; 
                
                $create      = $this -> payment -> create_transaction($payload);
                $biaya_admin = isset($create -> fee_customer) ? $create -> fee_customer : 0;
                $nama_bayar  = isset($create -> payment_name) ? $create -> payment_name : '';
    
                $tripay      = [
                    'jenis'          => 'topup',
                    'reference'      => $create -> reference,
                    'merchant_ref'   => $kode,
                    'payment_method' => $create -> payment_method,
                    'payment_name'   => $create -> payment_name,
                    'pay_code'       => isset($create -> pay_code) ? $create -> pay_code : '',
                    'checkout_url'   => $create -> checkout_url,
                    'icon'           => $_POST['payment_tf_icon']
                ];
    
                $this -> db -> insert('transaksi_tripay', $tripay);

            } else if($_POST['payment_tf_gateway'] == 'Transfer Manual') {
                $biaya_admin = $this -> app -> get_bank_bayar($_POST['payment_tf'], 'fee');
                $nama_bayar  = $this -> app -> get_bank_bayar($_POST['payment_tf'], 'nama');
                $nama_bayar  = 'Transfer ' . $nama_bayar;
            } 

            $req   = [
                'kode_ref'      => $kode,
                'usrid'         => $sesi,
                'tgl'           => date('Y-m-d H:i:s'),
                'kadaluarsa'    => date('Y-m-d H:i:s', $kadaluarsa),
                'status'        => 0,
                'keterangan'    => 'Topup Saldo',
                'gateway'       => $_POST['payment_tf_gateway'],
                'nominal'       => $_POST['nominal_tf'],
                'payment_code'  => $_POST['payment_tf'],
                'payment_name'  => $nama_bayar,
                'biaya_admin'   => $biaya_admin,
                'token'         => $token
            ];

            $this -> db -> insert('saldo_riwayat', $req);

            echo json_encode(['status' => 1, 'url' => $url_notif]);
            
            $push_notif      = [
                'jenis'     => $jenis,
                'judul'     => 'Permintaan Top Up Saldo',
                'url'       => $url_notif,
                'deskripsi' => $deskripsi,
                'usrid'     => $sesi,
            ];

            $this -> app -> push_notif($push_notif);
        }
        
    }

    public function batalkan_topup() {
        $id     = $_POST['id'];
        $sesi   = $this -> session -> ci_usrid;
        $this -> db -> update('saldo_riwayat', ['status' => 2], ['token' => $id]);

        echo json_encode(['status' => 1]);

        $push_notif      = [
            'jenis'     => 'batal',
            'judul'     => 'Top up saldo dibatalkan',
            'url'       => site_url('saldo?detail=' . $id),
            'deskripsi' => 'Topup saldo dibatalkan oleh user',
            'usrid'     => $sesi,
        ];

        $this -> app -> push_notif($push_notif);
    }

    public function riwayat_tf_item() {
        $data = $this -> app -> get_riwayat_saldo();
        $this -> load -> view('akun/saldo/item', ['data' => $data]);
    }

    public function submit_tarik() {
        $_POST = $this -> input -> post(null, TRUE);
        $token = md5('tk' . date('ymdhis') . rand(1111, 9999));
        $kode  = 'TK' . date() . rand(111, 999);

        $tarik = [
            
        ];
        echo json_encode(['success' => 0, 'data' => $_POST]);
    }

    public function tes() {
        $this -> load -> model('Payment_model', 'payment');
        $status = 'semua';
        // $data = $this -> app -> get_semua_transaksi('0fd1eb1eeb6825186c060655e0c07c17');
        // $data = $this -> app -> get_semua_transaksi();
        // $data =  $this -> app -> get_riwayat_saldo();
        // $data = $this -> payment -> get_payment();

        $data = user('max_saldo');

        echo '<pre>';
        print_r($data);
    }
}

// Controller Proses
// Kode ini dibuat oleh codelingker