<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Akun extends CI_Controller {
    public function __construct() {
        parent::__construct();
        cek_log();
    }

	public function index() {
		$conf = [
			'title'        => 'Akun | ' . app('app_name'),
			'header_right' => true
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('akun/main');
		$this -> load -> view('layout/footer');
	}

	public function ubah() {
		$conf = [
			'title'      => 'Ubah Akun | ' . app('app_name'),
			'page_title' => 'Ubah Akun',
			'backto'     => site_url('akun'),   
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('akun/ubah');
		$this -> load -> view('layout/footer');
	}

	public function favorit() {
		$conf = [
			'title'  => 'Favorit | ' . app('app_name'),
			'data'	 => $this -> app -> get_favorit(),
			'page_title' => 'Favorit',
			'backto'     => site_url('akun'),   
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('akun/favorit');
		$this -> load -> view('layout/footer');
	}

	public function alamat($page = 'main') {
		if($page == 'form') {
			$title   = isset($_GET['aksi']) && $_GET['aksi'] == 'tambah' ? 'Tambah Alamat' : 'Edit Alamat';
			$data    = isset($_GET['aksi']) && isset($_GET['id']) ? $this -> app -> get_alamat($_GET['id']) : null;
			$primary = $this -> app -> get_alamat('cek_primary');
			
			$conf = [
				'title'  	 => $title . ' | ' . app('app_name'),
				'data_prov'	 => $this -> app -> get_prov(),
				'form_title' => $title,
				'data' 		 => $data,
				'page_title' => 'Tambah Alamat',
				'primary' 	 => $primary
			];
	
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/alamat_add');
			$this -> load -> view('layout/footer');

		} else {
			$conf = [
				'title'  	 => 'Alamat saya | ' . app('app_name'),
				'data'	 	 => $this -> app -> get_alamat(),
				'page_title' => 'Alamat Saya',
				'backto'     => site_url('akun'),   
			];
	
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/alamat');
			$this -> load -> view('layout/footer');

		}
	}

	public function rekening($page = 'main') {
		if($page == 'form') {
			$title   = isset($_GET['aksi']) && $_GET['aksi'] == 'tambah' ? 'Tambah Rekening' : 'Edit Rekening';
			$data    = isset($_GET['aksi']) && isset($_GET['id']) ? $this -> app -> get_rekening($_GET['id']) : null;
			
			$conf = [
				'title'  	 => $title . ' | ' . app('app_name'),
				'data_prov'	 => $this -> app -> get_prov(),
				'form_title' => $title,
				'data' 		 => $data,
				'page_title' => $title,
			];
	
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/rekening_add');
			$this -> load -> view('layout/footer');

		} else {
			$conf = [
				'title'  	 => 'Rekening saya | ' . app('app_name'),
				'data'	 	 => $this -> app -> get_rekening(),
				'page_title' => 'Rekening Saya',
				'backto'     => site_url('akun'),   
			];
	
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/rekening');
			$this -> load -> view('layout/footer');

		}
	}

	public function pesanan() {
		$title = isset($_GET) && $_GET['produk'] == 'fisik' ? 'Pesanan saya' : 'Produk Digital';
		
		if(isset($_GET['detail'])) {
			$data = $this -> app -> get_detail_transaksi($_GET['detail']);
			$conf = [
				'title'  	 => 'Detail Pesanan | ' . app('app_name'),
				'page_title' => 'Detail Pesanan',
				'data' 		 => $data,
			];
			
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/pesanan/detail');
			$this -> load -> view('layout/footer');
			
		} else if(isset($_GET['ulasan'])) {
			$data = $this -> app -> get_detail_transaksi($_GET['ulasan']);
			$conf = [
				'title'  	 => 'Ulasan Produk | ' . app('app_name'),
				'page_title' => 'Ulasan Produk',
				'data' 		 => $data,
			];
			
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/pesanan/ulasan');
			$this -> load -> view('layout/footer');
			
		} else {
			$conf  = [
				'title'  	 => $title . ' | ' . app('app_name'),
				'form_title' => $title,
				'backto'	 => site_url('akun'),
				'page_title' => $title,
			];
	
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/pesanan/main');
			$this -> load -> view('layout/footer');
		}
	}

	public function saldo() {
		$conf  = [
			'title'  	 => 'Riwayat Saldo | ' . app('app_name'),
			'form_title' => 'Riwayat Saldo',
			'backto'	 => site_url('akun'),
			'page_title' => 'Riwayat Saldo',
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('akun/saldo/main');
		$this -> load -> view('layout/footer');
	}

}

// Controller Akun
// Kode ini dibuat oleh codelingker