<div class="page keranjang bayar">
    <section class="title">
        <h2>Pembayaran</h2>
    </section> 
    
    <?php if(isset($data['Fisik'])) : ?>
        <section class="section sec-addr">
            <div class="container">
                <h6 class="mb-3">
                    <strong>Alamat Pengiriman</strong>
                </h6>

                <p class="mb-1">
                    <?= $alamat -> penerima ?>
                </p>
                <p class="mb-1">
                    <?= $alamat -> alamat ?>
                </p>
                <p class="mb-1">
                    <?= $alamat -> kel ?>,
                    Kec. <?= $this -> app -> get_kec('semua', $alamat -> kec, 'nama') ?>
                </p>
                <p class="mb-1">
                    <?= $this -> app -> get_kab('semua', $alamat -> kab, 'nama') ?>, 
                    <?= $this -> app -> get_prov($alamat -> prov, 'nama') ?>
                </p>
                <p>
                    <?= $alamat -> nohp ?>
                </p>

                <button class="btn btn-sm btn-light border px-4 mt-2 change_addr">
                    Ubah Alamat
                </button>
            </div>
        </section>
    <?php endif ?>

    <section class="section cart-prd">
        <div class="mb-4 pb-1 container">
            <h6>
                <strong>Detail Belanjaan</strong>
            </h6>
        </div>
        <div class="container cart-prd-list">
            <?php if(isset($data['Digital'])) : ?>
                <?php foreach($data['Digital'] as $item) : ?>
                    <article class="card">
                        <div class="container d-flex justify-content-between align-items-start pt-4">
                            <div class="img">
                                <img src="<?= $this -> app -> get_img_produk($item -> id_produk) ?>" >
                            </div>
                            <div class="text">
                                <div class="d-flex justify-content-between align-items-start">
                                    <p class="truncate-2 mb-1">
                                        <?= $item -> nama_produk ?>
                                    </p>
                                </div>
                                <p class="text-danger mb-2">
                                    <strong><?= format_uang($item -> harga) ?></strong>
                                </p>
                                <?php if($item -> nama_varian) : ?>
                                    <div class="d-flex align-items-center mt-1">
                                        <span class="badge text-dark border me-1 bg-light btn_change_varian">
                                            <?= $item -> nama_varian ?> 
                                        </span>
                                    </div>
                                <?php endif ?>
                            
                                <?php if($item -> catatan) : ?>
                                    <div class="mt-2 text-truncate">
                                        <small class="text-muted">
                                            Catatan: <?= $item -> catatan ?>
                                        </small>
                                    </div>
                                <?php endif ?>
                            </div>
                        </div>
                    </article>  
                <?php endforeach ?>                                     
            <?php endif ?>   

            <?php if(isset($data['Fisik'])) : ?>
                <?php foreach($data['Fisik'] as $item) : ?>
                    <article class="card">
                        <div class="container d-flex justify-content-between align-items-start pt-4">
                            <div class="img">
                                <img src="<?= $this -> app -> get_img_produk($item -> id_produk) ?>" >
                            </div>
                            <div class="text">
                                <p class="truncate-2 mb-1">
                                    <?= $item -> nama_produk ?>
                                </p>
                                <p class="text-danger mb-2">
                                    <strong><?= format_uang($item -> harga) ?></strong>
                                </p>
                                <?php if($item -> nama_varian) : ?>
                                    <div class="d-flex align-items-center mt-1">
                                        <span class="badge text-dark border me-1 bg-light btn_change_varian" 
                                                data-trx="<?= $item -> id ?>"
                                                data-id="<?= $item -> id_produk ?>"
                                                data-varian="<?= $item -> varian ?>"
                                                data-sub="<?= $item -> varian_sub ?>"
                                        >
                                            <?= $item -> nama_varian ?> 
                                            <i class="fa fa-chevron-down ms-1"></i>
                                        </span>
                                    </div>
                                <?php endif ?>
                                <div class="mt-2 text-truncate">
                                    <small class="text-muted">
                                        Catatan: Lorem ipsum, dolor sit amet consectetur adipisicing elit. Sed, ad.
                                    </small>
                                </div>
                            </div>
                        </div>
                    </article>  
                <?php endforeach ?>                                     
            <?php endif ?>
        </div>
    </section>

    <section class="section diskon">
        <div class="container">
            <h6 class="mb-3">
                <strong>Voucher</strong>
            </h6>
            <div class="row">
                <div class="col-sm-4">
                    <div class="input-group">
                        <input type="text" class="form-control bg-light" placeholder="Masukan Kode Voucher">
                        <button class="btn btn-light border px-3">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                    <!-- <div class="alert alert-light dashed mt-3">
                        <p class="mb-1 text-danger">
                            <strong>Gratis Ongkir</strong>
                        </p>
                        <p class="mb-0">
                            Voucher gratis ongkir sebesar Rp30.000 telah digunakan
                        </p>
                        <span class="icon fa fa-percent"></span>
                    </div> -->
                </div>
            </div>
        </div>
    </section>
    
    <?php if(isset($data['Fisik'])) : ?>
        <section class="section kurir cursor-pointer">
            <div class="container">
                <h6 class="mb-3">
                    <strong>Opsi Pengiriman</strong>
                </h6>
                <p class="text-primary mb-0">
                    Belum dipilih
                </p>
            </div>
        </section>
    <?php endif ?>

    <section class="section pembayaran cursor-pointer">
        <div class="container">
            <h6 class="mb-3">
                <strong>Metode Pembayaran</strong>
            </h6>
            <p class="text-primary mb-0">
                Belum dipilih
            </p>
        </div>
    </section>

    <section class="section rincian_bayar">
        <div class="container">
            <h6 class="mb-3">
                <strong>Rincian Pembayaran</strong>
            </h6>
            <ul class="list-group list-group-flush">
                <li class="list-group-item">
                    <span class="float-start">Total Belanja</span>
                    <strong class="float-end">
                        <?= format_uang($this -> app -> total_keranjang()) ?>
                    </strong>
                    <input type="hidden" id="subtotal_inp" value="250000">
                </li>
                <li class="list-group-item">
                    <span class="float-start">Diskon</span>
                    <strong class="float-end biaya_diskon_text">-Rp0</strong>
                </li>
                <?php if(isset($data['Fisik'])) : ?>
                    <li class="list-group-item">
                        <span class="float-start">Biaya pengiriman</span>
                        <strong class="float-end biaya_kirim_text">Rp0</strong>
                    </li>
                <?php endif ?>
                <li class="list-group-item">
                    <span class="float-start">Biaya penanganan</span>
                    <strong class="float-end biaya_admin_text">Rp0</strong>
                </li>
                <li class="list-group-item text-danger">
                    <strong class="float-start">Total Tagihan</strong>
                    <strong class="float-end total_tagihan_text">
                        <?= format_uang($this -> app -> total_keranjang()) ?>
                    </strong>
                </li>
            </ul>
        </div>
    </section>

    <form method="post">
        <input type="hidden" name="voucher" id="voucher" value="">
        <input type="hidden" name="kurir" id="kurir" value="">
        <input type="hidden" name="pembayaran" id="pembayaran" value="">
        <input type="hidden" name="alamat" id="alamat" value="">
        <input type="hidden" name="ongkir" id="ongkir" value="0">
        <input type="hidden" name="admin_bayar" id="admin_bayar" value="0">
        <input type="hidden" name="diskon" id="diskon" value="0">
        <input type="hidden" name="total" id="total" value="<?= $this -> app -> total_keranjang() ?>">
    </form>

    <section class="mt-4 bayar-btn">
        <div class="container text-center">
            <button class="btn btn-primary px-5 buat_pesanan">
                Buat Pesanan
            </button>
            <button class="btn btn-light px-4" onclick="window.location.href='<?= site_url('keranjang') ?>'">
                Batal
            </button>
        </div>
    </section>
</div>

<div class="modal fade" id="modal_bayar">
    <div class="modal-dialog modal-fullscreen-sm-down modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <div class="_title d-flex align-items-center">
                    <a href="" data-bs-dismiss="modal" class="close">
                        <i class="fa fa-times"></i>
                    </a>
                    <h2></h2>
                </div>
            </div>
            <div class="modal-body p-0"></div>
            <div class="modal-footer d-none"></div>
        </div>
    </div>
</div>

<script>
    function modal_footer_addr() {
        return `
            <button class="btn btn-primary btn-lg w-100" onclick="redirect('akun/alamat/form?aksi=tambah&redirect=pembayaran')">
                <i class="fa fa-plus me-1"></i>
                Tambah Alamat
            </button>
        `;
    }
    
    function pilih_add(id) {
        $.post({
            url: base_url + 'proses/pilih_addr',
            data: {id:id},
            dataType: 'json',
            success: json => {
                if(json.status == 1) {
                    location.reload();
                }
            }
        })
    }

    $('.buat_pesanan').on('click', function() {
        let form = $('form').serialize();
        $.post({
            url: base_url + 'proses/buat_pesanan',
            data: form,
            success: json => {
                print_r(json);
            }
        })
    })

    $(document).on('click', '.change_addr', function() {
        $('#modal_bayar').modal('show').find('.modal-body').html(loader);
        $('#modal_bayar .modal-header h2').text('Alamat Saya');

        $.post({
            url: base_url + 'proses/modal_bayar',
            data: {modal: 'addr'},
            dataType: 'html',
            success: function(data) {
                $('#modal_bayar .modal-body').html(data);
                $('#modal_bayar .modal-footer').removeClass('d-none').html(modal_footer_addr);
            }
        })
    });

    $(document).on('click', '.pembayaran', function() {
        $('#modal_bayar').modal('show').find('.modal-body').html(loader);
        $('#modal_bayar .modal-header h2').text('Metode Pembayaran');
        $('#modal_bayar .modal-footer').addClass('d-none').html('');

        $.post({
            url: base_url + 'proses/modal_bayar',
            data: {modal: 'bayar'},
            dataType: 'html',
            success: function(data) {
                $('#modal_bayar .modal-body').html(data);
            }
        })
    })

    $(document).on('click', '.kurir', function() {
        $('#modal_bayar').modal('show').find('.modal-body').html(loader);
        $('#modal_bayar .modal-header h2').text('Opsi Pengiriman');
        $('#modal_bayar .modal-footer').addClass('d-none').html('');

        $.post({
            url: base_url + 'proses/modal_bayar',
            data: {modal: 'kurir'},
            dataType: 'html',
            success: function(data) {
                $('#modal_bayar .modal-body').html(data);
            }
        })
    })

    $(document).on('click', '.btn_pilih_kurir', function() {
        let id     = $(this).data('id');
        let biaya  = $(this).data('biaya');
        let nama   = $(this).data('nama');
        let total  = $('#total').val();
        let diskon = $('#diskon').val();
        let admin  = $('#admin_bayar').val();
        let hitung = Number(total) + Number(biaya) + Number(admin) - Number(diskon);
        
        $('.kurir p').text(nama);
        $('#kurir').val(id);
        $('#ongkir').val(biaya);
        $('.biaya_kirim_text').text('Rp' + nf(String(biaya)));
        $('.total_tagihan_text').text('Rp' + nf(String(hitung)));
        $('.modal').modal('hide');
    })

    $(document).on('click', '.btn_pilih_payment:not(.disable)', function() {
        let id     = $(this).data('id');
        let biaya  = $(this).data('biaya');
        let nama   = $(this).data('nama');
        let total  = $('#total').val();
        let diskon = $('#diskon').val();
        let ongkir = $('#ongkir').val();
        let hitung = Number(total) + Number(biaya) + Number(ongkir) - Number(diskon);
        
        $('.pembayaran p').text(nama);
        $('#pembayaran').val(id);
        $('#admin_bayar').val(biaya);
        $('.biaya_admin_text').text('Rp' + nf(String(biaya)));
        $('.total_tagihan_text').text('Rp' + nf(String(hitung)));
        $('.modal').modal('hide');
    })
</script>