<?php 
    $produk = $this -> app -> get_produk(['id' => $id]);
    $getvar = $this -> app -> get_detail_varian($varian, $sub);
    $diskon = count($produk -> varian) == 0 ? $produk -> diskon : $getvar -> diskon;
    $harga  = count($produk -> varian) == 0 ? $produk -> harga : $getvar -> harga;
    $stok   = count($produk -> varian) == 0 ? $getvar -> stok : $produk -> stok;
?>

<div class="modal-header">
    <div class="_title d-flex align-items-center">
        <a href="" data-bs-dismiss="modal" class="close">
            <i class="fa fa-times"></i>
        </a>
        <h2>Varian Produk</h2>
    </div>
</div>
<div class="modal-body">
    <div class="prd-card-detail d-flex justify-content-between ">
        <div class="_img">
            <img src="<?= $this -> app -> get_img_produk($produk -> id)  ?>" alt="img">
        </div>
        <div class="_text">
            <p class="truncate-2 mb-1">
                <?= $produk -> nama ?>
            </p>
            <div class="harga-prd d-flex align-items-center">
                <?php if($diskon > 0) : ?>                    
                    <p class="_normal">
                        <?= format_uang($harga - $diskon) ?>
                    </p>
                    <p class="_coret">
                        <?= format_uang($harga) ?>
                    </p>

                <?php else: ?>
                    <p class="_normal">
                        <?= format_uang($harga) ?>
                    </p>
                <?php endif ?>
                
            </div>
            <p class="mt-2 mb-0 stok-prd">
                Stok: <strong><?= $stok ?></strong>
            </p>                            
        </div>
    </div>

    <?php if(count($produk -> varian) > 0) :  ?>
        <div class="varian-prd mt-3">
            <p class="mb-2">
                 <?= $produk -> jenis == 'Fisik' ? 'Pilih Varian' : 'Pilih Paket' ?>
            </p>
            <div class="d-flex align-items-start flex-wrap">
                <?php foreach($produk -> varian as $var) :  ?>
                    <?php $select = $varian == $var -> id_varian && $sub == $var -> is_sub ? 'checked' : ''  ?>
                    <div class="mb-2">
                        <input type="radio" 
                            name="varian" 
                            id="var_<?= $var -> id_varian . '_' . $var -> is_sub ?>" 
                            class="varian_prd"
                            data-trx="<?= $trx ?>"
                            data-produk="<?= $produk -> id ?>"
                            data-id="<?= $var -> id_varian ?>"
                            data-sub="<?= $var -> is_sub ?>"
                            data-harga="<?= $var -> harga ?>"
                            data-stok="<?= $var -> stok ?>"
                            data-min="<?= $produk -> min_order ?>"
                            data-diskon="<?= $var -> diskon ?>"
                            <?= $select ?>
                        >
                        <label for="var_<?= $var -> id_varian . '_' . $var -> is_sub ?>">
                            <?= $var -> nama_varian ?>
                        </label>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    <?php endif ?>

</div>
<div class="modal-footer simpan-varian">
    <button class="btn btn-primary px-4">
        Simpan
    </button>
</div>