<div class="page ubah">
    <div class="title">
        <h2>Akun Saya</h2>
    </div>
    <div class="card">
        <div class="container py-4">
            <form method="POST" class="row">
                <div class="col-sm-12 mb-3">
                    <label class="form-label">Nama Lengkap</label>
                    <input type="text" class="form-control" value="<?= user('nama') ?>" name="nama">
                </div>
                <div class="col-sm-6 mb-3">
                    <label class="form-label">No Hp</label>
                    <input type="text" class="form-control" value="<?= user('nohp') ?>" name="nohp">
                </div>
                <div class="col-sm-6 mb-3">
                    <label class="form-label">Email</label>
                    <input type="text" class="form-control" value="<?= user('email') ?>" name="email">
                </div>
                <div class="col-sm-12 mb-3">
                    <label class="form-label">Password</label>
                    <div class="input-group">
                        <input type="text" class="form-control pass" readonly name="password">
                        <button class="btn btn-light border btn_edit">
                            <i class="fa fa-edit"></i>
                        </button>
                    </div>
                </div>
                <div class="col-sm-6 mb-3 mt-4">
                    <button class="btn btn-lg btn-primary px-4 btn-full-mob mb-2">
                        Simpan
                    </button>
                    <a href="<?= site_url('akun') ?>" class="btn btn-lg btn-light px-4 btn-full-mob mb-2">
                        Kembali
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $('.btn_edit').on('click', function() {
        if($(this).hasClass('tampilkan')) {
            $(this).removeClass('tampilkan');
            $('.pass').prop('readonly', true).val('');
        } else {
            $(this).addClass('tampilkan');
            $('.pass').prop('readonly', false).val('');
        }
    });

    $('form').on('submit', function(e) {
        e.preventDefault();
        let form = $(this).serialize;

        $.post({
            url: base_url + 'proses/ubah_akun',
            data: form,
            dataType: 'json',
            success: function(json) {
                if(json.status == 1) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil',
                        html: 'Akun anda sudah diupdate',
                        confirmButtonText:'Hapus',
                        buttonsStyling: false,
                        customClass: {
                            confirmButton: 'btn btn-primary me-3',
                        }
                    }).then(res => {
                        if(res.isConfirmed) {
                            location.reload();
                        }
                    })
                }
            }
        })
    })
</script>