<div class="akun">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-12">
                <div class="card info">
                    <div class="card-header pt-4 pb-5 d-flex justify-content-between align-items-center">
                        <div class="img">
                            <span><?= $this -> app -> get_init(user('nama')) ?></span>
                        </div>
                        <div class="text">
                            <h6 class="mb-1">
                                <strong>
                                    <?= user('nama') ?>
                                </strong>
                            </h6>
                            <small>
                                <?= user('email') ?>
                            </small>
                            <div class="mt-1">
                                <?php if(user('level') == 2) : ?>
                                    <span class="user-level gold">
                                        Premium
                                    </span>
                                <?php else: ?>
                                    <span class="user-level bronze">
                                        Reguler
                                    </span>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="saldo d-flex justify-content-between align-items-center">
                            <div>
                                <p class="mb-1">
                                    Saldo saat ini
                                </p>
                                <h5 class="mb-0">
                                    <strong><?= $this -> app -> get_saldo(user('id'), 'format') ?></strong>
                                </h5>
                            </div>
                            <div class="text-center topup d-flex">
                                <div class="me-2">
                                    <button class="fa fa-receipt"></button>
                                    <small class="d-block">Riwayat</small>
                                </div>
                                <div>
                                    <button class="fa fa-plus"></button>
                                    <small class="d-block">Top Up</small>
                                </div>
                            </div>
                        </div>

                        <div class="menu">
                            <h6><strong>Main Menu</strong></h6>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item" onclick="redirect('akun/ubah')">
                                    <span class="float-start">
                                        <i class="fa fa-user me-2"></i>
                                        Akun saya
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item">
                                    <span class="float-start">
                                        <i class="fa fa-shopping-basket me-2"></i>
                                        Pesanan saya
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item">
                                    <span class="float-start">
                                        <i class="fa fa-window-maximize me-2"></i>
                                        Produk Digital
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/alamat')">
                                    <span class="float-start">
                                        <i class="fa fa-map-marker-alt me-2"></i>
                                        Alamat Saya
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/rekening')">
                                    <span class="float-start">
                                        <i class="fa fa-credit-card me-2"></i>
                                        Rekening Saya
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item" onclick="redirect('akun/favorit')">
                                    <span class="float-start">
                                        <i class="fa fa-heart me-2"></i>
                                        Favorit
                                    </span>
                                    <span class="float-end">
                                        <i class="fa fa-chevron-right"></i>
                                    </span>
                                </li>
                                <li class="list-group-item text-danger border-bottom logout">
                                    <span class="float-start">
                                        <i class="fa fa-sign-out me-2"></i>
                                        Keluar
                                    </span>
                                </li>
                            </ul>
                            <div class="text-center appV">
                                <small>versi 1.0</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $('.logout').on('click', function() {
        Swal.fire({
            icon: 'question',
            title: 'Apakah anda yakin',
            html: 'Anda akan keluar dari akun ini',
            showCancelButton: true,
            confirmButtonText:'Keluar',
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger me-3',
                cancelButton: 'btn btn-light',
            }
        }).then(res => {
            if(res.isConfirmed) {
                window.location.href = base_url + 'auth/logout'
            }
        })
    })
</script>