<?php 
    $id       = isset($data) ? $data -> id : 0 ;
    $penerima = isset($data) ? $data -> penerima : null ;
    $nohp     = isset($data) ? $data -> nohp : null ;
    $kel      = isset($data) ? $data -> kel : null ;
    $alamat   = isset($data) ? $data -> alamat : null ;
    $idprov   = isset($data) ? $data -> prov : null ;
    $idkab    = isset($data) ? $data -> kab : null ;
    $idkec    = isset($data) ? $data -> kec : null ;
    $ck_home  = isset($data) && $data -> judul == 'Rumah' ? 'checked' : 'checked' ;
    $ck_ofis    = isset($data) && $data -> judul == 'Kantor' ? 'checked' : null ;
    $ck_primary = isset($data) && $data -> utama == 1 ? 'checked' : null ;
?>

<div class="page alamat">
    <div class="title">
        <h2><?= $form_title ?></h2>
    </div>
    <div>
        <div class="card">
            <div class="container pt-4 pb-5">
                <form method="POST" class="row">
                    <input type="hidden" name="id" value="<?= $id ?>">
                    <input type="hidden" class="url" value="<?= isset($_GET['redirect']) ? $_GET['redirect'] : 'akun/alamat' ?>">
                    <div class="col-sm-6 mb-3">
                        <label class="form-label">Nama Penerima <span class="text-danger">*</span> </label>
                        <input type="text" placeholder="" class="form-control" name="penerima" value="<?= $penerima ?>">
                    </div>
                    <div class="col-sm-6 mb-3">
                        <label class="form-label">No Handphone <span class="text-danger">*</span></label>
                        <input type="number" placeholder="" class="form-control nochange" name="nohp" value="<?= $nohp ?>">
                    </div>
                    <div class="col-sm-4 mb-3">
                        <label class="form-label">Provinsi <span class="text-danger">*</span></label>
                        <select class="form-select select2" name="prov">
                            <option value="" selected disabled>Pilih Provinsi</option>
                            <?php foreach($data_prov as $prov) : ?>
                                <?php $selected = $idprov == $prov -> id ? 'selected' : null  ?>
                                <option value="<?= $prov -> id ?>" <?= $selected ?>>
                                    <?= $prov -> nama ?>
                                </option>
                            <?php endforeach ?>
                        </select>
                    </div>

                    <?php 
                        if(isset($data)) {
                            $prov      = $data -> prov;
                            $data_kab = $this -> app -> get_kab($prov);
                            $html      = '
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Kabupaten <span class="text-danger">*</span></label>
                                        <select class="form-select select2" name="kab">
                            ';
                    
                            foreach($data_kab as $item) {
                                $selected = $idkab == $item -> id ? 'selected' : null;
                                $html    .= '
                                    <option value="'.$item -> id.'" '.$selected.'>
                                        '.$item -> tipe.' '.$item -> nama.'
                                    </option>
                                ';
                            }
                            
                            $html .= '
                                    </select>
                                </div>
                            ';

                            echo $html;
                        } else {
                            echo '
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Kabupaten <span class="text-danger">*</span></label>
                                    <select class="form-select select2" name="kab" disabled ></select>
                                </div>
                            ';
                        }
                    ?>

                    <?php 
                        if(isset($data)) {
                            $kab  = $data -> kab;
                            $data_kec = $this -> app -> get_kec($kab);
                            $html = '
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Kabupaten <span class="text-danger">*</span></label>
                                        <select class="form-select select2" name="kec">
                            ';
                    
                            foreach($data_kec as $item) {
                                $selected = $idkec == $item -> id ? 'selected' : null;
                                $html .= '
                                    <option value="'.$item -> id.'" '.$selected.'>
                                        '.$item -> nama.'
                                    </option>
                                ';
                            }
                            
                            $html .= '
                                    </select>
                                </div>
                            ';

                            echo $html;
                        } else {
                            echo '
                                <div class="col-sm-4 mb-3">
                                    <label class="form-label">Kecamatan <span class="text-danger">*</span></label>
                                    <select class="form-select select2" name="kec" disabled ></select>
                                </div>
                            ';
                        }
                    ?>
                    
                    <div class="col-sm-12 mb-3">
                        <label class="form-label">Desa / Kelurahan</label>
                        <input class="form-control" name="kel" value="<?= $kel ?>">
                    </div>
                    <div class="col-sm-12 mb-3">
                        <label class="form-label">Alamat Lengkap <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="alamat"><?= $alamat ?></textarea>
                    </div>
                    <div class="col-sm-12 varian-prd mb-3">
                        <p class="form-label">Tandai sebagai <span class="text-danger">*</span></p>
                        <div class="d-flex align-items-start flex-wrap">
                            <div class="mb-2">
                                <input type="radio" 
                                    name="judul" 
                                    id="rumah" 
                                    class="varian_prd"
                                    value="Rumah"
                                    <?= $ck_home ?>
                                >
                                <label for="rumah">
                                    Rumah
                                </label>
                            </div>
                            <div class="mb-2">
                                <input type="radio" 
                                    name="judul" 
                                    id="kantor" 
                                    class="varian_prd"
                                    value="Kantor"
                                    <?= $ck_ofis ?>
                                >
                                <label for="kantor">
                                    Kantor
                                </label>
                            </div>
                        </div>
                    </div>
                    <?php if($primary && !isset($_GET['redirect'])) : ?>
                        <div class="col-sm-12 mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="utama" id="is_primary" <?= $ck_primary ?>>
                                <label class="form-check-label" for="is_primary">
                                    Simpan sebagai alamat utama
                                </label>
                            </div>
                        </div>
                    <?php else: ?>
                        <input type="hidden" name="utama" value="1">
                    <?php endif ?>

                    <div class="col-sm-12 mt-3">
                        <button class="btn btn-primary px-4 btn-full-mob mb-2">
                            Simpan
                        </button>
                        <a href="<?= isset($_GET['redirect']) ? site_url($_GET['redirect']) : site_url('akun/alamat') ?>" class="btn btn-light btn-full-mob">
                            Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).on('change', '[name="prov"]', function() {
        let id = this.value;
        get_distrik('proses/get_kab', id);
        $('[name="kec"]').attr('disabled', true).html('');
    })
    $(document).on('change', '[name="kab"]', function() {
        let id = this.value;
        get_distrik('proses/get_kec', id);
    })
    $(document).on('change', '[name="kec"]', function() {
        get_distrik('proses/get_kel')
    })

    function get_distrik(slug, id) {
        let field;

        if(slug == 'proses/get_kec') {
            field = {kab:id}

        } else if(slug == 'proses/get_kab') {
            field = {prov:id}
        }
        
        if(slug == 'proses/get_kel') {
            $('[name="kel"]').attr('disabled', false);

        } else {
            $.post({
                url: base_url + slug,
                dataType: 'html',
                data: field,
                success: data => {
                    if(slug == 'proses/get_kec') {
                        $('[name="kec"]').attr('disabled', false).html(data);
                        
                    } else if(slug == 'proses/get_kab') {
                        $('[name="kab"]').attr('disabled', false).html(data);
                    }
                }
            })
        }
    }

    $('form').on('submit', function(e) {
        e.preventDefault();
        let form   = $('form').serialize();
        let url    = $('.url').val(); 

        confirm_submit.fire({
            text: 'Alamat baru akan disimpan, pastikan sudah diisi dengan benar'
        }).then(rest => {
            if(rest.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_addr',
                    data: form,
                    dataType: 'json',
                    success: json => {
                        if(json.status == 1) {
                            confirm_success.fire({
                                html: json.msg,
                            }).then(res => {
                                redirect(url);
                            })
                        }
                    }
                })
            }
        })
    })
</script>