<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Payment_model extends CI_Model {
    private function channel($grup = true) {
        $url      = 'https://tripay.co.id/api-sandbox/merchant/payment-channel';
        $response = $this -> get($url);
        $data     = [];   
        $rows     = [];
        
        if($response AND $response -> success == 1) {
            foreach($response -> data as $item) {
                $fee    = $item -> group == 'Virtual Account' || $item -> group == 'Convenience Store' ? $item -> fee_customer -> flat : $item -> fee_customer -> percent / 100; 
                $fee_type =  $item -> group == 'Virtual Account' || $item -> group == 'Convenience Store' ? 'flat' : 'percent' ; 
                $item -> group = $item -> group  == 'Convenience Store' ? 'Gerai Retail' : $item -> group;

                $data[$item -> group . ' (Verifikasi otomatis)'][] = (object) [
                    'code'     => $item -> code,
                    'group'    => $item -> group,
                    'gateway'  => 'Tripay',
                    'verify'   => 'Otomatis',
                    'name'     => $item -> name,
                    'saldo'    => 0,
                    'fee'      => $fee,
                    'fee_type' => $fee_type,
                    'icon'     => $item -> icon_url,
                    'norek'    => null,
                    'atasnama' => null
                ];
            }
        }
        
        return (object) $data;
    }
    
    private function get($url) {
        $curl   = curl_init();
        $apiKey = app('tripay_apikey');        
        
        curl_setopt_array($curl, array(
            CURLOPT_FRESH_CONNECT  => true,
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => ['Authorization: Bearer '.$apiKey],
            CURLOPT_FAILONERROR    => false,
            CURLOPT_IPRESOLVE      => CURL_IPRESOLVE_V4
        ));
        
        $response = curl_exec($curl);
        $response = json_decode($response);
        $error    = curl_error($curl);
        
        curl_close($curl);

        return $error ? null : $response;
    }

    private function manual() {
        $get  = $this -> db -> get('bank') -> result();
        $data = [];

        if($get) {
            foreach($get as $item) {
                $data['Transfer Bank (Verifikasi manual)'][] = (object) [
                    'code'     => $item -> kode,
                    'group'    => 'Transfer Bank',
                    'verify'   => 'Manual',
                    'gateway'  => null,
                    'name'     => 'Transfer' . ' ' . $item -> nama,
                    'saldo'    => 0,
                    'fee'      => $item -> fee,
                    'fee_type' => 'flat',
                    'icon'     => base_url('upload/bank/') . $item -> icon,
                    'norek'    => $item -> norek,
                    'atasnama' => $item -> atasnama
                ];
            }
        }

        return $data;
    }

    private function saldo() {
        $sesi = $this -> session -> ci_usrid;
        $get  = $this -> db -> get('saldo', ['usrid' => $sesi]) -> result();
        $data = [];

        if($get) {
            foreach($get as $item) {
                if($item -> saldo > 0) {
                    $data['Saldo'][] = (object) [
                        'code'     => 'CISA',
                        'group'    => 'Saldo',
                        'verify'   => 'Otomatis',
                        'gateway'  => null,
                        'name'     => 'Saldo ' . app('app_name'),
                        'saldo'    => $item -> saldo,
                        'fee'      => 0,
                        'fee_type' => 'flat',
                        'icon'     => base_url('assets/img/dompet.png'),
                        'norek'    => null,
                        'atasnama' => null
                    ];
                }
            }
        }

        return $data;    
    }

    private function cod() {
        $data = [];
        $data['Bayar di kurir'][] = (object) [
            'code'     => 'cod',
            'group'    => 'COD',
            'verify'   => 'Otomatis',
            'gateway'  => null,
            'name'     => 'Bayar ditempat ',
            'saldo'    => 0,
            'fee'      => 0,
            'fee_type' => 'flat',
            'icon'     => base_url('assets/img/cod.png'),
            'norek'    => null,
            'atasnama' => null
        ];

        return $data;
    }

    public function get_payment($filter = 'semua') {
        $usrid  = $this -> session -> ci_usrid;
        $rows   = $this -> db -> get_where('transaksi_detail', ['id_user' => $usrid, 'jenis' => 'Fisik']) -> num_rows();
        $tripay = $this -> channel();
        $manual = $this -> manual();
        $saldo  = $this -> saldo();
        $cod    = $rows > 0 || $filter == 'semua' ? $this -> cod() : [];

        return array_merge((array) $saldo, (array) $cod, (array) $manual, (array) $tripay);
    }

    public function request_transaction($payload) {        
        $payload      = (object) $payload;
        $apiKey       = app('tripay_apikey');
        $privateKey   = app('tripay_privatekey');
        $merchantCode = app('tripay_merchant');
        $merchantRef  = $payload -> trxcode;
        $total        = $payload -> total;
        $endpoint     = 'https://tripay.co.id/api-sandbox/transaction/create';

        $data = [
            'method'         => $payload -> metode,
            'amount'         => $total,
            'merchant_ref'   => $merchantRef,
            'customer_name'  => $payload -> nama,
            'customer_email' => $payload -> email,
            'customer_phone' => $payload -> nohp,
            'order_items'    => $payload -> cart,
            'expired_time'   => (time() + (24 * 60 * 12)), // 24 jam
            'signature'      => hash_hmac('sha256', $merchantCode.$merchantRef.$total, $privateKey)
        ];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_FRESH_CONNECT  => true,
            CURLOPT_URL            => $endpoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => ['Authorization: Bearer '.$apiKey],
            CURLOPT_FAILONERROR    => false,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => http_build_query($data),
            CURLOPT_IPRESOLVE      => CURL_IPRESOLVE_V4
        ]);
        
        $response = curl_exec($curl);
        $error    = curl_error($curl);        
        curl_close($curl);

        $response = json_decode($response);        
        return empty($error) ? $response : $error;

    }

    public function detail_transaction() {
        $payload = ['reference'	=> 'DEV-T2307099976FAZQJ'];
        $url     = 'https://tripay.co.id/api-sandbox/transaction/detail?'.http_build_query($payload);
        $get     = $this -> get($url);

        return $get -> data;
    }
}

// Payment model
// Kode ini dibuat oleh codelingker