<?php 

class App_model extends CI_Model {
    public function kurir() {
        $get  = $this -> db -> get_where('kurir', ['status' => 1]) -> result();
        $data = [];

        foreach($get as $item) {
            $item -> logo = base_url('upload/ekspedisi/'. $item -> code . '.png');
            $data[] = $item;
        }

        return $data;
    }

    public function get_app($name = 'semua') {        
        if($name == 'semua') {
            $get  = $this -> db -> get('app') -> result();
            $data = [];

            foreach($get as $item) {
                $data[$item -> name] = $item -> value;
            }

            return $data;

        } else {
            $get  = $this -> db -> get_where('app', ['name' => $name]) -> row();
            return $get ? $get -> value : null;
        }
    }

    private function set_produk($obj) { 
        if($obj -> id == 'semua') {
            if(is_int($obj -> limit)) {
                $this -> db -> limit($obj -> limit, $obj -> index);
            }
            if($obj -> random) {
                $this -> db -> order_by('RAND()');
            }
            
            if($obj -> kategori) {
                $this -> db -> where('kategori', $kategori);
            }

            if($obj -> search) {
                $this -> db -> like('nama', $obj -> search);
            }

            $this -> db -> order_by('id', $obj -> ordering);
            $data = $this -> db -> get('produk') -> result();
            $new  = [];

            foreach($data as $item) {
                $varian   = $this -> get_varian($item -> id);
                $kategori = $this -> get_kategori($item -> kategori, 'nama');

                $min  = $varian ? min(array_column($varian, 'harga')) : $item -> harga;
                $max  = $varian ? max(array_column($varian, 'harga')) : $item -> harga;

                $item -> range_min = $varian ? $min : $item -> harga;
                $item -> range_v2  = $varian ? 
                        short_uang($min) .' ~ '.  short_uang($max) : 
                        short_uang($item -> harga);
                $item -> range_v1  = $varian ? 
                        format_uang($min) .' ~ '. format_uang($max) : 
                        format_uang($item -> harga);
                $item -> range_v2  = $varian ? 
                        short_uang($min) .' ~ '.  short_uang($max) : 
                        short_uang($item -> harga);

                $item -> nama_kategori = $kategori ? $kategori : null;
                $item -> diskon_label  = $item -> diskon > 0 ? diskon_produk($item -> harga, $item -> diskon) : null;
                $item -> varian = $varian;

                $new[] = $item;
            }

            return $new;

        } else {
            $get      = $this -> db -> get_where('produk', ['id' => $obj -> id]) -> row();
            $varian   = $this -> get_varian($get -> id);
            $kategori = $this -> get_kategori($get -> kategori, 'nama');

            $min = $varian ? min(array_column($varian, 'harga')) : $get -> harga;
            $max = $varian ? max(array_column($varian, 'harga')) : $get -> harga;
            
            $get -> range_v1  = $varian ? 
                    format_uang($min) .' ~ '. format_uang($max) : 
                    format_uang($get -> harga);
            $get -> range_v2  = $varian ? 
                    short_uang($min) .' ~ '.  short_uang($max) : 
                    short_uang($get -> harga);

            $get -> nama_kategori = $kategori ? $kategori : null;
            $get -> diskon_label  = $get -> diskon > 0 ? diskon_produk($get -> harga, $get -> diskon) : null;
            $get -> varian        = $varian;

            return $get ? $get : null;
        }
    }

    public function get_produk($array = []) {
        $object = (object) [
            'id'       => isset($array['id']) ? $array['id'] : 'semua',
            'limit'    => isset($array['limit']) ? $array['limit'] : 'semua',
            'index'    => isset($array['index']) ? $array['index'] : 0,
            'random'   => isset($array['random']) ? $array['random'] : '',
            'kategori' => isset($array['kategori']) ? $array['kategori'] : '',
            'search'   => isset($array['search']) ? $array['search'] : '',
            'ordering' => isset($array['ordering']) ? $array['ordering'] : 'DESC'
        ];

        return $this -> set_produk($object);
    }

    public function get_varian($id = '') { 
        $data   = $this -> db -> get_where('varian', ['id_produk' => $id]) -> result();
        $new    = [];
        foreach($data as $item) {
            $sub = $this -> get_varian_sub($item -> id);
            if($sub) {  
                foreach($sub as $var) {
                    $new[] = (object) [
                        'id_varian'    => $var -> id,
                        'is_sub'       => 1,
                        'nama_varian'  => $item -> nama . ' ('. $var -> nama .')',
                        'stok'         => $var -> stok,
                        'harga'        => $var -> harga,
                        'diskon'       => $var -> diskon,
                    ];
                }             

            } else {
                $new[] = (object) [
                    'id_varian'    => $item -> id,
                    'is_sub'       => 0,
                    'nama_varian'  => $item -> nama,
                    'stok'         => $item -> stok,
                    'harga'        => $item -> harga,
                    'diskon'       => $item -> diskon,
                ];
            }

        }

        return $new;
    }

    public function get_varian_sub($id) {
        return $this -> db -> get_where('varian_sub', ['id_varian' => $id]) -> result();
    }

    public function get_detail_varian($id, $is_sub, $kolom = 'semua') {
        if($is_sub == 0) {
            $varian = $this -> db -> get_where('varian', ['id' => $id]) -> row();
        } else {
            $data = $this -> db -> get_where('varian_sub', ['id' => $id]) -> row();
            $var  = $this -> db -> get_where('varian', ['id' => $data -> id_varian]) -> row();
            $data -> nama = $var -> nama . ' ('.$data -> nama.')';
            $varian = $data;
        }
        
        if($varian) {
            return $kolom == 'semua' ? $varian : $varian -> $kolom;
        }
    }

    public function get_kategori($id = 'semua', $kolom = 'semua') {
        if($id == 'semua') {
            return $this -> db -> get('kategori') -> result();

        } else {
            $get = $this -> db -> get_where('kategori', ['id' => $id]) -> row();

            if($kolom == 'semua') {
                return $get;

            } else {
                return $get ? $get -> $kolom : null;
            }
        }
    }

    public function get_produk_terkait($id = 'semua', $idkat, $limit = 10) { 
        $this -> db -> where('status', 1);       
        $this -> db -> where('kategori', $idkat);
        $this -> db -> where('id != ', $id);
        $get = $this -> db -> get('produk') -> result();
        $new = []; 

        foreach($get as $item) {
            $varian = $this -> get_varian($item -> id);
            $min    = $varian ? min(array_column($varian, 'harga')) : ($item -> harga - $item -> diskon);

            $new[] = (object) [
                'id'    => $item -> id,
                'nama'  => $item -> nama,
                'harga' => $min
            ];
        }

        return $new;
    }

    public function get_kurir($id = 'semua') { 
        $this -> db -> where('status', 1);       
        if($id == 'semua') {
            return $this -> db -> get('kurir') -> result();

        } else {
            $get  = $this -> db -> get_where('kurir', ['id' => $id]) -> row();
            return $get ? $get : null;
        }
    }

    public function get_img_produk($id, $i = 1) { 
        $get = $this -> db -> get_where('produk', ['id' => $id]) -> row();
        if(is_int($i) && $i <= 4) {
            if($i == 1) {
                $img = $get -> img_1;
            } else if($i == 2) {
                $img = $get -> img_2;
            } else if($i == 3) {
                $img = $get -> img_3;
            } else if($i == 4) {
                $img = $get -> img_4;
            }

            return base_url('upload/produk/' . $img); 
        }
    }

    public function searching($search = '') {
        $html = '';
        $data = $this -> get_produk(
            [
                'limit'  => 10,
                'search' => $search
            ]
        );

        if($data) {
            foreach($data as $item) {
                $html .= '
                    <li>
                        <a href="'.slug($item -> id, 'produk').'" class="d-flex justify-content-between align-items-start">
                            <div class="_img">
                                <img src="'.$this -> get_img_produk($item -> id) .'" alt="img">
                            </div>
                            <div class="_text">
                                <p>
                                    '. $item -> nama .'
                                </p>
                            </div>
                        </a>
                    </li> 
                ';
            }

        } else {
            if($search) {
                $html = '
                    <li class="text-center">
                        <span>Produk tidak tersedia</span>
                    </li>
                ';
            } else {
                $html = '
                    <li class="text-center">
                        <span>Belum ada produk</span>
                    </li>
                ';
            }
        }

        return $html;
    }
    
    public function get_transaksi_produk($array = null) {
        if($array) {
            $obj = (object) $array;
            $this -> db -> where('varian', $obj -> varian);
            $this -> db -> where('varian_sub', $obj -> varian_sub);
            $this -> db -> where('id_produk', $obj -> id_produk);
            $this -> db -> where('id_user', $obj -> id_user);
            return $this -> db -> get('transaksi_detail') -> row();
        }
    }

    public function get_keranjang($group = true) {
        $sesi = $this -> session -> ci_usrid;
        $this -> db -> order_by('id', 'DESC');
        $data = $this -> db -> get_where('transaksi_detail', ['id_user' => $sesi, 'id_transaksi' => 0]) -> result();
        $new  = [];

        if($data) {
            foreach($data as $item) {
                $produk = $this -> get_produk(['id' => $item -> id_produk]);
                $varian = $this -> get_detail_varian($item -> varian, $item -> varian_sub, 'nama');
    
                $item -> nama_produk = $produk -> nama;
                $item -> nama_varian = $varian;

                if($group == 'semua') {
                    $new[$item -> jenis][] = $item;
                    
                } else {
                    $new[] = $item;
                }
            }
        }

        return $new;
    }

    public function get_jml_keranjang() {
        $sesi = $this -> session -> ci_usrid;
        $row = $this -> db -> get_where('transaksi_detail', ['id_user' => $sesi, 'id_transaksi' => 0]) -> num_rows();
        return $row;
    }

    public function total_keranjang($jenis = 'semua') {
        $sesi  = $this -> session -> ci_usrid;
        $total = 0;
               
        if($jenis == 'fisik') {
            $row   = $this -> db -> get_where('transaksi_detail', ['id_user' => $sesi, 'id_transaksi' => 0, 'jenis' => 'Fisik']) -> result();

            foreach($row as $item) {
                $total += $item -> jml * $item -> harga;
            }
    
            return $total;

        } else if($jenis == 'digital') {
            $row   = $this -> db -> get_where('transaksi_detail', ['id_user' => $sesi, 'id_transaksi' => 0, 'jenis' => 'Digital']) -> result();

            foreach($row as $item) {
                $total += $item -> jml * $item -> harga;
            }
    
            return $total;

        } else {
            $row   = $this -> db -> get_where('transaksi_detail', ['id_user' => $sesi, 'id_transaksi' => 0]) -> result();
            foreach($row as $item) {
                $total += $item -> jml * $item -> harga;
            }
    
            return $total;
        }
    }

    public function get_user($id, $kolom = 'semua') {        
        $this -> db -> where('id', $id);
        $this -> db -> or_where('email', $id);
        $get = $this -> db -> get('user') -> row();
        
        if($kolom == 'semua') {
            return $get;
        } else {
            return $get ? $get -> $kolom : null;
        }
    }

    public function get_init($str) {        
        $str = str_split($str);
        return $str[0];
    }

    public function get_saldo($id, $format = null) {        
        $get = $this -> db -> get_where('saldo', ['usrid' => $id]) -> row();

        if($format == 'format') {
            return $get ? format_uang($get -> saldo) : 0;
            
        } else {
            return $get ? $get -> saldo : 0;
        }
    }

    public function get_notif() {    
        $id = $this -> session -> ci_usrid;    
        $get = $this -> db -> get_where('notif', ['usrid' => $id]) -> result();
        return $get;
    }

    public function get_favorit($produk = 'semua') {    
        $id = $this -> session -> ci_usrid;    
        if($produk == 'semua') {
            $get = $this -> db -> get_where('favorit', ['usrid' => $id]) -> result();
            $new = [];
            foreach($get as $item) {
                $produk = $this -> get_produk(['id' => $item -> id_produk]);
                $item -> nama_produk = $produk -> nama;
                $new[] = $item;
            }
            return $new;

        } else {
            $get = $this -> db -> get_where('favorit', ['usrid' => $id, 'id_produk' => $produk]) -> row();
            return $get;
        }
    }

    public function get_prov($id = 'semua', $kolom = '') {
        if($id == 'semua') {
            $data = $this -> db -> get('data_prov') -> result();
            return $data;
            
        } else {
            $data = $this -> db -> get_where('data_prov', ['id' => $id]) -> row();

            if($kolom) {
                return $data ? $data -> $kolom : null;

            } else {
                return $data;
            }

        }
    }

    public function get_kab($prov = 'semua', $id = 'semua', $kolom = '') {
        if($prov == 'semua') {
            $data = $this -> db -> get_where('data_kab', ['id' => $id]) -> row();

            if($kolom) {
                return $data ? $data -> $kolom : null;
            } else {
                return $data ? $data : null;
            }

        } else {
            $data = $this -> db -> get_where('data_kab', ['prov' => $prov]) -> result();
            return $data;
        }
    }

    public function get_kec($kab = 'semua', $id = 'semua', $kolom = '') {
        if($kab == 'semua') {
            $data = $this -> db -> get_where('data_kec', ['id' => $id]) -> row();

            if($kolom) {
                return $data ? $data -> $kolom : null;
            } else {
                return $data ? $data : null;
            }

        } else {
            $data = $this -> db -> get_where('data_kec', ['kab' => $kab]) -> result();
            return $data;
        }
    }

    public function get_kel($kec, $id = 'semua') {
        $data = $this -> db -> get_where('data_kel', ['kec' => $kec]) -> result();
        return $data;
    }

    public function get_alamat($id = 'semua') {
        $sesi = $this -> session -> ci_usrid;
        if($id == 'semua') {
            $this -> db -> order_by('id ASC, utama DESC');
            $data = $this -> db -> get_where('alamat', ['usrid' => $sesi]) -> result();
            return $data;
            
        } else if($id == 'cek_primary') {
            $data = $this -> db -> get_where('alamat', ['usrid' => $sesi, 'utama' => 1]) -> row();
            return $data;

        } else {
            $data = $this -> db -> get_where('alamat', ['id' => $id, 'usrid' => $sesi]) -> row();
            return $data;
        }
    }
}

// Mode APP
// Kode ini dibuat oleh codelingker