<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proses extends CI_Controller {
    public function get_produk() {
        $index    = $_POST['index'];
        $kategori = $_POST['kategori'];
        $limit    = 20;
        $data     = $this -> app -> get_produk([
            'limit'    => $limit, 
            'index'    => $index, 
            'kategori' => $kategori
        ]);

        $this -> load -> view('produk/item', ['get' => $data, 'index' => $index]);
    }

    public function get_keranjang() {
        $data = $this -> app -> get_keranjang();

        $this -> load -> view('keranjang/item', ['data' => $data]);
    }

    public function searching() {
        $value = $_POST['value'];
        $data  = $this -> app -> searching($value);

        echo $data;
    }

    public function addcart() {
		$id = $_POST['id'];
		$this -> load -> view('modal/addcart', ['id' => $id]);
	}

    public function simpan_keranjang() {
        $sesi = $this -> session -> ci_usrid;;

        if($sesi) {
            $id       = $_POST['id'];
            $idvarian = $_POST['varian'];
            $idsubvar = $_POST['subvar'];
            $jml      = $_POST['jml'];
            $produk   = $this -> app -> get_produk(['id' => $id]);
            
            if($idvarian > 0) {
                $varian = $this -> app -> get_detail_varian($idvarian, $idsubvar);
                $harga  = $varian -> harga - $varian -> diskon;
                
            } else {
                $varian = $this -> app -> get_produk(['id' => $id]);
                $harga  = $varian -> harga - $varian -> diskon;
            }

            $simpan   = [
                'id_transaksi'  => 0,
                'id_produk'     => $id,
                'jml'           => $jml,
                'jenis'         => $produk -> jenis,
                'varian'        => $idvarian,
                'varian_sub'    => $idsubvar,
                'harga'         => $harga,
                'id_user'       => $sesi,
            ];
            $where = $simpan;

            unset($where['jml']);
            unset($where['harga']);
            unset($where['jenis']);
            
            $trx = $this -> app -> get_transaksi_produk($where);

            if($trx) {
                $update['jml'] = $produk -> jenis == 'Fisik' ? $trx -> jml + 1 : 1;
                $this -> db -> update('transaksi_detail', $update, $where);
                echo json_encode(['status' => 1, 'msg' => 'Jml '.$produk -> nama.' diupdate']);
                
            } else {
                $this -> db -> insert('transaksi_detail', $simpan);
                echo json_encode(['status' => 1, 'msg' => $produk -> nama. ' ditambahkan ke keranjang']);
            }
            

        } else {
            echo json_encode(['status' => 0, 'Silahkan login']);
        }    
	}

    public function hps_cart() {
        $id = $_POST['id'];
        $this -> db -> delete('transaksi_detail', ['id' => $id]);

        echo json_encode(['status' => 1]);
    }

    public function change_varian() {
        $trx    = $_POST['trx'];
        $id     = $_POST['id'];
        $varian = $_POST['varian'];
        $sub    = $_POST['sub'];

        $conf = [
            'id'     => $id,
            'varian' => $varian,
            'sub'    => $sub,
            'trx'    => $trx,
        ];

        $this -> load -> view('modal/changevarian', $conf);
    }

    public function simpan_varian() {
        $trx    = $_POST['trx'];
        $varian = $_POST['varian'];
        $subvar = $_POST['subvar'];
        $getvar = $this -> app -> get_detail_varian($varian, $subvar);
        $harga  = $getvar -> harga - $getvar -> diskon;

        $update = [
            'varian'     => $varian,
            'varian_sub' => $subvar,
            'harga'      => $harga,
        ];
        $where['id'] = $trx;

        $this -> db -> update('transaksi_detail', $update, $where);
        echo json_encode(['status' => 1]);
            
    }

    public function addket() {
        $trx     = $_POST['trx'];
        $id      = $_POST['id'];
        $varian  = $_POST['varian'];
        $sub     = $_POST['sub'];

        $conf = [
            'trx'    => $trx,
            'id'     => $id,
            'varian' => $varian,
            'sub'    => $sub,
        ];

        $this -> load -> view('modal/addket', $conf);
    }

    public function simpanket() {
        $trx['id']          = $_POST['trx'];
        $value['catatan']   = $_POST['value'];
        $this -> db -> update('transaksi_detail', $value, $trx);

        echo json_encode(['status' => 1]);
    }

    public function modal_bayar() {
        $modal = $_POST['modal'];

        if($modal == 'addr') {
            $data = $this -> app -> get_alamat();
            $this -> load -> view('modal/addr', ['data' => $data]); 
        } else if($modal == 'bayar') {
            $this -> load -> model('Payment_model', 'payment');
            $data = $this -> payment -> get_payment('bayar');
            $this -> load -> view('modal/payment', ['data' => $data]); 
        } else if($modal == 'kurir') {
            $this -> load -> model('Kurir_model', 'kurir');
            $data = $this -> kurir -> cost();
            $this -> load -> view('modal/kurir', ['data' => $data]); 
        }
        
    }

    public function payment() {
       $this -> db -> order_by('id', 'ASC');
       $data = $this -> db -> get('kel') -> result();
       $add = [];
       echo '<pre>';
       foreach($data as $item) {
            $add[] = [
                'id' => $item -> id,
                'kec' => $item -> idkec,
                'nama' => $item -> nama,
            ];

            // $add[] = $item;
        }
        // $this -> db -> insert_batch('data_kel', $add);
        print_r($add);
    }

    public function get_notif() {
        $data = $this -> app -> get_notif();
        $this -> load -> view('notif', ['data' => $data]);
    }

    public function favorit() {
        $id = $this -> session -> ci_usrid;
        if($_POST['status'] == 1) {
            $this -> db -> insert('favorit', ['usrid' => $id, 'id_produk' => $_POST['id']]);
            echo json_encode(
                [
                    'status' => 1,
                    'msg' => 'Produk ditambahkan ke favorit'
                ]
            );
        } else {
            $where = isset($_POST['id_fav']) ? ['id' => $_POST['id_fav']] 
                        : ['usrid' => $id, 'id_produk' => $_POST['id']];
            $this -> db -> delete('favorit', $where);
            echo json_encode(
                [
                    'status' => 1,
                    'msg'    => 'Produk dihapus dari favorit'
                ]
            );
        }
    }

    public function get_kab() {
        $prov = $_POST['prov'];
        $data = $this -> app -> get_kab($prov);
        $html = '<option value="" disabled selected>Pilih kabupaten / kota</option>';

        foreach($data as $item) {
            $html .= '
                <option value="'.$item -> id.'">
                '.$item -> tipe.' '.$item -> nama.'
                </option>
            ';
        }

        echo $html;
    }

    public function get_kec() {
        $kab = $_POST['kab'];
        $data = $this -> app -> get_kec($kab);
        $html = '<option value="" disabled selected>Pilih kecamatan</option>';

        foreach($data as $item) {
            $html .= '
                <option value="'.$item -> id.'">
                    Kecamatan '.$item -> nama.'
                </option>
            ';
        }

        echo $html;
    }

    public function get_kel() {
        $kec = $_POST['kec'];
        $data = $this -> app -> get_kel($kec);
        $html = '';

        foreach($data as $item) {
            $html .= '
                <option value="'.$item -> id.'">
                    '.$item -> nama.'
                </option>
            ';
        }

        echo $html;
    }

    public function submit_addr() {
        $sesi = $this -> session -> ci_usrid;

        if($sesi) {
            if(empty($_POST['penerima'])) {
                echo json_encode(['status' => 0, 'msg' => 'Nama penerima belum diisi']);
    
            } else if(empty($_POST['nohp'])) {
                echo json_encode(['status' => 0, 'msg' => 'No Handphone belum diisi']);
                
            } else if(empty($_POST['prov'])) {
                echo json_encode(['status' => 0, 'msg' => 'Provisi belum dipilih']);
                
            } else if(empty($_POST['kab'])) {
                echo json_encode(['status' => 0, 'msg' => 'Kabupaten belum dipilih']);
                
            } else if(empty($_POST['kec'])) {
                echo json_encode(['status' => 0, 'msg' => 'Kecamatan belum dipilih']);    
    
            } else {
                $data = [
                    'judul'     => isset($_POST['judul']) ? $_POST['judul'] : '',
                    'penerima'  => $_POST['penerima'],
                    'nohp'      => $_POST['nohp'],
                    'alamat'    => $_POST['alamat'],
                    'prov'      => $_POST['prov'],
                    'kab'       => $_POST['kab'],
                    'kec'       => $_POST['kec'],
                    'kel'       => $_POST['kel'],
                    'usrid'     => $sesi
                ];

                if(isset($_POST['utama'])) {
                    $this -> db -> update('alamat', ['usrid' => $sesi, 'utama' => 0]);
                    $data['utama'] = 1;
                } else {
                    $data['utama'] = 0;
                }

                if($_POST['id'] == 0) {

                    $this -> db -> insert('alamat', $data);
                    echo json_encode(['status' => 1, 'msg' => 'Alamat baru sudah ditambahkan']);
                    
                } else {
                    $this -> db -> update('alamat', $data, ['id' => $_POST['id']]);
                    echo json_encode(['status' => 1, 'msg' => 'Data alamat sudah diupdate']);
                }
            }

        }
    }

    public function hps_addr() {
        $id = $_POST['id'];
        $this -> db -> delete('alamat', ['id' => $id]);

        echo json_encode(['status' => 1, 'msg' => 'Data alamat sudah diupdate']);
    }

    public function pilih_addr() {
        $id = $_POST['id'];
        $sesi = $this -> session -> ci_usrid;
        $this -> db -> update('alamat', ['utama' => 0], ['usrid' => $sesi]);
        $this -> db -> update('alamat', ['utama' => 1], ['id' => $id]);

        echo json_encode(['status' => 1, 'msg' => 'Data alamat sudah diupdate']);
    }

    public function buat_pesanan() {
        $keranjang = $this -> app -> get_keranjang(false);
        $fisik     = isset($keranjang['Fisik']) ? $keranjang['Fisik'] : null;
        $digital   = isset($keranjang['Digital']) ? $keranjang['Digital'] : null;
        $kodetrx   = 'TRX' . date('ymdHis') . rand(111, 999);
        
        $cart          = [];
       
        foreach($keranjang as $item) {
            $cart[] = [
                'sku'       => $item -> id_produk,
                'name'      => $item -> nama_produk,
                'quantity'  => $item -> jml,
                'price'     => $item -> harga,
            ];
        }


        if($digital) {
            $this -> load -> model('Payment_model', 'payment');
            $total = $this -> app -> total_keranjang('digital');
            
            // $transaksi = [
            //     'metode'   => 'BRIVA',
            //     'total'    => $total,
            //     'trxcode'  => $kodetrx,
            //     'nama'     => user('nama'),
            //     'email'    => user('email'),
            //     'nohp'     => user('nohp'),
            //     'cart'     => $cart,
            // ];

            // $req = $this -> payment -> request_transaction($transaksi);

            // print_r($req);
        }
    }
}

// Controller Proses
// Kode ini dibuat oleh codelingker