<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends CI_Controller {
	public function masuk() {
		$conf = [
			'title'        =>  'Masuk | ' . app('app_name'),
			'loading' 	   => true,
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('auth/login');
		$this -> load -> view('layout/footer');
	}

	public function daftar() {
		$conf = [
			'title'        =>  'Buat Akun | ' . app('app_name'),
			'loading' 	   => true,
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('auth/daftar');
		$this -> load -> view('layout/footer');
	}

	public function proses_login() {
		$email 		= $this -> input -> post('email', TRUE);
		$password 	= $this -> input -> post('password', TRUE);
		$cek 	    = $this -> app -> get_user($email);

		if(empty($email)) {
			echo json_encode(['status' => 0, 'msg' => 'Email belum diisi']);
			
		} else if(empty($password)) {
			echo json_encode(['status' => 0, 'msg' => 'Password belum diisi']);
			
		} else {
			if($cek) {
				if($cek -> email <> $email) {
					echo json_encode(['status' => 0, 'msg' => 'Email & password salah']);
	
				} else if(password_verify($password, $cek -> password)) {
					$this -> session -> set_userdata('ci_usrid', $cek -> id);
					echo json_encode(['status' => 1, 'msg' => 'Login berhasil']);
	
				} else {
					echo json_encode(['status' => 0, 'msg' => 'Email & password salah']);
				}
	
			} else {
				echo json_encode(['status' => 0, 'msg' => 'Akun tidak terdaftar']);
			}
		}

	}

	public function logout() {
		$this -> session -> unset_userdata('ci_usrid');
		redirect();
	}
}

// Controller Auth
// Kode ini dibuat oleh codelingker
