<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Akun extends CI_Controller {
    public function __construct() {
        parent::__construct();
        cek_log();
    }

	public function index() {
		$conf = [
			'title'        => 'Akun | ' . app('app_name'),
			'header_right' => true
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('akun/main');
		$this -> load -> view('layout/footer');
	}

	public function ubah() {
		$conf = [
			'title'      => 'Ubah Akun | ' . app('app_name'),
			'page_title' => 'Ubah Akun',
			'backto'     => site_url('akun'),   
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('akun/ubah');
		$this -> load -> view('layout/footer');
	}

	public function favorit() {
		$conf = [
			'title'  => 'Favorit | ' . app('app_name'),
			'data'	 => $this -> app -> get_favorit(),
			'page_title' => 'Favorit',
			'backto'     => site_url('akun'),   
		];

		$this -> load -> view('layout/head', $conf);
		$this -> load -> view('layout/header');
		$this -> load -> view('akun/favorit');
		$this -> load -> view('layout/footer');
	}

	public function alamat($page = 'main') {
		if($page == 'form') {
			$title   = isset($_GET['aksi']) && $_GET['aksi'] == 'tambah' ? 'Tambah Alamat' : 'Edit Alamat';
			$data    = isset($_GET['aksi']) && isset($_GET['id']) ? $this -> app -> get_alamat($_GET['id']) : null;
			$primary = $this -> app -> get_alamat('cek_primary');
			
			$conf = [
				'title'  	 => $title . ' | ' . app('app_name'),
				'data_prov'	 => $this -> app -> get_prov(),
				'form_title' => $title,
				'data' 		 => $data,
				'page_title' => 'Tambah Alamat',
				'primary' 	 => $primary
			];
	
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/alamat_add');
			$this -> load -> view('layout/footer');

		} else {
			$conf = [
				'title'  	 => 'Alamat saya | ' . app('app_name'),
				'data'	 	 => $this -> app -> get_alamat(),
				'page_title' => 'Alamat Saya',
				'backto'     => site_url('akun'),   
			];
	
			$this -> load -> view('layout/head', $conf);
			$this -> load -> view('layout/header');
			$this -> load -> view('akun/alamat');
			$this -> load -> view('layout/footer');

		}
	}

}

// Controller Akun
// Kode ini dibuat oleh codelingker