<ul class="list-group list-group-flush custom-list">
    <?php 
        $toko  = $this -> session -> mart_toko;
        $level = $this -> session -> mart_level;
        $admin = $this -> session -> id;
        
        if($input['filter']) {
            $this -> db -> where('jenis', $input['filter']);
        }
        
        if($level != 'owner') {
            $this -> db -> where('id_admin', $admin);
        }

        $this -> db -> limit(7);
        $this -> db -> order_by('id', 'DESC');
        $this -> db -> where('total > ', 0);
        $this -> db -> where('id_toko', $toko);
        $data = $this -> db -> get('riwayat_transaksi') -> result();
        if($data) :
            foreach($data as $item) :
                $kode  = $item -> kode;
                $jenis = $item -> jenis == 1 ? "Penjualan" : 'Pembelian';
                $color = $item -> jenis == 1 ? "text-success " : 'text-danger ';
                $icon  = $item -> jenis == 1 ? "fa fa-shopping-bag" : 'fa fa-truck-ramp-box';
                $tgl   = date('d M Y H:i', strtotime($item -> tgl)) . ' WIB';
    ?>
    
        <li class="list-group-item d-flex justify-content-between align-items-start flex-wrap px-0 py-3">
            <div class="icon">
                <i class="<?= $icon . ' ' . $color ?>"></i>
            </div>
            <div class="text">
                <h6 class="mb-0 <?= $color ?> d-flex justify-content-between align-items-start">
                    <span>
                        <?= $jenis ?>
                    </span>
                    <span>
                        RM<?= form_uang($item -> total) ?>
                    </span>
                </h6>
                <small class="text-muted">
                    <?= $tgl ?>
                </small>
                <p class="mb-0 mt-2">
                    <code class="<?= $color ?>">
                        <?= $kode ?>
                    </code>
                </p>
            </div>
        </li>

    <?php endforeach ?>
    <?php endif ?>
    
</ul>

<?php if(empty($data)) : ?>
    <div class="alert alert-light mb-1 text-center">
        Belum ada transaksi
    </div>
<?php endif ?>