<div class="px-3 mb-3">
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="w-px-50"></th>
                <th>Kode</th>
            </thead>
            <tbody>
                <?php 
                    $toko       = $this -> session -> mart_toko;
                    $start      = $input['start'];
				    $end       	= $input['end'];
                    $limit      = $input['limit'];
                    $active     = $input['active'];
                    $jenis      = $input['jenis'];

                    if(!empty($input['cari'])) {
                        $this -> db -> where('kode', $input['cari']);
                    }

                    if(!empty($jenis)) {
                        $this -> db -> where('jenis', $jenis);
                    }

                    if(!empty($start) AND !empty($end)) {
                        $this -> db -> where('DATE(tgl) >=', $start);
                        $this -> db -> where('DATE(tgl) <=', $end);
                    }

                    $this -> db -> where('id_toko', $toko);
                    $total_data = $this -> db -> get('riwayat_transaksi') -> num_rows();
    
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                    ];

                    if(!empty($jenis)) {
                        $this -> db -> where('jenis', $jenis);
                    }

                    if(!empty($input['cari'])) {
                        $this -> db -> where('kode', $input['cari']);
                    }

                    if(!empty($start) AND !empty($end)) {
                        $this -> db -> where('DATE(tgl) >=', $start);
                        $this -> db -> where('DATE(tgl) <=', $end);
                    }

                    $this -> db -> where('id_toko', $toko);
                    $this -> db -> limit($limit, $offset);
                    $this -> db -> order_by('id', 'desc');
                    $data = $this -> db -> get('riwayat_transaksi') -> result();

                    if($data) :
                        foreach($data as $item) :
                            $kode = $item -> kode;
                            if($item -> jenis == 1) {
                                $get_jual   = $this -> db -> get_where('penjualan_data', ['kode' => $kode]) -> row();
                                $total      = $get_jual ? $this -> app -> get_total_jual($get_jual -> id) : null;
                                $jml        = $get_jual ? $this -> app -> get_jml_brg_jual($get_jual -> id) : null;
                                $id         = isset($get_jual -> id) ? $get_jual -> id : null;
                                $url        = 'proses/detail_riwayat_jual';
                                $jenis      = 'Penjualan';
                            }
                            if($item -> jenis == 2) {
                                $get_beli   = $this -> db -> get_where('pembelian_data', ['kode' => $kode]) -> row();
                                $total      = $this -> app -> get_total_beli($get_beli -> id);
                                $jml        = $this -> app -> get_jml_brg_beli($get_beli -> id);
                                $id         = $get_beli -> id;
                                $url        = 'proses/detail_riwayat_beli';
                                $jenis      = 'Pembelian';
                            }

                ?>
                    <tr>
                        <td class="text-center">
                            <button class="btn border" onclick="detail_riwayat('<?= $id ?>', '<?= site_url($url) ?>')">
                                <i class="fa fa-eye"></i>
                            </button>
                        </td>
                        <td>
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1 pe-3" style="min-width: 200px">
                                    <span class="me-1"><?= $jenis ?></span>
                                    <?php if($jml == '0 Barang') : ?>
                                        <span class="text-danger fa fa-info-circle"
                                            data-bs-toggle="tooltip"
                                            title="Semua item sudah di retur"
                                        ></span>
                                    <?php endif ?>
                                    <div>
                                        <small class="text-muted">
                                            <span><?= tgl(date('d M Y H:i', strtotime($item -> tgl))) ?> WIB</span>
                                        </small>
                                    </div>
                                    <p class="mb-0 mt-2">
                                        <code class="text-warning ">
                                            <?= $item -> kode ?>                    
                                        </code>
                                    </p>
                                </div>
                                <?php if($jml != '0 Barang') : ?>
                                    <div class="text-end">
                                        <h6 class="text-danger mb-0">
                                            <strong>Rp<?= form_uang($total) ?></strong>
                                        </h6>
                                        <small class="text-muted">
                                            <?= $jml ?> Barang
                                        </small>
                                    </div>
                                <?php endif ?>
                            </div>                                        
                        </td>
                    </tr>
                <?php endforeach ?>
                <?php endif ?>

                <?php if(!empty($cari) && count($data) == 0) : ?>
                    <tr>
                        <td colspan="2">
                            <div class="text-center">
                                Data tidak ditemukan
                            </div>
                        </td>
                    </tr>       
                <?php elseif(count($data) == 0) : ?>  
                    <tr>
                        <td colspan="2">
                            <div class="text-center">
                                Belum ada data
                            </div>
                        </td>
                    </tr>       
                <?php endif ?>  
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>