<div class="page_title row">
    <div class="col-md-7 mb-2">
        <h2>Riwayat</h2>
        <p>Riwayat Pembelian</p>
    </div>
    <div class="col-md-5">
        <div class="input-group">
            <input type="date" id="filter_start" 
                    class="form-control"
                    data-bs-toggle="tooltip"
                    title="Masukan filter tgl mulai"
                    value="<?= date('Y-m-d', strtotime('-1 month')) ?>"
            >
            <input type="date" id="filter_end" 
                    class="form-control"
                    data-bs-toggle="tooltip"
                    title="Masukan filter tgl selesai"
                    value="<?= date('Y-m-d') ?>"
            >
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card shadow-none" >
            <div class="card-header">
                <div class="row justify-content-between mt-3">
                    <div class="col-sm-2 mb-2">
                        <select class="form-select w-px-80 select2-nosrc" id="limiter">
                            <option>10</option>
                            <option selected>25</option>
                            <option>50</option>
                            <option>100</option>
                        </select>
                    </div>
                    <div class="col-sm-4 mb-2">
                        <input type="search" id="pencarian" class="form-control" placeholder="Cari Transaksi">
                    </div>
                </div>
            </div>
            <div class="card-body p-0" id="data">
                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_detail">
    <div class="modal-dialog modal-xl modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Riwayat
                        </strong>
                    </h5>
                    <small>
                        Detail riwayat penjualan
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                
            </div>
        </div>
    </div>
</div>

<form method="POST" class="modal fade" id="modal_retur">
    <div class="modal-dialog modal-xl modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Retur
                        </strong>
                    </h5>
                    <small>
                        Retur barang penjualan
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                
            </div>
            <div class="modal-footer border-0">
                <button class="btn btn-primary px-4">
                    Simpan
                </button>
                <a href="javascript:void(0)" class="btn" data-bs-dismiss="modal">
                    Batal
                </a>
            </div>
        </div>
    </div>
</form>

<script>
    $(function() {
        load_data(1);
    })

    function load_data(page) {
        $.post({
            url: base_url + 'proses/load_riwayat_jual',
            data: {
                start: $('#filter_start').val(),
                end: $('#filter_end').val(),
                cari: $('#pencarian').val(),
                limit: $('#limiter').val(),
                active: page,
            },
            dataType: 'html',
            success: data => {
                $('#data').html(data);
                tooltip()
            }
        })
    }

    function detail_riwayat(id) {
        $.post({
            url: base_url + 'proses/detail_riwayat_jual',
            data: {id:id},
            success: data => {
                $('#modal_detail').modal('show')
                                    .find('.modal-body')
                                    .html(data)
                ;
            }
        })
    }

    function retur_brg(id) {
        $.post({
            url: base_url + 'proses/load_penjualan_retur',
            data: {id:id},
            dataType: 'html',
            success: data => {
                $('#modal_retur').modal('show').find('.modal-content').html(data);
                tooltip();
            }
        })
    }

    function cetak_struk(url) {
        window.open(url);
    }

    $(document).on('change', '#limiter, #filter_start, #filter_end, #pencarian', function() {
        load_data(1);
    })

    $(document).on('submit', '#modal_retur', function(e) {
        e.preventDefault();
        let form = $(this);

        swal_simpan.fire({
            text: 'Harap untuk memeriksa kembali item yang dipilih sebelum disimpan, pastikan sudah benar. Data yang sudah disimpan tidak bisa diubah kembali.'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_retur_brg',
                    dataType: 'json',
                    data: form.serialize(),
                    success: json => {
                        $('.modal').modal('hide');
                        load_data(1);
                        if(json.success == 1) {
                            if(json.msg == 'selected-0') {
                                toast({
                                    icon: 'info',
                                    title: 'Tidak ada item yang dipilih'
                                })

                            } else {
                                toast({
                                    icon: 'success',
                                    title: json.msg
                                })
                            }

                        } else {
                            toast({
                                icon: 'error',
                                title: json.msg
                            })
                        }
                    }
                })
            }
        })
    })

</script>