<div class="px-3 mb-3">
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="w-px-80"></th>
                <th>Kode</th>
            </thead>
            <tbody>
                <?php 
                    $toko       = $this -> session -> mart_toko;
                    $admin      = $this -> session -> mart_id;
                    $level      = $this -> session -> mart_level;
                    $start      = $input['start'];
				    $end       	= $input['end'];
                    $limit      = $input['limit'];
                    $active     = $input['active'];

                    if(!empty($input['cari'])) {
                        $this -> db -> where('kode', $input['cari']);
                    }

                    if(!empty($start) AND !empty($end)) {
                        $this -> db -> where('DATE(tgl) >=', $start);
                        $this -> db -> where('DATE(tgl) <=', $end);
                    }

                    if($level != 'owner') {
                        $this -> db -> where('id_admin', $admin);
                    }
                    
                    $this -> db -> where('id_toko', $toko);
                    $total_data = $this -> db -> get('pembelian_data') -> num_rows();
    
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                    ];

                    if(!empty($start) AND !empty($end)) {
                        $this -> db -> where('DATE(tgl) >=', $start);
                        $this -> db -> where('DATE(tgl) <=', $end);
                    }

                    if(!empty($input['cari'])) {
                        $this -> db -> where('kode', $input['cari']);
                    }

                    if($level != 'owner') {
                        $this -> db -> where('id_admin', $admin);
                    }

                    $this -> db -> where('id_toko', $toko);
                    $this -> db -> limit($limit, $offset);
                    $this -> db -> order_by('id', 'desc');
                    $data = $this -> db -> get('pembelian_data') -> result();

                    if($data) :
                        foreach($data as $item) :
                            $total = $this -> app -> get_total_beli($item -> id);
                            $jml   = $this -> app -> get_jml_brg_beli($item -> id);

                ?>
                    <tr>
                        <td class="text-center">
                            <button class="btn border" onclick="detail_riwayat('<?= $item -> id ?>')">
                                <i class="fa fa-eye"></i>
                            </button>
                        </td>
                        <td>
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1 pe-3" style="min-width: 200px">
                                    <span><?= $item -> kode ?></span>
                                    <div>
                                        <small class="text-muted">
                                            <span><?= tgl(date('d M Y H:i', strtotime($item -> tgl))) ?> WIB</span>
                                        </small>
                                    </div>
                                </div>
                                <div class="text-end">
                                    <h6 class="text-danger mb-0">
                                        <strong>Rp<?= form_uang($total) ?></strong>
                                    </h6>
                                    <small class="text-muted">
                                        <?= $jml ?> Barang
                                    </small>
                                </div>
                            </div>                                        
                        </td>
                    </tr>
                <?php endforeach ?>
                <?php endif ?>

                <?php if(!empty($cari) && count($data) == 0) : ?>
                    <tr>
                        <td colspan="2">
                            <div class="text-center">
                                Data tidak ditemukan
                            </div>
                        </td>
                    </tr>       
                <?php elseif(count($data) == 0) : ?>  
                    <tr>
                        <td colspan="2">
                            <div class="text-center">
                                Belum ada data
                            </div>
                        </td>
                    </tr>       
                <?php endif ?>  
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>