<div id="table-responsive">
    <table class="table table-borderless table-sm">
        <tbody>
            <?php 
                $data  = $this -> db -> get_where('pembelian_data', ['id' => $input['id']]) -> row(); 
                $admin = $this -> db -> get_where('admin', ['id' => $data -> id_admin]) -> row(); 
            ?>
            <tr>
                <td class="w-px-100">Tanggal</td>
                <td class="w-px-20">:</td>
                <td><?= tgl(date('d M Y H:i', strtotime($data -> tgl))) ?> WIB</td>
            </tr>
            <tr>
                <td class="w-px-100">Kode</td>
                <td class="w-px-20">:</td>
                <td><?= $data -> kode ?></td>
            </tr>
            <tr>
                <td>Admin</td>
                <td>:</td>
                <td><?= $admin -> nama ?></td>
            </tr>
        </tbody>
    </table>
    <table class="table table-bordered mb-0">
        <thead class="table-light">
            <th>Item</th>
            <th class="text-center  w-px-80">
                Qty
            </th>
            <th class="text-center w-px-120">
                Satuan
            </th>
            <th class="text-end w-px-120">
                Harga Beli
            </th>
            <th class="text-start w-px-200">
                Supplier
            </th>
            <th class="text-end w-px-150">
                Total Harga
            </th>
        </thead>
        <tbody>
            <?php 
                $detail = $this -> db -> get_where('pembelian_detail', ['id_beli' => $input['id']]) -> result();
                $total  = 0;

                foreach($detail as $item) :
                    $brg      = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                    $satuan   = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();
                    $supplier = $this -> db -> get_where('supplier', ['id' => $item -> id_supplier]) -> row();

                    $subtotal = $item -> qty * $item -> harga_beli;
                    $total   += $subtotal;
            ?>
                <tr>
                    <td>
                        <?= isset($brg -> nama) ? $brg -> nama : '<em>Barang dihapus</em>' ?>
                    </td>
                    <td class="text-center">
                        <?= $item -> qty ?>
                    </td>
                    <td class="text-center">
                        <?= isset($satuan -> nama) ? $satuan -> nama : ''  ?>
                    </td>
                    <td class="text-end">
                        <?= form_uang($item -> harga_beli) ?>
                    </td>
                    <td>
                        <?= isset($supplier -> nama) ? $supplier -> nama : '-' ?>
                    </td>
                    <td class="text-end">
                        <?= form_uang($subtotal) ?>
                    </td>
                </tr>
            <?php endforeach ?>
            <tr class="table-light">
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th class="text-end text-danger">Total</th>
                <th class="text-end text-danger"><?= form_uang($total) ?></th>
            </tr>
        </tbody>
    </table>
</div>