<div class="card cart_list">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered mb-0">
                <thead>
                    <tr class="table-light">
                        <th class="w-px-80"></th>
                        <th>Item</th>
                        <th class="text-center w-px-80 ">Qty</th>
                        <th class="text-center w-px-120">Satuan</th>
                        <th class="text-end w-px-150">Harga</th>
                    </tr>
                </thead>
                <tbody id="load_data">
                    <?php
                        $toko  = $this -> session -> mart_toko;
                        $admin = $this -> session -> mart_id;

                        $this -> db -> where('id_toko', $toko);
                        $this -> db -> where('id_admin', $admin);
                        $this -> db -> where('id_jual', 0);
                        $get = $this -> db -> get('penjualan_detail') -> result();

                        $total       = 0;
                        $btn_disable = 'disabled';
                        
                        if($get) :
                            $btn_disable = null;
                            
                            foreach($get as $item) :
                                $subtotal = $item -> qty * $item -> harga_jual;
                                $total   += $subtotal; 

                                $barang = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                    ?>

                        <tr>
                            <td class="text-center">
                                <button class="btn btn-outline-danger border border-danger hps"
                                        data-id="<?= $item -> id ?>"
                                >
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                            <td>
                                <?= isset($barang -> nama) ? $barang -> nama : '-' ?>
                                <strong class="text-danger d-block">
                                    <?php 
                                        if($item -> is_grosir == 0) {
                                            echo 'Harga: ' . form_uang($item -> harga_jual);
                                            
                                        } else {
                                            echo 'Grosir: ' .  form_uang($item -> harga_jual);
                                        }
                                    ?>
                                </strong>
                            </td>
                            <td>
                                <input type="number" value="<?= $item -> qty ?>" data-id="<?= $item -> id ?>"
                                        class="form-control nochange w-px-80 text-center qty" 
                                >
                            </td>
                            <td>
                                <select class="form-select select2-nosrc w-px-120 id_satuan" 
                                        data-id="<?= $item -> id ?>" data-brg="<?= $item -> id_brg ?>"
                                >
                                    <?php 
                                        $this -> db -> where('stok > ', 0);
                                        $this -> db -> where('id_brg',  $item -> id_brg);
                                        $barang_satuan = $this -> db -> get('barang_satuan') -> result();

                                        foreach($barang_satuan as $bs) {
                                            $sa = $this -> db -> get_where('satuan', ['id' => $bs -> id_satuan]) -> row();
                                            $se = $bs -> id_satuan == $item -> id_satuan ? 'selected' : null;
                                            echo '
                                                <option value="'.$sa -> id.'" '.$se.'>
                                                    '.$sa -> nama.'
                                                </option>
                                            ';
                                        }
                                    ?>
                                </select>
                            </td>
                            <td class="text-end">
                                <strong>
                                    <?= form_uang($subtotal) ?>
                                </strong>
                            </td>
                        </tr>

                    <?php endforeach ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5">
                                <div class="text-center">
                                    Belum ada item
                                </div>
                            </td>
                        </tr>
                    <?php endif ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="form_pembayaran">
    <div class="card with-icon mb-2">
        <div class="card-body">
            <p class="mb-1">Total Belanja</p>
            <h4 class="text-danger total_text" data-total="<?= $total ?>">
                <?= form_uang($total) ?>
            </h4>
            <div class="card-icon d-flex">
                <i class="fa fa-dollar-sign"></i>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <button class="btn btn-primary w-100 mb-2 <?= $btn_disable ?>" id="btn_bayar">
                <strong>
                    Bayar
                </strong>
            </button>
            <button class="btn btn-danger w-100 <?= $btn_disable ?>" id="clear_cart">
                <strong>
                    Bersihkan
                </strong>
            </button>
        </div>
    </div>
</div>