<div class="page_title d-flex justify-content-between align-items-start">
    <div class="flex-grow-1">
        <h2>Pengaturan</h2>
        <p>Update</p>
    </div>
</div>

<?php if($this -> session -> mart_demo == 0) : ?>
    <form class="card">
        <div class="card-body pt-4">
            <div class="row">
                <div class="col-md-5">
                    <div class="msg warning">
                        <strong class="d-block mb-1">
                            <i class="fa fa-info-circle me-1"></i>
                            Catatan
                        </strong>
                        <span>Fitur ini hanya untuk update aplikasi saja.</span>
                    </div>
                    <div class="dashed rounded px-4 py-5 text-center o-hidden position-relative mb-3">
                        <label for="">
                            <i class="fa fa-upload fa-2x d-block text-muted mb-4"></i>
                            <span>Pilih atau tempelkan file update disini</span>
                        </label>
                        <input type="file" id="import_file_inp" name="file" accept=".zip">
                    </div>

                    <div class="file_info d-none">
                        <div class="msg light dashed w-100" style="z-index: 1">
                            <div class="text">
                                <span class="file_name">nama file.zip</span>
                                <small class="text-muted d-block">
                                    file size: <span class="file_size">0</span> KB
                                </small>
                            </div>
                        </div>
    
                        <div class="mt-5">
                            <button class="btn btn-primary w-100 py-3 btn_simpan">
                                <strong class="save_text">Update</strong>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <script>
        $(document).on('change', '#import_file_inp', function() {
            let file = this.files[0];

            if (file) {
                var reader = new FileReader();

                $('.file_name').text(file.name);
                $('.file_size').text(Math.round(file.size / 1000));
                $('.file_info').removeClass('d-none');
            }
        })

        $(document).on('submit', 'form', function(e) {
            e.preventDefault();
            let form = this;
            $('.save_text').text('Menyimpan').closest('button').addClass('disabled');
            $.post({
                url: base_url + 'proses/update_app', 
                data: new FormData(form),
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(json) {
                    if(json.success == 1) {
                        $('.save_text').text('Memuat ulang...')
                        toast({
                            title: json.msg,
                            icon: 'success',
                        })

                        setTimeout(() => {
                            location.reload();
                        }, 1200);

                    } else {
                        $('.save_text').text('Simpan').closest('button').removeClass('disabled');

                        if(json.msg == 'update-0') {
                            toast({
                                title: 'Tidak ada perubahan',
                                icon: 'info'
                            })

                        } else {
                            toast({
                                title: json.msg,
                                icon: 'error'
                            })
                        }
                    }
                },
                error: function(xhr, status, error) {
                    $('.save_text').text('Simpan').closest('button').removeClass('disabled');
                    toast({
                        title: 'Ada yang salah, coba lagi',
                        icon: 'error'
                    })
                }
            });
        })
    </script>
<?php else: ?>
    <div class="msg warning">
        <i class="fa fa-info-circle me-1"></i>
        Halaman ini tidak tersedia untuk akun demo
    </div>
<?php endif ?>