<?php 
    $uri_1     = $this -> uri -> segment(1); 
    $uri       = $this -> uri -> uri_string(); 
    $mart_toko = $this -> session -> mart_toko;
    $hide_menu = $uri == 'transaksi/penjualan' || $uri == 'transaksi/pembelian' || $uri_1 == 'profil' || $uri == 'barang/opname/tambah' ? 'collp-menu' : null;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?= $title ?></title>

    <link rel="shortcut icon" href="<?= base_url('uploads/' . $this -> app -> get_app('logo')) ?>" type="image/x-icon">

    <link rel="stylesheet" href="<?= base_url() ?>assets/vendor/bs/bs.min.css">
    <link rel="stylesheet" href="<?= base_url() ?>assets/vendor/font/fa/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url() ?>assets/vendor/select2/select2.min.css">
    <link rel="stylesheet" href="<?= base_url() ?>assets/vendor/select2/bootstrap-5-theme.min.css">
    <link rel="stylesheet" href="<?= base_url() ?>assets/css/main.css">
    <link rel="stylesheet" href="<?= base_url() ?>assets/css/mod.css">

    <script src="<?= base_url() ?>assets/vendor/jQuery/jquery.min.js"></script>
    <script src="<?= base_url() ?>assets/vendor/bs/bs.bundle.min.js"></script>
    <script src="<?= base_url() ?>assets/vendor/select2/select2.min.js"></script>
    <script src="<?= base_url() ?>assets/vendor/sweetalert/sweetalert.all.min.js"></script>

    <script>
        const base_url = '<?= site_url() ?>';

        const swal_hps_item = Swal.mixin({
            icon: 'question',
            title: 'Apakah anda yakin?',
            text: 'Item yang sudah dihapus tidak dapat dikembalikan',
            showCancelButton: true,
            cancelButtonText: 'Batal',
            confirmButtonText: 'Hapus',
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger px-4 me-2',
                cancelButton: 'btn btn-light px-3'
            }
        })

        const swal_simpan = Swal.mixin({
            icon: 'question',
            title: 'Apakah anda yakin?',
            text: 'Pastikan semua data sudah diisi dengan benar',
            showCancelButton: true,
            cancelButtonText: 'Batal',
            confirmButtonText: 'Simpan',
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-primary px-4 me-2',
                cancelButton: 'btn btn-light px-3'
            }
        })
    </script>
</head>
<body class="o-hidden <?= $hide_menu ?>">
    <div class="loading">
        <div class="text-center">
            <div class="animasi"></div>
            <p class="mt-2 mb-0">
                <strong>
                    Mohon Bersabar        
                </strong>
            </p>
        </div>
    </div>

    <!-- header area -->
    <header>
        <div>
            <div class="_left">
                <h1 class="web_title">
                    <a 
                        href="javascript:void(0)" 
                        <?= 
                            $this -> session -> mart_level == 'owner' ? 'onclick="load_toko()"' : null 
                        ?> 
                    >
                        <?= $this -> app -> get_toko($mart_toko, 'nama') ?>
                    </a>
                </h1>
                
                <?php $this -> app -> get_menu() ?>
            </div>
    
            <div class="btn-coll-menu">
                <button></button>
                <a 
                    href="javascript:void(0)" 
                    <?= 
                        $this -> session -> mart_level == 'owner' ? 'onclick="load_toko()"' : null 
                    ?>
                >
                    <?= $this -> app -> get_toko($mart_toko, 'cabang_label') ?>
                </a>
            </div>
    
            <div class="_right">
                <ul class="d-flex justify-content-between flex-wrap align-items-center">
                    <li class="menu">
                        <button data-bs-toggle="dropdown">
                            <i class="fa fa-bell"></i>
                            <?php 
                                $jml_stok_kosong    = $this -> app -> jml_stok_kosong();
                                $jml_brg_kadaluarsa = $this -> app -> jml_brg_kadaluarsa();
                                $jml_transaksi      = $this -> app -> jml_transaksi('hari_ini');
                                $count_notif        = $jml_brg_kadaluarsa + $jml_stok_kosong + $jml_transaksi;
                                
                                echo  $count_notif > 0 ? '<span></span>' : null;
                            ?>
                            
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end pb-2">
                            <li><h6 class="dropdown-header">Notifikasi</h6></li>
                            <li class="pt-2">
                               <button class="dropdown-item pb-2" onclick="redirect('barang/data?filter=stok_kosong')">
                                    <div class="icon bg-danger">
                                        <i class="fa fa-box-open text-white"></i>
                                    </div>
                                    <div class="text">
                                        <h6 class="mb-1 text-danger">
                                            <strong>
                                                Stok Kosong
                                            </strong>
                                        </h6>
                                        <small class="text-muted">
                                            <?php  
                                                echo $jml_stok_kosong > 10 
                                                     ? '10+ Barang' : $jml_stok_kosong . ' Barang';
                                            ?>
                                        </small>
                                    </div>
                               </button>
                            </li>
                                                       
                            <li class="pt-2">
                               <button class="dropdown-item pb-2" onclick="redirect('barang/data?filter=kadaluarsa')">
                                    <div class="icon bg-warning">
                                        <i class="fa fa-calendar text-white"></i>
                                    </div>
                                    <div class="text">
                                        <h6 class="mb-1 text-warning">
                                            <strong>
                                                Sudah Kadaluarsa
                                            </strong>
                                        </h6>
                                        <small class="text-muted">
                                            <?php  
                                                echo $jml_brg_kadaluarsa > 10 
                                                     ? '10+ Barang' :  $jml_brg_kadaluarsa . ' Barang';
                                            ?>
                                        </small>
                                    </div>
                               </button>
                            </li>
                                                       
                            <li class="pt-2">
                               <button class="dropdown-item pb-2" onclick="redirect('riwayat/semua?filter=hari_ini')">
                                    <div class="icon bg-primary">
                                        <i class="fa fa-arrow-right-arrow-left text-white"></i>
                                    </div>
                                    <div class="text">
                                        <h6 class="mb-1 text-primary">
                                            <strong>
                                                Transaksi 
                                            </strong>
                                        </h6>
                                        <small class="text-muted">
                                            <?php  
                                                echo $jml_transaksi > 10 
                                                     ? '10+ Aktivitas hari ini' :  $jml_transaksi . ' Aktivitas hari ini';
                                            ?>
                                        </small>
                                    </div>
                               </button>
                            </li>
                                                       
                        </ul>
                    </li>
                    <li>
                        <?php 
                            $bg = $this -> session -> mart_level;
                            $bg = $bg == 'kasir' ? 'bg-warning' : ($bg == 'admin' ? 'bg-danger' : 'bg-primary');
                        ?>
                        <div class="_img" data-bs-toggle="dropdown">
                            <strong class="text-init <?= $bg ?> text-white text-sm">
                                <?= $this -> app -> get_init_name() ?>
                            </strong>
                            <span></span>
                        </div>
                        <ul class="dropdown-menu dropdown-menu-end py-0">
                            <li class="text-center py-4 px-3">
                                <div class="img">
                                    <strong class="text-init <?= $bg ?> text-white text-lg">
                                        <?= $this -> app -> get_init_name() ?>
                                    </strong>
                                </div>
                                <h6 class="mb-0">
                                    <strong>
                                        <?= $this -> app -> get_admin('nama') ?>
                                    </strong>
                                </h6>
                                <small class="text-muted">
                                    <?= ucwords($this -> app -> get_admin('level')) ?>
                                </small>
                            </li>
                            <li>
                                <button class="dropdown-item py-2" onclick="redirect('profil')">
                                    <i class="fa fa-user me-2"></i>
                                    Profil Saya
                                </button>
                            </li>
                            <li>
                                <button class="dropdown-item py-2" onclick="redirect('profil/sandi')">
                                    <i class="fa fa-user-lock me-2"></i>
                                    Kata Sandi
                                </button>
                            </li>
                            <li>
                                <button class="dropdown-item py-2" onclick="redirect('profil/aktivitas')">
                                    <i class="fa fa-file me-2"></i>
                                    Aktivitas saya
                                </button>
                            </li>
                            <li>
                                <button class="dropdown-item py-2 text-danger logout">
                                    <i class="fa fa-sign-out me-2"></i>
                                    Keluar
                                </button>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </header>
    
    <!-- main area -->
    <main>
        <?php 
            echo $contents
        ?>
    </main>

    <form method="POST" class="modal fade" id="modal_add_toko">
        <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
            <div class="modal-content">
                <div class="modal-header border-0">
                    <div>
                        <h5 class="modal-header-title mb-0">
                            <strong>
                                Toko
                            </strong>
                        </h5>
                        <small>
                            Tambah toko baru
                        </small>
                    </div>
                    <a href="javascript:void(0)" 
                        class="btn-close" 
                        data-bs-dismiss="modal"
                    ></a>
                </div>

                <div class="modal-body">
                    <input type="hidden" name="idtoko" value="0">
                            
                    <div class="row mb-3">
                        <div class="col-sm-4 mb-2">
                            <strong class="d-block">Nama Toko </strong>
                            <small class="text-muted">
                                Masukan nama toko
                            </small>
                        </div>
                        <div class="col-sm-8">
                            <input type="text"required 
                                class="form-control" 
                                name="namatoko" 
                            >
                        </div>
                    </div>
                
                    <div class="row mb-3">
                        <div class="col-sm-4 mb-2">
                            <strong class="d-block">Alamat</strong>
                            <small class="text-muted">
                                Masukan alamat toko
                            </small>
                        </div>
                        <div class="col-sm-8">
                            <input type="text"required 
                                class="form-control" 
                                name="alamatoko" 
                            >
                        </div>
                    </div>
                                
                </div>
                
                <div class="modal-footer border-0">
                    <button class="btn btn-primary px-4 btn_submit_toko" >
                        Simpan
                    </button>
                    <a href="javascript:void(0)" 
                    class="btn btn-light" 
                    data-bs-dismiss="modal"
                    >
                        Batal
                    </a>
                </div>
            </div>
        </div>
    </form>

    <?php if($this -> session -> mart_level == 'owner') : ?>
        <div class="offcanvas offcanvas-start" tabindex="-1" id="data_toko">
            <div class="offcanvas-header">
                <div class="offcanvas-title">
                    <h5 class="mb-0">
                        <strong>
                            Toko
                        </strong>
                    </h5>
                    <small class="text-muted">
                        List Data Toko
                    </small>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
            </div>
            <div class="offcanvas-body">
                <button class="btn btn-primary mb-4 px-4 btn_add_toko">
                    <i class="fa fa-plus me-1"></i>
                    Baru
                </button>
                <div class="toko_list">
                    
                </div>
            <div>
        </div>
    <?php endif ?>

    <script>
        $(function() {
            // showing submenu
            $('.nav_menu ul ul li.active').children()
                                          .closest('ul')
                                          .slideDown(0).prev()
                                          .addClass('show_submenu')
            ;

            select2();
            tooltip();
        });

        <?php if($this -> session -> mart_level == 'owner') : ?>
            function load_toko() {
                $.post({
                    url: base_url + 'proses/load_toko',
                    dataType: 'html', 
                    success: data => {
                        $('#data_toko').offcanvas('show').find('.toko_list').html(data);
                    }
                })
            }

            function ubah_toko(id) {
                $.post({
                    url: base_url + 'proses/get_toko',
                    data: {id:id},
                    dataType: 'json',
                    success: json => {
                        $('#modal_add_toko').modal('show')
                                            .find('#modal_add_toko .modal-header-title small')
                                            .text('Ubah data toko')
                        ;

                        $('[name="idtoko"]').val(json.id);
                        $('[name="namatoko"]').val(json.nama);
                        $('[name="alamatoko"]').val(json.alamat);

                        if(json.cabang == "1") {
                            $('.btn_submit_toko').addClass('d-none');
                        } else {
                            $('.btn_submit_toko').removeClass('d-none');
                        }
                    }
                })
            }

            function hapus_toko(id, nama) { 
                <?php if($this -> session -> mart_demo == 1) : ?>
                    swal_hps_item.fire({
                        icon: 'warning',
                        title: 'Catatan',
                        text: 'Fitur ini tidak tersedia diakun demo.',
                        confirmButtonText: 'Tanya developer'
                    }).then(res => {
                        if(res.isConfirmed) {
                            window.open('https://wa.me/6282236676620');
                        }
                    })

                <?php else: ?> 

                    swal_hps_item.fire().then(res => {
                        if(res.isConfirmed) {
                            $.post({
                                url: base_url + 'proses/hapus_toko', 
                                data: {
                                    id:id,
                                    nama:nama
                                },
                                success: data => {
                                    if(data == '') {
                                        load_toko();
                                    }
                                }
                            })
                        }
                    })   

                <?php endif ?>        
            }

            function masuk_toko(id) { 
                swal_hps_item.fire({
                    text: 'Anda akan meninggalkan toko yang aktif saat ini',
                    confirmButtonText: 'Masuk'
                }).then(res => {
                    if(res.isConfirmed) {
                        $.post({
                            url: base_url + 'proses/masuk_toko', 
                            data: {
                                id:id,
                            },
                            success: data => {
                                if(data == '') {
                                    location.reload();
                                }
                            }
                        })
                    }
                })           
            }

            // Aksi menampilkan modal form toko
            $(document).on('click', '.btn_add_toko', function() {
                $('#modal_add_toko').trigger('reset')
                                    .modal('show')
                                    .find('[name="idtoko"]')
                                    .val(0)
                ;

                $('#modal_add_toko').find('#modal_add_toko .modal-header-title small')
                                    .text('Tambah toko baru')
                ;

                $('.btn_submit_toko').removeClass('d-none');
            })

            // Aksi simpan data toko
            $(document).on('submit', '#modal_add_toko', function(e) {
                e.preventDefault();
                let form = $(this);

                <?php if($this -> session -> mart_demo == 1) : ?>
                    swal_hps_item.fire({
                        icon: 'warning',
                        title: 'Catatan',
                        text: 'Fitur ini tidak tersedia diakun demo.',
                        confirmButtonText: 'Tanya developer'
                    }).then(res => {
                        if(res.isConfirmed) {
                            window.open('https://wa.me/6282236676620');
                        }
                    })

                <?php else: ?>    
                    $('.btn_submit_toko').addClass('disabled').text('Menyimpan...');
        
                    swal_simpan.fire().then(res => {
                        if(res.isConfirmed) {
                            $.post({
                                url: base_url + 'proses/submit_toko',
                                data: form.serialize(),
                                dataType: 'json',
                                success: json => {
                                    if(json.success == 1) {
                                        load_toko();
                                        form.modal('hide');
                                        $('.btn_submit_toko').removeClass('disabled').text('Simpan');
        
                                        if(json.msg == 'update-0') {
                                            toast({
                                                title: 'Tidak ada perubahan data',
                                                icon: 'info'
                                            })
                                            
                                        } else {
                                            toast({
                                                title: json.msg,
                                                icon: 'success'
                                            })
                                        }
                                        
                                    } else {
                                        $('.btn_submit_toko').removeClass('disabled').text('Simpan');
                                        toast({
                                            title: json.msg,
                                            icon: 'error'
                                        })
                                    }
                                }
                            })
                        } else {
                            $('.btn_submit_toko').removeClass('disabled').text('Simpan');
                        }
                    })
                <?php endif ?>
            })
        <?php endif ?>

        function select2() {
            $( '.select2-nosrc' ).select2({
                theme: 'bootstrap-5',
                minimumResultsForSearch: -1
            });
        }

        function redirect(url, type) {
            return window.location.href = type == undefined ? base_url + url : '<?= site_url() ?>' + url;
        }

        function salin(text) {
            navigator.clipboard.writeText(text).then(function() {
                toast({
                    icon: 'info',
                    title: 'Copy to clipboard'
                })
            }, function(err) {
                console.error('Async: Could not copy text: ', err);
            });
        }

        function toast(obj) {
            Swal.fire({
                toast: true,
                icon: obj.icon == undefined ? 'warning' : obj.icon,
                title: obj.title == undefined ? 'warning' : obj.title,
                position: 'top-end',
                showConfirmButton: false,
                timer: obj.timer == undefined ? 1800 : obj.timer,
                timerProgressBar: obj.progress == undefined ? false : obj.progress,
            })
        }
 
        function form_uang(angka){
            var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split   		= number_string.split(','),
            sisa     		= split[0].length % 3,
            rupiah     		= split[0].substr(0, sisa),
            ribuan     		= split[0].substr(sisa).match(/\d{3}/gi);
        
            // tambahkan titik jika yang di input sudah menjadi angka ribuan
            if(ribuan){
                separator = sisa ? '.' : '';
                rupiah += separator + ribuan.join('.');
            }
        
            return split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        }

        function tooltip() {
            // Tooltips
            const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
            const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
        }

        // aksi saat load semua data
        $(window).on('load', function() {
            $('.loading').fadeOut(function() {
                $('body').removeClass('o-hidden');
            })
        });

        // msg close
        $(document).on('click', '.msg .close', function() {
            $(this).closest('.msg').slideUp();
        });

        // showhide navmenu 
        $(document).on('click', '.btn-coll-menu button', function() {
            if($('body').hasClass('hide_menu')) {
                $('body').removeClass('hide_menu').addClass('fadein_menu');
                setTimeout(function() {
                    $('body').removeClass('fadein_menu');
                }, 400)
            } else {
                $('body').addClass('hide_menu').addClass('fadeout_menu');
                setTimeout(function() {
                    $('body').removeClass('fadeout_menu');
                }, 400)
            }
        });

        // according nav menu
        $(document).on('click', '.nav_menu > ul > li:has(ul) > a', function(e){
            e.preventDefault();

            $(".nav_menu > ul > li:has(ul) > a").removeClass('show_submenu');
            $(".nav_menu ul ul").slideUp();

            if(!$(this).next().is(":visible")) {
                $(this).addClass('show_submenu').next().slideDown();

            }
        })

        // Aksi format uang
        $(document).on('input', '.form_uang', function() {
            $(this).val(form_uang(String(this.value)))
        })

        // Aksi logout
        $(document).on('click', '.logout', function() {
            swal_hps_item.fire({
                text: 'Anda akan keluar dari akun ini',
                confirmButtonText: 'Keluar'
            }).then(res => {
                if(res.isConfirmed) {
                    redirect('profil/logout')
                }
            })
        })

    </script>    
</body>
</html>