<div class="px-3">
    <div class="text-center mb-4">
        <h6 class="mb-1">
            <strong>Laporan Stok Barang</strong>
        </h6>
        <h3 class="mb-1">
            <strong>
                <?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?>
            </strong>
        </h3>
        <small>
            <?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?>
        </small>
        <hr>
        Bulan <br> <?= tgl(date('F Y')) ?> 
    </div>
    
    <div class="table-responsive mb-4">
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="text-center w-px-150">Kode</th>
                <th class="text-center">Item</th>
                <th class="w-px-100 text-center">Stok</th>
                <th class="w-px-120 text-center">Satuan</th>
            </thead>
            <tbody>
                <?php
                    $limit      = $input['limit'];
                    $active     = $input['active'];
                    $toko = $this -> session -> mart_toko;
    
                    $this -> db -> join('barang_satuan satuan', 'barang.id = satuan.id_satuan');
                    $this -> db -> where('satuan.id_toko', $toko);                    
                    $total_data = $this -> db -> get('barang') -> num_rows();
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                        'func'       => 'load_data'
                    ];
    
                    $this -> db -> select('kode, nama, id_brg, id_satuan, stok, harga_jual');  
                    $this -> db -> join('barang_satuan satuan', 'barang.id = satuan.id_brg');
                    $this -> db -> where('barang.id_toko', $toko);
                    $this -> db -> order_by('kode', 'DESC');
                    $this -> db -> limit($limit, $offset);
                    
                    $get = $this -> db -> get('barang') -> result();
    
                    foreach($get as $item) :
                        $satuan = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();
                ?>
                <tr>
                    <td>
                        <?= $item -> kode ?>
                    </td>
                    <td>
                        <?= $item -> nama ?>
                    </td>
                    <td class="text-center">
                        <?= $item -> stok ?>
                    </td>
                    <td class="text-center">
                        <?= isset($satuan -> nama) ? $satuan -> nama : '' ?>
                    </td>
                </tr>
                <?php endforeach ?>

                <?php if(empty($get)) : ?>
                    <tr>
                        <td colspan="4" class="text-center">
                            Belum ada item
                        </td>
                    </tr>
                <?php endif ?>
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>