<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/mod.css') ?>">
    <style>
        body {
            font-size: 16px;
        }
        h3, h6 {
            margin: 0 0 0.6rem;
        }
        h6 {
            font-size: 1rem;
        }
        h3 {
            font-size: calc(1.3rem + .6vw);
        }
        .text-center {
            text-align: center;
        }
        .text-end {
            text-align: right;
        }
        .mb-4 {
            margin-bottom: 1.5rem!important;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        table th, table td {
            border: 1px solid #000;
            padding: 5px;
        }
    </style>
</head>
<body>
    <div class="text-center mb-4">
        <h6 class="mb-1">
            <strong>Laporan Stok Opname</strong>
        </h6>
        <h3 class="mb-1">
            <strong>
                <?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?>
            </strong>
        </h3>
        <small>
            <?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?>
        </small>
        <hr>
        
        <?php if($input['start_date'] == date('Y-m-d')) : ?>
            Hari ini
        <?php elseif($input['start_date'] == $input['end_date']) : ?>
            Tanggal <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>
        <?php else: ?>
            Periode <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>  ~ <?= tgl(date('d F Y', strtotime($input['end_date']))) ?>
        <?php endif ?>
    </div>
    
    <table class="table table-bordered">
        <thead class="table-light">
            <th class="text-center w-px-150">Tanggal</th>
            <th class="w-px-150 text-center">Kode</th>
            <th class="text-center">Petugas</th>
            <th class="w-px-100 text-center">Stok Valid</th>
            <th class="w-px-120 text-center">Stok Invalid</th>
        </thead>
        <tbody>
            <?php
                $toko = $this -> session -> mart_toko;

                $this -> db -> from('opname_data');
                if(!empty($input['start_date']) AND !empty($input['end_date'])) {
                    $this -> db -> where('DATE(tgl) >=', $input['start_date']);
                    $this -> db -> where('DATE(tgl) <=', $input['end_date']);
                }
                $this -> db -> where('id_toko', $toko);
                $this -> db -> order_by('id', 'DESC');
                $get        = $this -> db -> get() -> result();
                
                if($get) :
                    foreach($get as $item) :
                        $admin        = $this -> db -> get_where('admin', ['id' => $item -> id_admin]) -> row();
                        $stok_valid   = $this -> app -> get_stok_valid($item -> id);
                        $stok_invalid = $this -> app -> get_stok_invalid($item -> id);
                        
            ?>

                <tr>
                    <td class="text-center">
                        <?= tgl(date('d M Y', strtotime($item -> tgl))) ?>
                    </td>
                    <td class="text-center">
                        <?= $item -> kode ?>
                    </td>

                    <td>
                        <?= $admin -> nama ?>
                    </td>

                    <td class="text-center">
                        <?= $stok_valid ?>
                    </td>

                    <td class="text-center">
                        <?= $stok_invalid ?>
                    </td>
                </tr>

            <?php endforeach ?>
            <?php endif ?>


            <?php if(empty($get)) : ?>
                <tr>
                    <td colspan="6" class="text-center">
                        Belum ada item
                    </td>
                </tr>
            <?php endif ?>
        </tbody>
    </table>
    
    <script src="<?= base_url() ?>assets/vendor/jQuery/jquery.min.js"></script>
    <script>
        if($(window).width() > 768) {
            setTimeout(function () { window.print(); }, 0);
            window.onload = function () { setTimeout(function () { window.close(); }, 0); }
        } else {
            print();
        }
    </script>
</body>
</html>
