<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - <?= $data -> kode ?></title>

    <style>
        body {
            padding: 0;
            margin: 0;
            font-family: monospace;
        }
        table {
            width: 100%;
            margin-bottom: 10px;
        }
        table th {
            text-align: left;
        }
        table th, table td {
           vertical-align: top;
        }
        h1, p {
            margin: 0;
        }
        .header {
            margin-bottom: 10px;
        }
        .container {
            max-width: <?= $this -> app -> get_app('thermal_size') ?>mm;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .detail, .info tr:nth-child(2) td {
            border-top: 1px dashed #000;
        }
        .info tr:nth-child(2) td {
            padding-top: 10px;
        }
        .detail tbody td, .detail {
            border-bottom: 1px dashed #000;
            padding-top: 7px;
            padding-bottom: 10px;
        }
        .info tbody td, .detail tfoot th {
            padding-bottom: 5px;
        }
        .qty {
            margin-top: 5px;
        }
        .padding {
            padding: 5px;
        }
        .thanks {
            text-align: center;
            margin-top: 30px;
        }

        @page {
            margin-top: 0;
            margin-bottom: 0;
            margin-left: 15px;
        }
    </style>
</head>
<body>
    <?php if($data -> belanjaan) : ?>
        <div class="container">
            <table class="info">
                <tr>
                    <td colspan="3">
                        <div class="text-center header">
                            <h1><?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?></h1>
                            <p><?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?></p>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>Tanggal</td>
                    <td>:</td>
                    <td><?= $data -> tgl ?></td>
                </tr>
                <tr>
                    <td>NOTA</td>
                    <td>:</td>
                    <td><?= $data -> kode ?></td>
                </tr>
                <tr>
                    <td>Pelanggan</td>
                    <td>:</td>
                    <td><?= $data -> plg ?></td>
                </tr>
                <tr>
                    <td>Kasir</td>
                    <td>:</td>
                    <td><?= $data -> admin ?></td>
                </tr>
            </table>
        
            <table class="detail">
                <tbody>
                    <?php foreach($data -> belanjaan as $belanja) : ?>
                        <?php $satuan = $this -> db -> get_where('satuan', ['id' => $belanja -> id_satuan]) -> row() ?>
                        <tr>
                            <td>
                                <span>
                                    <?= $belanja -> barang ?>
                                </span>
                                <div class="qty">
                                    <?= $belanja -> qty ?> 
                                    <?= isset($satuan -> nama) ? $satuan -> nama : '' ?> 
                                    x 
                                    <?= form_uang($belanja -> harga_jual) ?>
                                </div>
                            </td>
                            <td class="text-right">
                                <?= form_uang($belanja -> qty * $belanja -> harga_jual) ?>
                            </td>
                        </tr>
                    <?php endforeach ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td class="padding" colspan="3"></td>
                    </tr>
                    <tr>
                        <th>Total Belanja</th>
                        <th class="text-right">
                            <?= form_uang($data -> total) ?>
                        </th>
                    </tr>
                    <tr>
                        <th>Diskon</th>
                        <th class="text-right">
                            <?= form_uang($data -> diskon) ?>
                        </th>
                    </tr>
                    <tr>
                        <th>Tunai</th>
                        <th class="text-right">
                            <?= form_uang($data -> bayar) ?>
                        </th>
                    </tr>
                    <tr>
                        <th>Kembalian</th>
                        <th class="text-right">
                        <?= form_uang(
                            $data -> bayar - ($data -> total - $data -> diskon)
                        ) ?>
                        </th>
                    </tr>
                </tfoot>
            </table>
        
            <div class="thanks">
                Terima Kasih
            </div>
        </div>
        
        <script src="<?= base_url() ?>assets/vendor/jQuery/jquery.min.js"></script>
        <script>
            if($(window).width() > 768) {
                setTimeout(function () { window.print(); }, 0);
                window.onload = function () { setTimeout(function () { window.close(); }, 0); }
            } else {
                print();
            }
        </script>

    <?php endif ?>
</body>
</html>