<div class="table-responsive">
    <table class="table table-bordered" id="table-detail-opname">
        <thead class="table-light">
            <tr>
                <th class="w-px-80" rowspan="2"></th>
                <th rowspan="2" class="text-center">Item</th>
                <th colspan="2" class="text-center text-center">Stok</th>
                <th rowspan="2" class="text-center w-px-150 text-center">Satuan</th>
                <th rowspan="2" class="w-px-120 text-center">
                    Selisih
                    <span class="fa fa-info-circle"
                            data-bs-toggle="tooltip"
                            data-bs-html="true"
                            title="
                                <div class='text-start'>
                                    <strong class='d-block'>Selisih:</strong>
                                    Stok yang tersedia dikurangi stok yang ada di sistem
                                </div>
                            "
                    ></span>
                </th>
                <th rowspan="2" class="w-px-280 text-center">Keterangan</th>
            </tr>
            <tr>
                <th class="w-px-120 text-center">
                    Sistem
                    <span class="fa fa-info-circle"
                            data-bs-toggle="tooltip"
                            title="Stok tersedia di sistem / aplikasi"
                    ></span>
                </th>
                <th class="w-px-120 text-center">
                    Fisik
                    <span class="fa fa-info-circle"
                            data-bs-toggle="tooltip"
                            title="Stok tersedia di rak"
                    ></span>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php  
                $toko  = $this -> session -> mart_toko;
                $admin = $this -> session -> mart_id;

                $this -> db -> where('id_toko', $toko);
                $this -> db -> where('id_admin', $admin);
                $this -> db -> where('id_opname', 0);
                $this -> db -> order_by('id', 'DESC');

                $data  = $this -> db -> get_where('opname_detail') -> result();

                if($data) :
                    foreach($data as $item) :
                        $barang = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                        $satuan = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();
                        $barang_satuan = $this -> app -> get_barang_satuan($item -> id_brg);
                        $selisih = $item -> stok_fisik > 0 ? $item -> stok_fisik - $item -> stok_sistem : 0;

            ?>

                <tr>
                    <td class="w-px-80 text-center">
                        <button class="btn btn-outline-danger border border-danger hps_item" data-id="<?= $item -> id ?>">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                    <td>
                        <?= $barang -> nama ?>
                    </td>
                    <td>
                        <input type="text" class="form-control w-px-120 text-center stok_sistem" value="<?= $item -> stok_sistem ?>" disabled>
                    </td>
                    <td>
                        <input type="number" class="form-control w-px-120 nochange text-center stok_fisik" value="<?= $item -> stok_fisik ?>" data-id="<?= $item -> id ?>">
                    </td>
                    <td>
                        <select class="form-select w-px-150 select2-nosrc id_satuan" data-id="<?= $item -> id ?>">
                            <?php 
                                foreach($barang_satuan as $bs) {
                                    $select = $bs -> id_satuan == $item -> id_satuan ? 'selected' : null;
                                    echo '
                                        <option value="'.$bs -> id_satuan.'" '.$select.'>
                                            '.$bs -> satuan.'
                                        </option>
                                    ';
                                } 
                            ?>
                        </select>
                    </td>
                    <td>
                        <input type="number" class="form-control w-px-120 nochange text-center" value="<?= $selisih  ?>" disabled>
                    </td>
                    <td>
                        <input type="text" class="form-control w-px-280 note" data-id="<?= $item -> id ?>" value="<?= $item -> keterangan  ?>">
                    </td>
                </tr>

            <?php endforeach ?>
            <?php else: ?>
                <tr>
                    <td class="text-center" colspan="7">
                        Belum ada item
                    </td>
                </tr>
            <?php endif ?>
        </tbody>
    </table>
</div>

<?php if($data) : ?>
    <div class="mt-4 text-end">
        <button class="btn btn-primary px-4 simpan_opname">
            Simpan
        </button>
        <a href="<?= site_url('barang/opname') ?>" class="btn">
            Kembali
        </a>
    </div>
<?php endif ?>