<div class="table-responsive mt-3 mb-4 px-3">
    <table class="table table-bordered">
        <thead>
            <tr class="table-light">
                <th class="w-px-50"></th>
                <th>Kode</th>
            </tr>
        </thead>
        <tbody id="load">
            <?php 
                $cari       = $input['cari'];
                $limit      = $input['limit'];
                $active     = $input['active'];
                $toko       = $this -> session -> mart_toko;

                $this -> db -> like('kode', $cari);
                $this -> db -> where('id_toko', $toko);
                $total_data = $this -> db -> get('opname_data') -> num_rows();
                
                $offset     = $limit * ($active - 1);
                $max_page   = ceil(($total_data / $limit) + 1);
                
                $pagination = [
                    'active'     => $active,
                    'max_page'   => $max_page,
                ];
                
                $this -> db -> like('kode', $cari);
                $this -> db -> limit($limit, $offset);
                $this -> db -> order_by('id', 'DESC');
                $this -> db -> where('id_toko', $toko);
                $data = $this -> db -> get('opname_data') -> result();

                if($data) :
                    foreach($data as $item) : 
                        $jml = $this -> app -> jml_brg_opname($item -> id);
            ?>
                <tr>
                    <td class="text-center">
                        <button class="fa fa-ellipsis-v btn_detail_item" data-bs-toggle="dropdown"></button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><h6 class="dropdown-header">Aksi</h6></li>
                            <li>
                                <button class="dropdown-item py-2 text-primary" onclick="detail('<?= $item -> id ?>')">
                                    <i class="fa fa-edit me-2"></i>
                                    Detail
                                </button>
                            </li>
                        </ul>
                    </td>
                    <td>
                        <span class="d-block">
                            <?= $item -> kode ?>
                        </span>
                        <small class="text-muted">
                            <?= tgl(date('d M Y', strtotime($item -> tgl))) ?> 
                            
                            <span class="mx-2"> | </span>
                            <?= $jml ?> Barang
                        </small>
                    </td>
                </tr>
            <?php endforeach ?>                  
            <?php endif ?>  
            
            <?php if(!empty($cari) && count($data) == 0) : ?>
                <tr>
                    <td colspan="2">
                        <div class="text-center">
                            Data tidak ditemukan
                        </div>
                    </td>
                </tr>       
            <?php elseif(count($data) == 0) : ?>  
                    <tr>
                        <td colspan="2">
                            <div class="text-center">
                                Belum ada data
                            </div>
                        </td>
                    </tr>       
            <?php endif ?>  
            
        </tbody>
    </table>
</div>

<?= $this -> app -> pagination($pagination) ?>
