<ul class="list-group list-group-flush custom-list">
    <?php 
        $toko  = $this -> session -> mart_toko;
        $bulan = date('m');
        $tahun = date('Y');
        
        $this -> db -> select('SUM(qty) as total_qty, SUM(qty * harga_jual) as total_harga, id_brg, id_satuan');
        $this -> db -> from('penjualan_detail detail');
        $this -> db -> join('penjualan_data data', 'data.id = detail.id_jual');
        $this -> db -> limit(7);
        $this -> db -> where('data.id_toko', $toko);
        $this -> db -> where("MONTH(data.tgl)", $bulan);
        $this -> db -> where("YEAR(data.tgl)", $tahun);
        $this -> db -> group_by('id_brg');
        $this -> db -> order_by('total_qty', 'DESC');
        $data = $this -> db -> get() -> result();

        if($data) :
            foreach($data as $item) :
                $barang = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                $icon  = "fa fa-shopping-bag";
    ?>
    
        <li class="list-group-item d-flex justify-content-between align-items-start flex-wrap px-0 py-3">
            <div class="icon text-success">
                <i class="<?= $icon ?>"></i>
            </div>
            <div class="text">
                <h6 class="mb-1 d-flex justify-content-between align-items-start">
                    <span>
                        <?= isset($barang -> nama) ? $barang -> nama : '<em>Barang dihapus</em>' ?>
                    </span>
                    <span class="text-success">
                        RM<?= form_uang($item -> total_harga) ?>
                    </span>
                </h6>
                <div class="mb-0 d-flex justify-content-between align-items-start">
                    <small class="text-muted">
                        <?= isset($barang -> kode) ? $barang -> kode : '' ?>
                    </small>
                    <small class="text-muted">
                        <?= $item -> total_qty ?> Terjual
                    </small>
                </div>
            </div>
        </li>

    <?php endforeach ?>
    <?php endif ?>
    
</ul>

<?php if(empty($data)) : ?>
    <div class="alert alert-light mb-1 text-center">
        Belum ada transaksi
    </div>
<?php endif ?>