<?php 
    $barang      = $this -> app -> get_barang_detail($id);
    $checked     = $barang -> is_grosir == 1 ? 'checked' : null;
    $is_grosir   = $barang -> is_grosir == 0 ? 'd-none' : null;
    $data_satuan = $this -> app -> get_barang_satuan($id);
?>
<div class="modal-header border-0">
    <div>
        <h5 class="modal-header-title mb-0">
            <strong>
                Barang
            </strong>
        </h5>
        <small>
            Grosir Barang
        </small>
    </div>
    <a href="javascript:void(0)" 
        class="btn-close" 
        data-bs-dismiss="modal"
    ></a>
</div>

<div class="modal-body">
    <input type="hidden" id="grosir_brg" name="grosir_brg" value="<?= $id ?>">
    <div class="alert alert-light">
        <div class="d-flex justify-content-between align-items-start">
            <p class="mb-1 me-4">
                <?= $barang -> nama ?>
            </p>
            <div class="form-check form-switch">
                <input class="form-check-input" 
                        value="0" 
                        type="checkbox" 
                        role="switch" id="is_grosir" 
                        data-id="<?= $id ?>"
                        name="is_grosir" <?= $checked ?>
                >
                <label class="form-check-label label-sw" for="is_grosir"></label>
            </div>
        </div>
        <small class="text-muted">
            Kode: <?= $barang -> kode ?>
        </small>
    </div>

    <div class="btn_add_grosir my-3 <?= $is_grosir ?>">
        <div class="row">
            <div class="col-sm-8 mb-2">
                <button class="btn btn-light btn-sm border">
                    <i class="fa fa-plus me-1"></i>
                    Tambah
                </button>
            </div>

            <div class="col-sm-4">
                <select class="form-select form-select-sm" name="grosir_satuan_brg" id="grosir_satuan_brg">
                    <?php foreach($data_satuan as $satuan) : ?>
                        <option value="<?= $satuan -> id_satuan ?>">
                            <?= $satuan -> satuan ?>
                        </option>
                    <?php endforeach ?>
                </select>
            </div>
        </div>
    </div>
        
    <div class="grosir_data <?= $is_grosir ?>">
                
    </div>    
</div>

<div class="modal-footer btn_grosir_aksi <?= $is_grosir ?>">
    <button class="btn btn-primary px-4">
        Simpan
    </button>
    <a href="javascript:void(0)" data-bs-dismiss="modal" class="btn">Batal</a>
</div>
