<?php

function menu_owner() {
    $data = [
        'Main Menu' => [
            [
                'nama'  => 'Dashboard',
                'icon'  => 'fa fa-home',
                'slug'  => 'home',
                'submenu' => null
            ],
            [
                'nama' => 'Barang',
                'icon' => 'fa fa-boxes',
                'slug' => 'barang',
                'submenu' => [
                    [
                        'nama' => 'Data',
                        'slug' => 'barang/data',
                        
                    ],
                    [
                        'nama' => 'Kategori',
                        'slug' => 'barang/kategori',
                        
                    ],
                    [
                        'nama' => 'Satuan',
                        'slug' => 'barang/satuan',
                        
                    ],
                    [
                        'nama' => 'Supplier',
                        'slug' => 'barang/supplier',
                        
                    ],
                    [
                        'nama' => 'Opname',
                        'slug' => 'barang/opname',
                        
                    ],
                ]
            ],
            [
                'nama' => 'Transaksi',
                'icon' => 'fa fa-arrow-right-arrow-left',
                'slug' => 'transaksi',
                'submenu' => [
                    [
                        'nama' => 'Penjualan',
                        'slug' => 'transaksi/penjualan',
                        

                    ],
                    [
                        'nama' => 'Pembelian',
                        'slug' => 'transaksi/pembelian',
                        
                    ]
                ]
            ],
            [
                'nama' => 'Riwayat',
                'icon' => 'fa fa-receipt',
                'slug' => 'riwayat',
                
                'submenu' => [
                    [
                        'nama' => 'Semua',
                        'slug' => 'riwayat/semua',
                        
                    ],
                    [
                        'nama' => 'Penjualan',
                        'slug' => 'riwayat/penjualan',
                        
                    ],
                    [
                        'nama' => 'Pembelian',
                        'slug' => 'riwayat/pembelian',
                        
                    ],
                    [
                        'nama' => 'Retur Barang',
                        'slug' => 'riwayat/retur',
                        
                    ],
                ]
            ],
            [
                'nama' => 'Laporan',
                'icon' => 'fa fa-chart-line',
                'slug' => 'laporan',
                'submenu' => [
                    [
                        'nama' => 'Stok Barang',
                        'slug' => 'laporan/stok',
                        
                    ],
                    [
                        'nama' => 'Pembelian',
                        'slug' => 'laporan/pembelian',
                        
                    ],
                    [
                        'nama' => 'Penjualan',
                        'slug' => 'laporan/penjualan',
                        
                    ],
                    [
                        'nama' => 'Retur Barang',
                        'slug' => 'laporan/retur',
                        
                    ],
                    [
                        'nama' => 'Opname',
                        'slug' => 'laporan/opname',
                        
                    ],
                    [
                        'nama' => 'Keuangan',
                        'slug' => 'laporan/keuangan',
                        'level' => 'owner',
                    ],
                ]
            ]
        ], 
        'Tambahan' => [
            [
                'nama' => 'Pelanggan',
                'icon' => 'fa fa-users',
                'slug' => 'pelanggan',
                'submenu' => null
            ],
            [
                'nama' => 'Karyawan',
                'icon' => 'fa fa-user',
                'slug' => 'karyawan',
                'level' => 'owner',
                'submenu' => null
            ],
            [
                'nama' => 'Pengaturan',
                'icon' => 'fa fa-cogs',
                'slug' => 'pengaturan',
                'level' => 'owner',
                'submenu' => [
                    [
                        'nama' => 'Umum',
                        'slug' => 'pengaturan/umum'
                    ],
                    [
                        'nama' => 'Tambahan',
                        'slug' => 'pengaturan/tambahan'
                    ],
                    [
                        'nama' => 'Update',
                        'slug' => 'pengaturan/update'
                    ],
                ]
            ],
        ]
    ];

    return $data;
}

function menu_kasir() {
    $data = [
        'Main Menu' => [
            [
                'nama'  => 'Dashboard',
                'icon'  => 'fa fa-home',
                'slug'  => 'home',
                
                'submenu' => null
            ],
           
            [
                'nama' => 'Transaksi',
                'icon' => 'fa fa-arrow-right-arrow-left',
                'slug' => 'transaksi',
                
                'submenu' => [
                    [
                        'nama' => 'Penjualan',
                        'slug' => 'transaksi/penjualan',
                        

                    ]
                ]
            ],
            [
                'nama' => 'Riwayat',
                'icon' => 'fa fa-receipt',
                'slug' => 'riwayat',
                
                'submenu' => [                    
                    [
                        'nama' => 'Penjualan',
                        'slug' => 'riwayat/penjualan',
                        
                    ],
                    [
                        'nama' => 'Retur Barang',
                        'slug' => 'riwayat/retur',
                        
                    ],
                ]
            ],
            [
                'nama' => 'Laporan',
                'icon' => 'fa fa-chart-line',
                'slug' => 'laporan',
                
                'submenu' => [
                    [
                        'nama' => 'Penjualan',
                        'slug' => 'laporan/penjualan',
                        
                    ],
                    [
                        'nama' => 'Retur Barang',
                        'slug' => 'laporan/retur',
                        
                    ],
                ]
            ]
        ], 
        'Tambahan' => [
            [
                'nama' => 'Pelanggan',
                'icon' => 'fa fa-users',
                'slug' => 'pelanggan',
                
                'submenu' => null
            ]           
        ]
    ];

    return $data;
}

function menu_admin() {
    $data = [
        'Main Menu' => [
            [
                'nama'  => 'Dashboard',
                'icon'  => 'fa fa-home',
                'slug'  => 'home',
                'submenu' => null
            ],
            [
                'nama' => 'Barang',
                'icon' => 'fa fa-boxes',
                'slug' => 'barang',
                'submenu' => [
                    [
                        'nama' => 'Data',
                        'slug' => 'barang/data',
                        
                    ],
                    [
                        'nama' => 'Kategori',
                        'slug' => 'barang/kategori',
                        
                    ],
                    [
                        'nama' => 'Satuan',
                        'slug' => 'barang/satuan',
                        
                    ],
                    [
                        'nama' => 'Supplier',
                        'slug' => 'barang/supplier',
                        
                    ],
                    [
                        'nama' => 'Opname',
                        'slug' => 'barang/opname',
                        
                    ],
                ]
            ],
            [
                'nama' => 'Transaksi',
                'icon' => 'fa fa-arrow-right-arrow-left',
                'slug' => 'transaksi',
                'submenu' => [
                    [
                        'nama' => 'Pembelian',
                        'slug' => 'transaksi/pembelian',
                        
                    ],
                ]
            ],
            [
                'nama' => 'Riwayat',
                'icon' => 'fa fa-receipt',
                'slug' => 'riwayat',                
                'submenu' => [
                    [
                        'nama' => 'Pembelian',
                        'slug' => 'riwayat/pembelian',                        
                    ],
                ]
            ],
            [
                'nama' => 'Laporan',
                'icon' => 'fa fa-chart-line',
                'slug' => 'laporan',
                'submenu' => [
                    [
                        'nama' => 'Stok Barang',
                        'slug' => 'laporan/stok',
                    ],
                    [
                        'nama' => 'Pembelian',
                        'slug' => 'laporan/pembelian',
                    ],
                    [
                        'nama' => 'Opname',
                        'slug' => 'laporan/opname',
                    ],
                ]
            ]
        ]
    ];

    return $data;
}

function get_menu() {
    $ci =& get_instance();
    $sesi = $ci -> session -> mart_level;
    return $sesi == 'admin' ? menu_admin() : ($sesi == 'kasir' ? menu_kasir() : menu_owner());
}

// Helper Menu
// Kode ini dibuat dan dikembangkan oleh codelingker